/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.compression.deflate;

import guilibshadow.cafe4j.image.compression.ImageEncoder;
import guilibshadow.cafe4j.util.Updatable;
import java.io.OutputStream;
import java.util.zip.Deflater;

public class DeflateEncoder
implements ImageEncoder {
    private byte[] buffer;
    private Deflater deflater;
    private OutputStream os;
    private Updatable<Integer> writer;
    private boolean isTIFF;

    public DeflateEncoder(OutputStream os, int bufferSize, int compressLevel) {
        this.os = os;
        this.buffer = new byte[bufferSize];
        this.deflater = new Deflater(compressLevel);
    }

    public DeflateEncoder(OutputStream os, int bufferSize, int compressLevel, Updatable<Integer> writer) {
        this(os, bufferSize, compressLevel);
        this.writer = writer;
        this.isTIFF = true;
    }

    @Override
    public void encode(byte[] pixels, int start, int len) throws Exception {
        int temp;
        this.deflater.setInput(pixels, start, len);
        this.deflater.finish();
        while (!this.deflater.finished() && (temp = this.deflater.deflate(this.buffer)) > 0) {
            this.os.write(this.buffer, 0, temp);
        }
    }

    @Override
    public void finish() throws Exception {
        if (this.isTIFF && this.writer != null) {
            this.writer.update(this.deflater.getTotalOut());
        }
    }

    @Override
    public int getCompressedDataLen() {
        return this.deflater.getTotalOut();
    }

    @Override
    public void initialize() throws Exception {
        this.deflater.reset();
    }
}

