/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.compression.huffman;

import guilibshadow.cafe4j.image.compression.huffman.HuffmanTbl;
import java.io.IOException;
import java.io.InputStream;

public class HuffmanDecoder {
    private static final int DNL = 220;
    private InputStream is;
    private int[] VALPTR;
    private int[] MINCODE;
    private int[] MAXCODE;
    private byte[] HUFFVAL;
    private int CNT = 0;
    private int[] ZZ = new int[64];

    public HuffmanDecoder(InputStream is, HuffmanTbl ht) {
        this.is = is;
        this.VALPTR = ht.getValPTRTable();
        this.MINCODE = ht.getMinCodeTable();
        this.MAXCODE = ht.getMaxCodeTable();
        this.HUFFVAL = ht.getValueTable();
    }

    private int DECODE() {
        int I = 1;
        int CODE = this.NEXTBIT();
        while (CODE > this.MAXCODE[I]) {
            ++I;
            CODE = (CODE << 1) + this.NEXTBIT();
        }
        int J = this.VALPTR[I] + CODE - this.MINCODE[I];
        return this.HUFFVAL[J] & 0xFF;
    }

    public void decode_AC_coefficients() {
        block2: {
            int R;
            int SSSS;
            int K = 1;
            while (true) {
                int RS = this.DECODE();
                SSSS = RS % 16;
                R = RS >> 4;
                if (SSSS != 0) break;
                if (R == 15) {
                    K += 16;
                    continue;
                }
                break block2;
                break;
            }
            this.decode_ZZ(K += R, SSSS);
            if (K == 63) break block2;
            ++K;
        }
    }

    private void decode_ZZ(int K, int SSSS) {
        this.ZZ[K] = this.RECEIVE(SSSS);
        this.ZZ[K] = HuffmanDecoder.EXTEND(this.ZZ[K], SSSS);
    }

    private static int EXTEND(int V, int T) {
        int Vt = 1 << T - 1;
        if (V < Vt) {
            Vt = (-1 << T) + 1;
            V += Vt;
        }
        return V;
    }

    private int NEXTBIT() {
        int B = 0;
        if (this.CNT == 0) {
            int B2;
            B = this.NEXTBYTE();
            this.CNT = 8;
            if (B != 255 || (B2 = this.NEXTBYTE()) == 0 || B2 == 220) {
                // empty if block
            }
        }
        int BIT = B >> 7;
        --this.CNT;
        B <<= 1;
        return BIT;
    }

    private int NEXTBYTE() {
        int readByte;
        try {
            readByte = this.is.read();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error reading NEXTBYTE...");
        }
        return readByte;
    }

    private int RECEIVE(int SSSS) {
        int V = 0;
        for (int I = 0; I != SSSS; ++I) {
            V = (V << 1) + this.NEXTBIT();
        }
        return V;
    }
}

