/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.compression.huffman;

import guilibshadow.cafe4j.image.compression.ImageEncoder;
import guilibshadow.cafe4j.image.compression.huffman.HuffmanTbl;
import guilibshadow.cafe4j.image.jpeg.JPGConsts;
import java.io.OutputStream;
import java.util.Arrays;

public class HuffmanEncoder
implements ImageEncoder {
    private int empty_bits;
    private byte[] bytes_buf;
    private int buf_length;
    private int bufIndex;
    private int[][] DC_EHUFCO = new int[4][];
    private int[][] DC_EHUFSI = new int[4][];
    private int[][] AC_EHUFCO = new int[4][];
    private int[][] AC_EHUFSI = new int[4][];
    private int[] PREDICTION = new int[4];
    private boolean extraFlush = true;
    private boolean useCustomTables = false;
    private OutputStream os;
    private static final short[] mask = new short[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191};
    private static final int[] ZIGZAG_TRAVERSE_ORDER = JPGConsts.getZigzagMatrix();
    int totalBytes = 0;

    public HuffmanEncoder(OutputStream os, int buf_length) {
        this.os = os;
        this.bytes_buf = new byte[buf_length];
        this.buf_length = buf_length;
    }

    private void createDefaultEncodingTables() {
        HuffmanTbl huffTbl = new HuffmanTbl();
        huffTbl.setBits(JPGConsts.getDCLuminanceBits());
        huffTbl.setValues(JPGConsts.getDCLuminanceValues());
        huffTbl.generateEncoderTables();
        this.DC_EHUFCO[0] = huffTbl.getEncoderCodeTable();
        this.DC_EHUFSI[0] = huffTbl.getEncoderSizeTable();
        huffTbl.setBits(JPGConsts.getDCChrominanceBits());
        huffTbl.setValues(JPGConsts.getDCChrominanceValues());
        huffTbl.generateEncoderTables();
        this.DC_EHUFCO[1] = huffTbl.getEncoderCodeTable();
        this.DC_EHUFSI[1] = huffTbl.getEncoderSizeTable();
        this.DC_EHUFCO[2] = huffTbl.getEncoderCodeTable();
        this.DC_EHUFSI[2] = huffTbl.getEncoderSizeTable();
        this.DC_EHUFCO[3] = huffTbl.getEncoderCodeTable();
        this.DC_EHUFSI[3] = huffTbl.getEncoderSizeTable();
        huffTbl.setBits(JPGConsts.getACLuminanceBits());
        huffTbl.setValues(JPGConsts.getACLuminanceValues());
        huffTbl.generateEncoderTables();
        this.AC_EHUFCO[0] = huffTbl.getEncoderCodeTable();
        this.AC_EHUFSI[0] = huffTbl.getEncoderSizeTable();
        huffTbl.setBits(JPGConsts.getACChrominanceBits());
        huffTbl.setValues(JPGConsts.getACChrominanceValues());
        huffTbl.generateEncoderTables();
        this.AC_EHUFCO[1] = huffTbl.getEncoderCodeTable();
        this.AC_EHUFSI[1] = huffTbl.getEncoderSizeTable();
        this.AC_EHUFCO[2] = huffTbl.getEncoderCodeTable();
        this.AC_EHUFSI[2] = huffTbl.getEncoderSizeTable();
        this.AC_EHUFCO[3] = huffTbl.getEncoderCodeTable();
        this.AC_EHUFSI[3] = huffTbl.getEncoderSizeTable();
    }

    @Override
    public void encode(byte[] pixels, int start, int len) throws Exception {
        throw new UnsupportedOperationException("Call encode(int[] ZZ, int component_id) instead.");
    }

    public void encode(int[] ZZ, int component_id) throws Exception {
        int r = 0;
        int temp = ZZ[0] - this.PREDICTION[component_id];
        int ssss = HuffmanEncoder.CSIZE(temp);
        if (temp < 0) {
            --temp;
        }
        this.send_code_to_buffer(this.DC_EHUFCO[component_id][ssss], this.DC_EHUFSI[component_id][ssss]);
        if (ssss != 0) {
            this.send_code_to_buffer(temp, ssss);
        }
        this.PREDICTION[component_id] = ZZ[0];
        for (int k = 1; k < 64; ++k) {
            temp = ZZ[ZIGZAG_TRAVERSE_ORDER[k]];
            if (temp == 0) {
                ++r;
                continue;
            }
            while (r > 15) {
                this.send_code_to_buffer(this.AC_EHUFCO[component_id][240], this.AC_EHUFSI[component_id][240]);
                r -= 16;
            }
            ssss = HuffmanEncoder.CSIZE(temp);
            if (temp < 0) {
                --temp;
            }
            int rs = (r << 4) + ssss;
            this.send_code_to_buffer(this.AC_EHUFCO[component_id][rs], this.AC_EHUFSI[component_id][rs]);
            this.send_code_to_buffer(temp, ssss);
            r = 0;
        }
        if (r > 0) {
            this.send_code_to_buffer(this.AC_EHUFCO[component_id][0], this.AC_EHUFSI[component_id][0]);
        }
    }

    @Override
    public void finish() throws Exception {
        if (this.extraFlush) {
            this.flush_buf(this.bufIndex + 1);
        }
    }

    private void flush_buf(int len) throws Exception {
        this.os.write(this.bytes_buf, 0, len);
        this.bufIndex = 0;
        Arrays.fill(this.bytes_buf, 0, len, (byte)0);
        this.totalBytes += len;
    }

    @Override
    public int getCompressedDataLen() {
        return this.totalBytes;
    }

    @Override
    public void initialize() {
        if (!this.useCustomTables) {
            this.createDefaultEncodingTables();
        }
        this.empty_bits = 8;
        this.totalBytes = 0;
    }

    private void send_code_to_buffer(int code, int codeLen) throws Exception {
        if (this.empty_bits == 0) {
            if (++this.bufIndex >= this.buf_length) {
                this.flush_buf(this.buf_length);
            }
            this.empty_bits = 8;
        }
        if (codeLen < this.empty_bits) {
            int n = this.bufIndex;
            this.bytes_buf[n] = (byte)(this.bytes_buf[n] | (code & mask[codeLen]) << this.empty_bits - codeLen);
            this.empty_bits -= codeLen;
        } else {
            int n = this.bufIndex;
            this.bytes_buf[n] = (byte)(this.bytes_buf[n] | code >>> codeLen - this.empty_bits & mask[this.empty_bits]);
            int temp = codeLen - this.empty_bits;
            if ((this.bytes_buf[this.bufIndex] & 0xFF) == 255) {
                if (++this.bufIndex >= this.buf_length) {
                    this.flush_buf(this.buf_length);
                }
                int n2 = this.bufIndex;
                this.bytes_buf[n2] = (byte)(this.bytes_buf[n2] | 0);
            }
            if (temp >= 8) {
                if (++this.bufIndex >= this.buf_length) {
                    this.flush_buf(this.buf_length);
                }
                int n3 = this.bufIndex;
                this.bytes_buf[n3] = (byte)(this.bytes_buf[n3] | code >>> temp - 8 & mask[8]);
                temp -= 8;
                if ((this.bytes_buf[this.bufIndex] & 0xFF) == 255) {
                    if (++this.bufIndex >= this.buf_length) {
                        this.flush_buf(this.buf_length);
                    }
                    int n4 = this.bufIndex;
                    this.bytes_buf[n4] = (byte)(this.bytes_buf[n4] | 0);
                }
            }
            if (temp > 0) {
                if (++this.bufIndex >= this.buf_length) {
                    this.flush_buf(this.buf_length);
                }
                int n5 = this.bufIndex;
                this.bytes_buf[n5] = (byte)(this.bytes_buf[n5] | (code & mask[temp]) << 8 - temp);
                temp -= 8;
            }
            this.empty_bits = -temp;
        }
    }

    public void setEncodingTables(int[][] DC_EHUFCO, int[][] DC_EHUFSI, int[][] AC_EHUFCO, int[][] AC_EHUFSI) {
        this.DC_EHUFCO = DC_EHUFCO;
        this.DC_EHUFSI = DC_EHUFSI;
        this.AC_EHUFCO = AC_EHUFCO;
        this.AC_EHUFSI = AC_EHUFSI;
        this.useCustomTables = true;
    }

    private static int CSIZE(int ZZ_K) {
        if (ZZ_K == 0) {
            return 0;
        }
        if (ZZ_K >= -1 && ZZ_K <= 1) {
            return 1;
        }
        if (ZZ_K >= -3 && ZZ_K <= 3) {
            return 2;
        }
        if (ZZ_K >= -7 && ZZ_K <= 7) {
            return 3;
        }
        if (ZZ_K >= -15 && ZZ_K <= 15) {
            return 4;
        }
        if (ZZ_K >= -31 && ZZ_K <= 31) {
            return 5;
        }
        if (ZZ_K >= -63 && ZZ_K <= 63) {
            return 6;
        }
        if (ZZ_K >= -127 && ZZ_K <= 127) {
            return 7;
        }
        if (ZZ_K >= -255 && ZZ_K <= 255) {
            return 8;
        }
        if (ZZ_K >= -511 && ZZ_K <= 511) {
            return 9;
        }
        if (ZZ_K >= -1023 && ZZ_K <= 1023) {
            return 10;
        }
        if (ZZ_K >= -2047 && ZZ_K <= 2047) {
            return 11;
        }
        throw new RuntimeException("Invalid ZZ_K value: " + ZZ_K);
    }
}

