/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.compression.huffman;

public class HuffmanTbl {
    private byte[] BITS;
    private byte[] HUFFVAL;
    private int[] HUFFSIZE = new int[257];
    private int[] HUFFCODE = new int[257];
    private int[] EHUFCO = new int[257];
    private int[] EHUFSI = new int[257];
    private int[] MAXCODE = new int[16];
    private int[] MINCODE = new int[16];
    private int[] VALPTR = new int[16];
    private int LASTK = 0;

    public HuffmanTbl() {
    }

    public HuffmanTbl(byte[] BITS, byte[] HUFFVAL) {
        this.BITS = BITS;
        this.HUFFVAL = HUFFVAL;
    }

    private void generate_code_table() {
        int k = 0;
        int code = 0;
        int size = this.HUFFSIZE[0];
        while (true) {
            this.HUFFCODE[k++] = code++;
            if (this.HUFFSIZE[k] == size) continue;
            if (this.HUFFSIZE[k] == 0) break;
            do {
                code <<= 1;
            } while (this.HUFFSIZE[k] != ++size);
        }
    }

    private void generate_decoder_tables() {
        int I = -1;
        int J = 0;
        while (++I <= 15) {
            if (this.BITS[I] == 0) {
                this.MAXCODE[I] = -1;
                continue;
            }
            this.VALPTR[I] = J;
            this.MINCODE[I] = this.HUFFCODE[J];
            J += this.BITS[I] - 1 & 0xFF;
            this.MAXCODE[I] = this.HUFFCODE[J++];
        }
        return;
    }

    private void generate_size_table() {
        int j = 1;
        int k = 0;
        for (int i = 1; i <= 16; ++i) {
            while (j <= (this.BITS[i - 1] & 0xFF)) {
                this.HUFFSIZE[k++] = i;
                ++j;
            }
            j = 1;
        }
        this.HUFFSIZE[k] = 0;
        this.LASTK = k;
    }

    public void generateDecoderTables() {
        this.generate_size_table();
        this.generate_code_table();
        this.generate_decoder_tables();
    }

    public void generateEncoderTables() {
        this.generate_size_table();
        this.generate_code_table();
        this.order_codes();
    }

    public int[] getCodeTable() {
        return (int[])this.HUFFCODE.clone();
    }

    public int[] getEncoderCodeTable() {
        return (int[])this.EHUFCO.clone();
    }

    public int[] getEncoderSizeTable() {
        return (int[])this.EHUFSI.clone();
    }

    public int[] getMaxCodeTable() {
        return (int[])this.MAXCODE.clone();
    }

    public int[] getMinCodeTable() {
        return (int[])this.MINCODE.clone();
    }

    public int[] getValPTRTable() {
        return (int[])this.VALPTR.clone();
    }

    public byte[] getValueTable() {
        return (byte[])this.HUFFVAL.clone();
    }

    private void order_codes() {
        int k = 0;
        while (k < this.LASTK) {
            int i = this.HUFFVAL[k] & 0xFF;
            this.EHUFCO[i] = this.HUFFCODE[k];
            this.EHUFSI[i] = this.HUFFSIZE[k++];
        }
    }

    public void setBits(byte[] BITS) {
        this.BITS = BITS;
    }

    public void setValues(byte[] VALUE) {
        this.HUFFVAL = VALUE;
    }
}

