/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.compression.lzw;

public class LZWCompressionTable {
    private static final int RES_CODES = 2;
    private static final short EMPTY = -1;
    private static final int MAXBITS = 12;
    private static final int MAXSTR = 4096;
    private static final short HASHSIZE = 9973;
    private static final short HASHSTEP = 2039;
    byte[] strChr_ = new byte[4096];
    short[] strPref_ = new short[4096];
    short[] strHsh_ = new short[9973];
    short numStrings_;

    public int addCharString(short prefix, byte b) {
        if (this.numStrings_ >= 4096) {
            return 65535;
        }
        int hshidx = LZWCompressionTable.hash(prefix, b);
        while (this.strHsh_[hshidx] != -1) {
            hshidx = (hshidx + 2039) % 9973;
        }
        this.strHsh_[hshidx] = this.numStrings_;
        this.strChr_[this.numStrings_] = b;
        this.strPref_[this.numStrings_] = prefix;
        short s = this.numStrings_;
        this.numStrings_ = (short)(s + 1);
        return s;
    }

    public short findCharString(short prefix, byte b) {
        short nxtidx;
        if (prefix == -1) {
            return b;
        }
        int hshidx = LZWCompressionTable.hash(prefix, b);
        while ((nxtidx = this.strHsh_[hshidx]) != -1) {
            if (this.strPref_[nxtidx] == prefix && this.strChr_[nxtidx] == b) {
                return nxtidx;
            }
            hshidx = (hshidx + 2039) % 9973;
        }
        return -1;
    }

    public void clearTable(int codesize) {
        this.numStrings_ = 0;
        for (int q = 0; q < 9973; ++q) {
            this.strHsh_[q] = -1;
        }
        int w = (1 << codesize) + 2;
        for (int q = 0; q < w; ++q) {
            this.addCharString((short)-1, (byte)q);
        }
    }

    private static int hash(short prefix, byte lastbyte) {
        return (((short)(lastbyte << 8) ^ prefix) & 0xFFFF) % 9973;
    }
}

