/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.compression.lzw;

import guilibshadow.cafe4j.image.compression.ImageEncoder;
import guilibshadow.cafe4j.image.compression.lzw.LZWCompressionTable;
import guilibshadow.cafe4j.util.Updatable;
import java.io.OutputStream;
import java.util.Arrays;

public class LZWHashEncoder
implements ImageEncoder {
    private static short EMPTY = (short)-1;
    private int codeSize;
    private int codeLen;
    private int clearCode;
    private int endOfImage;
    private int limit;
    private short prefix = EMPTY;
    private int bufIndex = 0;
    private int empty_bits;
    private int buf_length;
    private byte[] bytes_buf;
    private OutputStream os;
    private boolean isTIFF = false;
    private Updatable<Integer> writer;
    private LZWCompressionTable stringTable = new LZWCompressionTable();
    private static final short[] mask = new short[]{0, 1, 3, 7, 15, 31, 63, 127, 255};
    int compressedDataLen = 0;

    public LZWHashEncoder(OutputStream os, int codesize, int buf_length) {
        this.codeSize = codesize;
        this.bytes_buf = new byte[buf_length];
        this.buf_length = buf_length;
        this.os = os;
    }

    public LZWHashEncoder(OutputStream os, int codesize, int buf_length, Updatable<Integer> writer) {
        this(os, codesize, buf_length);
        this.isTIFF = true;
        this.writer = writer;
    }

    @Override
    public void initialize() throws Exception {
        this.clearCode = 1 << this.codeSize;
        this.endOfImage = this.clearCode + 1;
        this.codeLen = this.codeSize + 1;
        this.limit = (1 << this.codeLen) - 1;
        this.empty_bits = 8;
        this.stringTable.clearTable(this.codeSize);
        this.compressedDataLen = 0;
        this.prefix = EMPTY;
        if (!this.isTIFF) {
            this.os.write(this.codeSize);
        }
        this.send_code_to_buffer(this.clearCode);
    }

    @Override
    public void encode(byte[] pixels, int start, int len) throws Exception {
        if (start < 0 || len <= 0) {
            return;
        }
        byte c = 0;
        short cur_str = 0;
        for (int i = start; i < start + len; ++i) {
            c = pixels[i];
            cur_str = this.stringTable.findCharString(this.prefix, c);
            if (cur_str != EMPTY) {
                this.prefix = cur_str;
                continue;
            }
            this.send_code_to_buffer(this.prefix);
            if (this.stringTable.addCharString(this.prefix, c) > (this.isTIFF ? this.limit - 1 : this.limit)) {
                if (++this.codeLen > 12) {
                    --this.codeLen;
                    this.send_code_to_buffer(this.clearCode);
                    this.stringTable.clearTable(this.codeSize);
                    this.codeLen = this.codeSize + 1;
                }
                this.limit = (1 << this.codeLen) - 1;
            }
            this.prefix = (short)(c & 0xFF);
        }
    }

    @Override
    public void finish() throws Exception {
        if (this.prefix != EMPTY) {
            this.send_code_to_buffer(this.prefix);
        }
        this.send_code_to_buffer(this.endOfImage);
        this.flush_buf(this.bufIndex + 1);
        if (this.isTIFF) {
            this.writer.update(this.compressedDataLen);
        }
    }

    @Override
    public int getCompressedDataLen() {
        return this.compressedDataLen;
    }

    private void send_code_to_buffer(int code) throws Exception {
        int temp = this.codeLen;
        if (this.isTIFF) {
            int n = this.bufIndex;
            this.bytes_buf[n] = (byte)(this.bytes_buf[n] | code >>> temp & mask[this.empty_bits]);
            for (temp = this.codeLen - this.empty_bits; temp > 8; temp -= 8) {
                if (++this.bufIndex >= this.buf_length) {
                    this.flush_buf(this.buf_length);
                }
                int n2 = this.bufIndex;
                this.bytes_buf[n2] = (byte)(this.bytes_buf[n2] | code >>> temp - 8 & mask[8]);
            }
            if (temp > 0) {
                if (++this.bufIndex >= this.buf_length) {
                    this.flush_buf(this.buf_length);
                }
                int n3 = this.bufIndex;
                this.bytes_buf[n3] = (byte)(this.bytes_buf[n3] | (code & mask[temp]) << 8 - temp);
                temp -= 8;
            }
        } else {
            int n = this.bufIndex;
            this.bytes_buf[n] = (byte)(this.bytes_buf[n] | (code & mask[this.empty_bits]) << 8 - this.empty_bits);
            code >>= this.empty_bits;
            temp -= this.empty_bits;
            while (temp > 0) {
                if (++this.bufIndex >= this.buf_length) {
                    this.flush_buf(this.buf_length);
                }
                int n4 = this.bufIndex;
                this.bytes_buf[n4] = (byte)(this.bytes_buf[n4] | code & 0xFF);
                code >>= 8;
                temp -= 8;
            }
        }
        this.empty_bits = -temp;
    }

    private void flush_buf(int len) throws Exception {
        if (!this.isTIFF) {
            this.os.write(len);
        }
        this.os.write(this.bytes_buf, 0, len);
        this.bufIndex = 0;
        Arrays.fill(this.bytes_buf, 0, len, (byte)0);
        this.compressedDataLen += len;
    }
}

