/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.compression.lzw;

import guilibshadow.cafe4j.image.compression.ImageDecoder;
import guilibshadow.cafe4j.io.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class LZWTreeDecoder
implements ImageDecoder {
    private int bits_remain = 0;
    private int bytes_available = 0;
    private int temp_byte = 0;
    private int bufIndex = 0;
    private byte[] bytes_buf = new byte[256];
    private int oldcode = 0;
    private int code = 0;
    private int[] prefix = new int[4097];
    private int[] suffix = new int[4097];
    private int min_code_size;
    private int clearCode;
    private int endOfImage;
    private int codeLen;
    private int codeIndex;
    private int limit;
    private int first_code_index;
    private int first_char;
    private InputStream is;
    private boolean isTIFF;
    private boolean isCodeBigEndian;
    private static final int[] MASK = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095};
    private int leftOver = 0;
    private int[] buf = new int[4097];
    private static final int MAX_CODE = 4096;

    public LZWTreeDecoder(InputStream is, int min_code_size) {
        if (min_code_size < 2 || min_code_size > 12) {
            throw new IllegalArgumentException("invalid min_code_size: " + min_code_size);
        }
        this.is = is;
        this.min_code_size = min_code_size;
        this.clearCode = 1 << min_code_size;
        this.endOfImage = this.clearCode + 1;
        this.first_code_index = this.endOfImage + 1;
        this.isCodeBigEndian = true;
        this.clearStringTable();
    }

    public LZWTreeDecoder(int min_code_size, boolean isTIFF) {
        this(null, min_code_size);
        this.isTIFF = isTIFF;
    }

    private void clearStringTable() {
        this.codeLen = this.min_code_size + 1;
        this.limit = (1 << this.codeLen) - 1;
        this.codeIndex = this.endOfImage;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int decode(byte[] pix, int offset, int len) throws Exception {
        counter = 0;
        tempcode = 0;
        i = 0;
        if (this.leftOver > 0) {
            j = this.leftOver - 1;
            while (j >= 0) {
                if (offset >= pix.length || counter >= len) {
                    return counter;
                }
                pix[offset++] = (byte)this.buf[j];
                ++counter;
                --j;
                --this.leftOver;
            }
        }
        block1: while (true) {
            i = 0;
            tempcode = this.code = this.readLZWCode();
            if (this.code == this.clearCode) {
                this.clearStringTable();
                continue;
            }
            if (this.code == this.endOfImage) break;
            if (this.code >= this.codeIndex) {
                tempcode = this.oldcode;
                this.buf[i++] = this.first_char;
            }
            while (tempcode >= this.first_code_index) {
                this.buf[i++] = this.suffix[tempcode];
                tempcode = this.prefix[tempcode];
            }
            this.buf[i++] = tempcode;
            this.suffix[this.codeIndex] = this.first_char = tempcode;
            this.prefix[this.codeIndex] = this.oldcode;
            if (this.codeIndex < 4096) {
                ++this.codeIndex;
            }
            this.oldcode = this.code;
            if (this.codeIndex > (this.isTIFF != false && this.isCodeBigEndian != false ? this.limit - 1 : this.limit) && this.codeLen < 12) {
                ++this.codeLen;
                this.limit = (1 << this.codeLen) - 1;
            }
            this.leftOver = i;
            j = i - 1;
            while (true) {
                if (j >= 0) ** break;
                continue block1;
                if (offset >= pix.length || counter >= len) break block1;
                pix[offset++] = (byte)this.buf[j];
                --j;
                --this.leftOver;
                ++counter;
            }
            break;
        }
        return counter;
    }

    private int readLZWCode() throws Exception {
        int temp = 0;
        temp = !this.isTIFF || !this.isCodeBigEndian ? this.temp_byte >> 8 - this.bits_remain : this.temp_byte & MASK[this.bits_remain];
        while (this.codeLen > this.bits_remain) {
            if (!this.isTIFF) {
                if (this.bytes_available == 0) {
                    this.bytes_available = this.is.read();
                    if (this.bytes_available > 0) {
                        IOUtils.readFully(this.is, this.bytes_buf, 0, this.bytes_available);
                        this.bufIndex = 0;
                    } else {
                        if (this.bytes_available == 0) {
                            return this.endOfImage;
                        }
                        return this.endOfImage;
                    }
                }
                this.temp_byte = this.bytes_buf[this.bufIndex++] & 0xFF;
                --this.bytes_available;
                temp |= this.temp_byte << this.bits_remain;
            } else {
                this.temp_byte = this.is.read();
                if (this.temp_byte == -1) {
                    return this.endOfImage;
                }
                temp = this.isCodeBigEndian ? temp << 8 | this.temp_byte : (temp |= this.temp_byte << this.bits_remain);
            }
            this.bits_remain += 8;
        }
        if (this.isTIFF && this.isCodeBigEndian) {
            temp >>= this.bits_remain - this.codeLen;
        }
        this.bits_remain -= this.codeLen;
        return temp & MASK[this.codeLen];
    }

    @Override
    public void setInput(byte[] input) {
        this.setInput(input, 0, input.length);
    }

    @Override
    public void setInput(byte[] input, int offset, int len) {
        this.isCodeBigEndian = input[offset] != 0 || input[offset + 1] != 1;
        this.is = new ByteArrayInputStream(input, offset, len);
        this.bits_remain = 0;
        this.leftOver = 0;
        this.clearStringTable();
    }
}

