/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.compression.lzw;

import guilibshadow.cafe4j.image.compression.ImageEncoder;
import guilibshadow.cafe4j.util.Updatable;
import java.io.OutputStream;
import java.util.Arrays;

public class LZWTreeEncoder
implements ImageEncoder {
    private int codeSize;
    private int codeLen;
    private int codeIndex;
    private int clearCode;
    private int endOfImage;
    private int limit;
    private boolean firstTime;
    private int[] child = new int[4097];
    private int[] siblings = new int[4097];
    private int[] suffix = new int[4097];
    private int parent = 0;
    private int bufIndex;
    private int empty_bits;
    private int buf_length;
    private byte[] bytes_buf;
    private OutputStream os;
    private boolean isTIFF = false;
    private Updatable<Integer> writer;
    private static final short[] MASK = new short[]{0, 1, 3, 7, 15, 31, 63, 127, 255};
    int compressedDataLen = 0;

    public LZWTreeEncoder(OutputStream os, int codesize, int buf_length) {
        this.codeSize = codesize;
        this.bytes_buf = new byte[buf_length];
        this.buf_length = buf_length;
        this.os = os;
    }

    public LZWTreeEncoder(OutputStream os, int codesize, int buf_length, Updatable<Integer> writer) {
        this(os, codesize, buf_length);
        this.isTIFF = true;
        this.writer = writer;
    }

    @Override
    public void encode(byte[] pixels, int start, int len) throws Exception {
        if (start < 0 || len <= 0) {
            return;
        }
        if (start + len > pixels.length) {
            len = pixels.length - start;
        }
        int son = 0;
        int brother = 0;
        int color = 0;
        int counter = 0;
        if (this.firstTime) {
            this.parent = pixels[start++] & 0xFF;
            ++counter;
            this.firstTime = false;
        }
        block0: while (counter < len) {
            color = pixels[start++] & 0xFF;
            ++counter;
            son = this.child[this.parent];
            if (son > 0) {
                if (this.suffix[son] == color) {
                    this.parent = son;
                    continue;
                }
                brother = son;
                while (this.siblings[brother] > 0) {
                    if (this.suffix[brother = this.siblings[brother]] != color) continue;
                    this.parent = brother;
                    continue block0;
                }
                this.siblings[brother] = this.codeIndex;
                this.suffix[this.codeIndex] = color;
                this.send_code_to_buffer(this.parent);
                this.parent = color;
                ++this.codeIndex;
                if (this.codeIndex <= (this.isTIFF ? this.limit - 1 : this.limit)) continue;
                if (this.codeLen == 12) {
                    this.send_code_to_buffer(this.clearCode);
                    this.init_encoder(this.codeSize);
                    continue;
                }
                ++this.codeLen;
                this.limit = 1 << this.codeLen;
                continue;
            }
            this.child[this.parent] = this.codeIndex;
            this.suffix[this.codeIndex] = color;
            this.send_code_to_buffer(this.parent);
            this.parent = color;
            ++this.codeIndex;
            if (this.codeIndex <= (this.isTIFF ? this.limit - 1 : this.limit)) continue;
            if (this.codeLen == 12) {
                this.send_code_to_buffer(this.clearCode);
                this.init_encoder(this.codeSize);
                continue;
            }
            ++this.codeLen;
            this.limit = 1 << this.codeLen;
        }
    }

    @Override
    public void finish() throws Exception {
        this.send_code_to_buffer(this.parent);
        this.send_code_to_buffer(this.endOfImage);
        this.flush_buf(this.bufIndex + 1);
        if (this.isTIFF && this.writer != null) {
            this.writer.update(this.compressedDataLen);
        }
    }

    private void flush_buf(int len) throws Exception {
        if (!this.isTIFF) {
            this.os.write(len);
        }
        this.os.write(this.bytes_buf, 0, len);
        this.bufIndex = 0;
        Arrays.fill(this.bytes_buf, 0, len, (byte)0);
        this.compressedDataLen += len;
    }

    @Override
    public int getCompressedDataLen() {
        return this.compressedDataLen;
    }

    private void init_encoder(int codesize) {
        Arrays.fill(this.child, 0);
        Arrays.fill(this.siblings, 0);
        this.codeLen = codesize + 1;
        this.limit = 1 << this.codeLen;
        this.codeIndex = this.endOfImage + 1;
    }

    @Override
    public void initialize() throws Exception {
        this.clearCode = 1 << this.codeSize;
        this.endOfImage = this.clearCode + 1;
        this.firstTime = true;
        this.empty_bits = 8;
        this.compressedDataLen = 0;
        this.init_encoder(this.codeSize);
        if (!this.isTIFF) {
            this.os.write(this.codeSize);
        }
        this.send_code_to_buffer(this.clearCode);
    }

    private void send_code_to_buffer(int code) throws Exception {
        int temp = this.codeLen;
        if (this.isTIFF) {
            int n = this.bufIndex;
            this.bytes_buf[n] = (byte)(this.bytes_buf[n] | code >>> temp & MASK[this.empty_bits]);
            for (temp = this.codeLen - this.empty_bits; temp > 8; temp -= 8) {
                if (++this.bufIndex >= this.buf_length) {
                    this.flush_buf(this.buf_length);
                }
                int n2 = this.bufIndex;
                this.bytes_buf[n2] = (byte)(this.bytes_buf[n2] | code >>> temp - 8 & MASK[8]);
            }
            if (temp > 0) {
                if (++this.bufIndex >= this.buf_length) {
                    this.flush_buf(this.buf_length);
                }
                int n3 = this.bufIndex;
                this.bytes_buf[n3] = (byte)(this.bytes_buf[n3] | (code & MASK[temp]) << 8 - temp);
                temp -= 8;
            }
        } else {
            int n = this.bufIndex;
            this.bytes_buf[n] = (byte)(this.bytes_buf[n] | (code & MASK[this.empty_bits]) << 8 - this.empty_bits);
            code >>= this.empty_bits;
            temp -= this.empty_bits;
            while (temp > 0) {
                if (++this.bufIndex >= this.buf_length) {
                    this.flush_buf(this.buf_length);
                }
                int n4 = this.bufIndex;
                this.bytes_buf[n4] = (byte)(this.bytes_buf[n4] | code & 0xFF);
                code >>= 8;
                temp -= 8;
            }
        }
        this.empty_bits = -temp;
    }
}

