/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.gif;

import java.awt.image.BufferedImage;

public class GIFFrame {
    private BufferedImage frame;
    private int leftPosition;
    private int topPosition;
    private int frameWidth;
    private int frameHeight;
    private int delay;
    private int disposalMethod = 0;
    private int userInputFlag = 0;
    private int transparencyFlag = 0;
    private int transparentColor = -1;
    public static final int DISPOSAL_UNSPECIFIED = 0;
    public static final int DISPOSAL_LEAVE_AS_IS = 1;
    public static final int DISPOSAL_RESTORE_TO_BACKGROUND = 2;
    public static final int DISPOSAL_RESTORE_TO_PREVIOUS = 3;
    public static final int DISPOSAL_TO_BE_DEFINED = 7;
    public static final int USER_INPUT_NONE = 0;
    public static final int USER_INPUT_EXPECTED = 1;
    public static final int TRANSPARENCY_INDEX_NONE = 0;
    public static final int TRANSPARENCY_INDEX_SET = 1;
    public static final int TRANSPARENCY_COLOR_NONE = -1;

    public GIFFrame(BufferedImage frame) {
        this(frame, 0, 0, 0, 0);
    }

    public GIFFrame(BufferedImage frame, int delay) {
        this(frame, 0, 0, delay, 0);
    }

    public GIFFrame(BufferedImage frame, int delay, int disposalMethod) {
        this(frame, 0, 0, delay, disposalMethod);
    }

    public GIFFrame(BufferedImage frame, int leftPosition, int topPosition, int delay, int disposalMethod) {
        this(frame, leftPosition, topPosition, delay, disposalMethod, 0, 0, -1);
    }

    public GIFFrame(BufferedImage frame, int leftPosition, int topPosition, int delay, int disposalMethod, int userInputFlag, int transparencyFlag, int transparentColor) {
        if (frame == null) {
            throw new IllegalArgumentException("Null input image");
        }
        if (disposalMethod < 0 || disposalMethod > 7) {
            throw new IllegalArgumentException("Invalid disposal method: " + disposalMethod);
        }
        if (userInputFlag < 0 || userInputFlag > 1) {
            throw new IllegalArgumentException("Invalid user input flag: " + userInputFlag);
        }
        if (transparencyFlag < 0 || transparencyFlag > 1) {
            throw new IllegalArgumentException("Invalid transparency flag: " + transparencyFlag);
        }
        if (leftPosition < 0 || topPosition < 0) {
            throw new IllegalArgumentException("Negative coordinates for frame top-left position");
        }
        if (delay < 0) {
            delay = 0;
        }
        this.frame = frame;
        this.leftPosition = leftPosition;
        this.topPosition = topPosition;
        this.delay = delay;
        this.disposalMethod = disposalMethod;
        this.userInputFlag = userInputFlag;
        this.transparencyFlag = transparencyFlag;
        this.frameWidth = frame.getWidth();
        this.frameHeight = frame.getHeight();
        this.transparentColor = transparentColor;
    }

    public int getDelay() {
        return this.delay;
    }

    public int getDisposalMethod() {
        return this.disposalMethod;
    }

    public BufferedImage getFrame() {
        return this.frame;
    }

    public int getFrameHeight() {
        return this.frameHeight;
    }

    public int getFrameWidth() {
        return this.frameWidth;
    }

    public int getLeftPosition() {
        return this.leftPosition;
    }

    public int getTopPosition() {
        return this.topPosition;
    }

    public int getTransparentColor() {
        return this.transparentColor;
    }

    public int getTransparencyFlag() {
        return this.transparencyFlag;
    }

    public int getUserInputFlag() {
        return this.userInputFlag;
    }
}

