/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.gif;

import guilibshadow.cafe4j.image.ImageIO;
import guilibshadow.cafe4j.image.ImageParam;
import guilibshadow.cafe4j.image.ImageType;
import guilibshadow.cafe4j.image.gif.FrameReader;
import guilibshadow.cafe4j.image.gif.GIFFrame;
import guilibshadow.cafe4j.image.meta.Metadata;
import guilibshadow.cafe4j.image.meta.MetadataType;
import guilibshadow.cafe4j.image.meta.gif.GifXMP;
import guilibshadow.cafe4j.image.meta.image.Comments;
import guilibshadow.cafe4j.image.meta.xmp.XMP;
import guilibshadow.cafe4j.image.writer.GIFWriter;
import guilibshadow.cafe4j.image.writer.ImageWriter;
import guilibshadow.cafe4j.io.IOUtils;
import guilibshadow.cafe4j.string.StringUtils;
import guilibshadow.cafe4j.util.ArrayUtils;
import guilibshadow.org.slf4j.Logger;
import guilibshadow.org.slf4j.LoggerFactory;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GIFTweaker {
    public static final byte IMAGE_SEPARATOR = 44;
    public static final byte IMAGE_TRAILER = 59;
    public static final byte EXTENSION_INTRODUCER = 33;
    public static final byte GRAPHIC_CONTROL_LABEL = -7;
    public static final byte APPLICATION_EXTENSION_LABEL = -1;
    public static final byte COMMENT_EXTENSION_LABEL = -2;
    public static final byte TEXT_EXTENSION_LABEL = 1;
    private static final Logger LOGGER = LoggerFactory.getLogger(GIFTweaker.class);

    private static boolean copyFrame(InputStream is, OutputStream os, DataTransferObject DTO) throws IOException {
        os.write(DTO.header);
        os.write(DTO.logicalScreenDescriptor);
        if (DTO.globalPalette != null) {
            os.write(DTO.globalPalette);
        }
        int image_separator = 0;
        do {
            if ((image_separator = is.read()) == 59) {
                return false;
            }
            if (image_separator == -1) {
                LOGGER.error("Unexpected end of stream!");
                return false;
            }
            if (image_separator != 33) continue;
            int func = is.read();
            os.write(33);
            os.write(func);
            int len = 0;
            while ((len = is.read()) > 0) {
                os.write(len);
                byte[] block = new byte[len];
                is.read(block);
                os.write(block);
            }
            os.write(0);
        } while (image_separator != 44);
        GIFTweaker.readImageDescriptor(is, DTO);
        os.write(44);
        os.write(DTO.imageDescriptor);
        if ((DTO.imageDescriptor[8] & 0x80) == 128) {
            int bitsPerPixel = (DTO.imageDescriptor[8] & 7) + 1;
            int colorsUsed = 1 << bitsPerPixel;
            byte[] localPalette = new byte[3 * colorsUsed];
            is.read(localPalette);
            os.write(localPalette);
        }
        os.write(is.read());
        int len = 0;
        while ((len = is.read()) > 0) {
            os.write(len);
            byte[] block = new byte[len];
            is.read(block);
            os.write(block);
        }
        os.write(0);
        os.write(59);
        os.close();
        return true;
    }

    public static void finishWrite(OutputStream os) throws Exception {
        os.write(59);
        os.close();
    }

    public static void insertComments(InputStream is, OutputStream os, List<String> comments) throws IOException {
        DataTransferObject DTO = new DataTransferObject();
        GIFTweaker.readHeader(is, DTO);
        GIFTweaker.readLSD(is, DTO);
        os.write(DTO.header);
        os.write(DTO.logicalScreenDescriptor);
        if ((DTO.logicalScreenDescriptor[4] & 0x80) == 128) {
            int bitsPerPixel = (DTO.logicalScreenDescriptor[4] & 7) + 1;
            int colorsUsed = 1 << bitsPerPixel;
            GIFTweaker.readGlobalPalette(is, colorsUsed, DTO);
            os.write(DTO.globalPalette);
        }
        int numOfComments = comments.size();
        for (int i = 0; i < numOfComments; ++i) {
            os.write(33);
            os.write(-2);
            byte[] commentBytes = comments.get(i).getBytes();
            int numBlocks = commentBytes.length / 255;
            int leftOver = commentBytes.length % 255;
            int offset = 0;
            if (numBlocks > 0) {
                for (int block = 0; block < numBlocks; ++block) {
                    os.write(255);
                    os.write(commentBytes, offset, 255);
                    offset += 255;
                }
            }
            if (leftOver > 0) {
                os.write(leftOver);
                os.write(commentBytes, offset, leftOver);
            }
            os.write(0);
        }
        byte[] buf = new byte[10240];
        int bytesRead = is.read(buf);
        while (bytesRead != -1) {
            os.write(buf, 0, bytesRead);
            bytesRead = is.read(buf);
        }
    }

    public static void insertXMPApplicationBlock(InputStream is, OutputStream os, XMP xmp) throws IOException {
        DataTransferObject DTO = new DataTransferObject();
        GIFTweaker.readHeader(is, DTO);
        GIFTweaker.readLSD(is, DTO);
        os.write(DTO.header);
        os.write(DTO.logicalScreenDescriptor);
        if ((DTO.logicalScreenDescriptor[4] & 0x80) == 128) {
            int bitsPerPixel = (DTO.logicalScreenDescriptor[4] & 7) + 1;
            int colorsUsed = 1 << bitsPerPixel;
            GIFTweaker.readGlobalPalette(is, colorsUsed, DTO);
            os.write(DTO.globalPalette);
        }
        xmp.write(os);
        byte[] buf = new byte[10240];
        int bytesRead = is.read(buf);
        while (bytesRead != -1) {
            os.write(buf, 0, bytesRead);
            bytesRead = is.read(buf);
        }
    }

    public static void insertXMPApplicationBlock(InputStream is, OutputStream os, byte[] xmp) throws IOException {
        GIFTweaker.insertXMPApplicationBlock(is, os, new GifXMP(xmp));
    }

    public static void prepareForWrite(GIFWriter writer, OutputStream os, int logicalScreenWidth, int logicalScreenHeight) throws Exception {
        writer.prepareForWrite(os, logicalScreenWidth, logicalScreenHeight);
    }

    public static void insertXMPApplicationBlock(InputStream is, OutputStream os, String xmp) throws IOException {
        GIFTweaker.insertXMPApplicationBlock(is, os, new GifXMP(xmp));
    }

    private static boolean readFrame(InputStream is, DataTransferObject DTO) throws IOException {
        int disposalMethod = -1;
        int image_separator = 0;
        do {
            if ((image_separator = is.read()) == -1 || image_separator == 59) {
                return false;
            }
            if (image_separator != 33) continue;
            int func = is.read();
            int len = is.read();
            if (func == 249) {
                int packedFields = is.read();
                disposalMethod = (packedFields & 0x1C) >> 2;
                switch (disposalMethod) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                if ((packedFields & 1) == 1) {
                    IOUtils.skipFully(is, 2);
                    is.read();
                    len = is.read();
                } else {
                    IOUtils.skipFully(is, 3);
                    len = is.read();
                }
            } else if (func == 255) {
                byte[] xmp_id = new byte[]{88, 77, 80, 32, 68, 97, 116, 97, 88, 77, 80};
                byte[] temp = new byte[11];
                IOUtils.readFully(is, temp);
                if (Arrays.equals(xmp_id, temp)) {
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    len = is.read();
                    while (len != 0) {
                        bout.write(len);
                        temp = new byte[len];
                        IOUtils.readFully(is, temp);
                        bout.write(temp);
                        len = is.read();
                    }
                    byte[] xmp = bout.toByteArray();
                    len = xmp.length - 257;
                    if (len > 0) {
                        DTO.metadataMap.put(MetadataType.XMP, new GifXMP(ArrayUtils.subArray(xmp, 0, len)));
                    }
                    len = 0;
                } else {
                    len = is.read();
                }
            } else if (func == 254) {
                byte[] comment = new byte[len];
                IOUtils.readFully(is, comment);
                if (DTO.comments == null) {
                    DTO.comments = new Comments();
                }
                DTO.comments.addComment(comment);
                len = is.read();
            }
            while (len != 0) {
                IOUtils.skipFully(is, len);
                len = is.read();
            }
        } while (image_separator != 44);
        GIFTweaker.readImageDescriptor(is, DTO);
        int colorsUsed = 1 << (DTO.logicalScreenDescriptor[4] & 7) + 1;
        byte[] localPalette = null;
        if ((DTO.imageDescriptor[8] & 0x80) == 128) {
            int bitsPerPixel = (DTO.imageDescriptor[8] & 7) + 1;
            colorsUsed = 1 << bitsPerPixel;
            localPalette = new byte[3 * colorsUsed];
            is.read(localPalette);
        }
        if (localPalette == null) {
            localPalette = DTO.globalPalette;
        }
        is.read();
        int len = 0;
        while ((len = is.read()) > 0) {
            byte[] block = new byte[len];
            is.read(block);
        }
        return true;
    }

    private static void readGlobalPalette(InputStream is, int num_of_color, DataTransferObject DTO) throws IOException {
        DataTransferObject.access$202(DTO, new byte[num_of_color * 3]);
        is.read(DTO.globalPalette);
    }

    private static void readHeader(InputStream is, DataTransferObject DTO) throws IOException {
        DataTransferObject.access$002(DTO, new byte[6]);
        is.read(DTO.header);
    }

    private static void readImageDescriptor(InputStream is, DataTransferObject DTO) throws IOException {
        DataTransferObject.access$302(DTO, new byte[9]);
        is.read(DTO.imageDescriptor);
    }

    private static void readLSD(InputStream is, DataTransferObject DTO) throws IOException {
        DataTransferObject.access$102(DTO, new byte[7]);
        is.read(DTO.logicalScreenDescriptor);
    }

    public static Map<MetadataType, Metadata> readMetadata(InputStream is) throws IOException {
        DataTransferObject DTO = new DataTransferObject();
        DTO.metadataMap = new HashMap();
        GIFTweaker.readHeader(is, DTO);
        GIFTweaker.readLSD(is, DTO);
        if ((DTO.logicalScreenDescriptor[4] & 0x80) == 128) {
            int bitsPerPixel = (DTO.logicalScreenDescriptor[4] & 7) + 1;
            int colorsUsed = 1 << bitsPerPixel;
            GIFTweaker.readGlobalPalette(is, colorsUsed, DTO);
        }
        while (GIFTweaker.readFrame(is, DTO)) {
        }
        if (DTO.comments != null) {
            DTO.metadataMap.put(MetadataType.COMMENT, DTO.comments);
        }
        return DTO.metadataMap;
    }

    public static void splitFrames(InputStream is, String outputFilePrefix) throws Exception {
        String outFileName;
        FileOutputStream os;
        DataTransferObject DTO = new DataTransferObject();
        GIFTweaker.readHeader(is, DTO);
        GIFTweaker.readLSD(is, DTO);
        if ((DTO.logicalScreenDescriptor[4] & 0x80) == 128) {
            int bitsPerPixel = (DTO.logicalScreenDescriptor[4] & 7) + 1;
            int colorsUsed = 1 << bitsPerPixel;
            GIFTweaker.readGlobalPalette(is, colorsUsed, DTO);
        }
        int frameCount = 0;
        while (GIFTweaker.copyFrame(is, os = new FileOutputStream((outFileName = StringUtils.isNullOrEmpty(outputFilePrefix) ? "frame_" + frameCount++ : outputFilePrefix + "_frame_" + frameCount++) + ".gif"), DTO)) {
        }
        os.close();
        new File(outFileName + ".gif").delete();
    }

    @Deprecated
    public static void splitFrames2(InputStream animatedGIF, ImageWriter writer, String outputFilePrefix) throws Exception {
        String baseFileName;
        FrameReader reader = new FrameReader();
        ImageType imageType = writer.getImageType();
        GIFFrame frame = reader.getGIFFrame(animatedGIF);
        int logicalScreenWidth = reader.getLogicalScreenWidth();
        int logicalScreenHeight = reader.getLogicalScreenHeight();
        BufferedImage baseImage = new BufferedImage(logicalScreenWidth, logicalScreenHeight, 2);
        Graphics2D g = baseImage.createGraphics();
        int frameCount = 0;
        String string = baseFileName = StringUtils.isNullOrEmpty(outputFilePrefix) ? "frame_" : outputFilePrefix + "_frame_";
        while (frame != null) {
            int image_x = frame.getLeftPosition();
            int image_y = frame.getTopPosition();
            int imageWidth = frame.getFrameWidth();
            int imageHeight = frame.getFrameHeight();
            Rectangle area = new Rectangle(image_x, image_y, imageWidth, imageHeight);
            BufferedImage backup = new BufferedImage(imageWidth, imageHeight, 2);
            backup.setData(baseImage.getData(area));
            g.drawImage((Image)frame.getFrame(), image_x, image_y, null);
            String outFileName = baseFileName + frameCount++;
            FileOutputStream os = new FileOutputStream(outFileName + "." + imageType.getExtension());
            writer.write(baseImage, os);
            if (frame.getDisposalMethod() != 1 && frame.getDisposalMethod() != 0) {
                Composite oldComposite;
                if (frame.getDisposalMethod() == 2) {
                    oldComposite = g.getComposite();
                    g.setComposite(AlphaComposite.Clear);
                    g.fillRect(image_x, image_y, imageWidth, imageHeight);
                    g.setComposite(oldComposite);
                } else if (frame.getDisposalMethod() == 3) {
                    oldComposite = g.getComposite();
                    g.setComposite(AlphaComposite.Src);
                    g.drawImage((Image)backup, image_x, image_y, null);
                    g.setComposite(oldComposite);
                } else {
                    baseImage = new BufferedImage(logicalScreenWidth, logicalScreenHeight, 2);
                    g = baseImage.createGraphics();
                }
            }
            frame = reader.getGIFFrame(animatedGIF);
        }
    }

    public static void splitAnimatedGIF(InputStream animatedGIF, String outputFilePrefix) throws Exception {
        GIFTweaker.splitAnimatedGIF(animatedGIF, ImageIO.getWriter(ImageType.GIF), outputFilePrefix);
    }

    public static void splitAnimatedGIF(InputStream animatedGIF, ImageWriter writer, String outputFilePrefix) throws Exception {
        String baseFileName;
        FrameReader reader = new FrameReader();
        ImageType imageType = writer.getImageType();
        GIFFrame frame = reader.getGIFFrameEx(animatedGIF);
        int frameCount = 0;
        String string = baseFileName = StringUtils.isNullOrEmpty(outputFilePrefix) ? "frame_" : outputFilePrefix + "_frame_";
        while (frame != null) {
            String outFileName = baseFileName + frameCount++;
            FileOutputStream os = new FileOutputStream(outFileName + "." + imageType.getExtension());
            writer.write(frame.getFrame(), os);
            frame = reader.getGIFFrameEx(animatedGIF);
        }
    }

    public static void writeAnimatedGIF(BufferedImage[] images, int[] delays, int loopCount, OutputStream os) throws Exception {
        GIFTweaker.writeAnimatedGIF(images, delays, loopCount, ImageParam.getBuilder().applyDither(true).build(), os);
    }

    public static void writeAnimatedGIF(BufferedImage[] images, int[] delays, int loopCount, ImageParam param, OutputStream os) throws Exception {
        GIFWriter writer = new GIFWriter();
        writer.setImageParam(param);
        writer.setLoopCount(loopCount);
        writer.writeAnimatedGIF(images, delays, os);
    }

    public static void writeAnimatedGIF(BufferedImage[] images, int[] delays, OutputStream os) throws Exception {
        GIFTweaker.writeAnimatedGIF(images, delays, 0, os);
    }

    public static void writeAnimatedGIF(GIFFrame[] frames, int loopCount, OutputStream os) throws Exception {
        GIFTweaker.writeAnimatedGIF(frames, loopCount, ImageParam.getBuilder().applyDither(true).build(), os);
    }

    public static void writeAnimatedGIF(GIFFrame[] frames, int loopCount, ImageParam param, OutputStream os) throws Exception {
        GIFWriter writer = new GIFWriter();
        writer.setImageParam(param);
        writer.setLoopCount(loopCount);
        writer.writeAnimatedGIF(frames, os);
    }

    public static void writeAnimatedGIF(GIFFrame[] frames, OutputStream os) throws Exception {
        GIFTweaker.writeAnimatedGIF(frames, 0, os);
    }

    public static void writeAnimatedGIF(List<GIFFrame> frames, int loopCount, OutputStream os) throws Exception {
        GIFTweaker.writeAnimatedGIF(frames.toArray(new GIFFrame[0]), loopCount, os);
    }

    public static void writeAnimatedGIF(List<GIFFrame> frames, OutputStream os) throws Exception {
        GIFTweaker.writeAnimatedGIF(frames, 0, os);
    }

    public static void writeFrame(GIFWriter writer, OutputStream os, BufferedImage frame) throws Exception {
        writer.writeFrame(os, frame);
    }

    public static void writeFrame(GIFWriter writer, OutputStream os, BufferedImage frame, int delay) throws Exception {
        writer.writeFrame(os, frame, delay);
    }

    public static void writeFrame(GIFWriter writer, OutputStream os, GIFFrame frame) throws Exception {
        writer.writeFrame(os, frame);
    }

    private GIFTweaker() {
    }

    private static class DataTransferObject {
        private byte[] header;
        private byte[] logicalScreenDescriptor;
        private byte[] globalPalette;
        private byte[] imageDescriptor;
        private Map<MetadataType, Metadata> metadataMap;
        private Comments comments;

        private DataTransferObject() {
        }

        static /* synthetic */ byte[] access$202(DataTransferObject x0, byte[] x1) {
            x0.globalPalette = x1;
            return x1;
        }

        static /* synthetic */ byte[] access$002(DataTransferObject x0, byte[] x1) {
            x0.header = x1;
            return x1;
        }

        static /* synthetic */ byte[] access$302(DataTransferObject x0, byte[] x1) {
            x0.imageDescriptor = x1;
            return x1;
        }

        static /* synthetic */ byte[] access$102(DataTransferObject x0, byte[] x1) {
            x0.logicalScreenDescriptor = x1;
            return x1;
        }
    }
}

