/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.jpeg;

import guilibshadow.cafe4j.image.jpeg.HTable;
import guilibshadow.cafe4j.image.jpeg.Marker;
import guilibshadow.cafe4j.image.jpeg.Segment;
import guilibshadow.cafe4j.util.Reader;
import guilibshadow.org.slf4j.Logger;
import guilibshadow.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DHTReader
implements Reader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DHTReader.class);
    private Segment segment;
    private List<HTable> dcTables = new ArrayList<HTable>(3);
    private List<HTable> acTables = new ArrayList<HTable>(3);

    public DHTReader(Segment segment) throws IOException {
        if (segment.getMarker() != Marker.DHT) {
            throw new IllegalArgumentException("Not a valid DHT segment!");
        }
        this.segment = segment;
        this.read();
    }

    public List<HTable> getDCTables() {
        return this.dcTables;
    }

    public List<HTable> getACTables() {
        return this.acTables;
    }

    @Override
    public void read() throws IOException {
        byte[] data = this.segment.getData();
        int len = this.segment.getLength();
        len -= 2;
        int offset = 0;
        while (len > 0) {
            int i;
            byte HT_info = data[offset++];
            int HT_class = HT_info >> 4 & 1;
            int HT_destination_id = HT_info & 0xF;
            byte[] bits = new byte[16];
            int count = 0;
            for (i = 0; i < 16; ++i) {
                bits[i] = data[offset + i];
                count += bits[i] & 0xFF;
            }
            if (count > 256) {
                LOGGER.error("invalid huffman code count!");
                return;
            }
            offset += 16;
            byte[] values = new byte[count];
            for (i = 0; i < count; ++i) {
                values[i] = data[offset + i];
            }
            offset += count;
            len -= 17 + count;
            HTable table = new HTable(HT_class, HT_destination_id, bits, values);
            if (HT_class == 0) {
                this.dcTables.add(table);
                continue;
            }
            if (HT_class == 1) {
                this.acTables.add(table);
                continue;
            }
            LOGGER.error("Invalid component class value: " + HT_class);
            return;
        }
    }
}

