/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.jpeg;

import guilibshadow.cafe4j.image.jpeg.JPGConsts;
import guilibshadow.cafe4j.image.jpeg.Marker;
import guilibshadow.cafe4j.image.jpeg.QTable;
import guilibshadow.cafe4j.image.jpeg.Segment;
import guilibshadow.cafe4j.io.IOUtils;
import guilibshadow.cafe4j.util.Reader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DQTReader
implements Reader {
    private Segment segment;
    private List<QTable> qTables = new ArrayList<QTable>(4);

    public DQTReader(Segment segment) throws IOException {
        if (segment.getMarker() != Marker.DQT) {
            throw new IllegalArgumentException("Not a valid DQT segment!");
        }
        this.segment = segment;
        this.read();
    }

    public List<QTable> getTables() {
        return this.qTables;
    }

    @Override
    public void read() throws IOException {
        byte[] data = this.segment.getData();
        int len = this.segment.getLength();
        len -= 2;
        int offset = 0;
        int[] de_zig_zag_order = JPGConsts.getDeZigzagMatrix();
        while (len > 0) {
            int j;
            byte QT_info = data[offset++];
            --len;
            int QT_precision = QT_info >> 4 & 0xF;
            int QT_index = QT_info & 0xF;
            int numOfValues = 64 << QT_precision;
            int[] out = new int[64];
            if (QT_precision == 0) {
                for (j = 0; j < 64; ++j) {
                    out[j] = data[de_zig_zag_order[j] + offset] & 0xFF;
                }
            } else {
                for (j = 0; j < 64; ++j) {
                    out[j] = IOUtils.readUnsignedShortMM(data, offset + de_zig_zag_order[j] << 1);
                }
            }
            this.qTables.add(new QTable(QT_precision, QT_index, out));
            len -= numOfValues;
            offset += numOfValues;
        }
    }
}

