/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.jpeg;

import guilibshadow.cafe4j.image.ImageIO;
import guilibshadow.cafe4j.image.ImageType;
import guilibshadow.cafe4j.image.jpeg.COMBuilder;
import guilibshadow.cafe4j.image.jpeg.Component;
import guilibshadow.cafe4j.image.jpeg.DHTReader;
import guilibshadow.cafe4j.image.jpeg.DQTReader;
import guilibshadow.cafe4j.image.jpeg.HTable;
import guilibshadow.cafe4j.image.jpeg.Marker;
import guilibshadow.cafe4j.image.jpeg.QTable;
import guilibshadow.cafe4j.image.jpeg.SOFReader;
import guilibshadow.cafe4j.image.jpeg.SOSReader;
import guilibshadow.cafe4j.image.jpeg.Segment;
import guilibshadow.cafe4j.image.jpeg.UnknownSegment;
import guilibshadow.cafe4j.image.meta.Metadata;
import guilibshadow.cafe4j.image.meta.MetadataType;
import guilibshadow.cafe4j.image.meta.Thumbnail;
import guilibshadow.cafe4j.image.meta.adobe.IRB;
import guilibshadow.cafe4j.image.meta.adobe.IRBThumbnail;
import guilibshadow.cafe4j.image.meta.adobe.ImageResourceID;
import guilibshadow.cafe4j.image.meta.adobe.ThumbnailResource;
import guilibshadow.cafe4j.image.meta.adobe._8BIM;
import guilibshadow.cafe4j.image.meta.exif.Exif;
import guilibshadow.cafe4j.image.meta.exif.ExifThumbnail;
import guilibshadow.cafe4j.image.meta.icc.ICCProfile;
import guilibshadow.cafe4j.image.meta.image.Comments;
import guilibshadow.cafe4j.image.meta.image.ImageMetadata;
import guilibshadow.cafe4j.image.meta.iptc.IPTC;
import guilibshadow.cafe4j.image.meta.iptc.IPTCDataSet;
import guilibshadow.cafe4j.image.meta.iptc.IPTCTag;
import guilibshadow.cafe4j.image.meta.jpeg.Adobe;
import guilibshadow.cafe4j.image.meta.jpeg.Ducky;
import guilibshadow.cafe4j.image.meta.jpeg.JFIF;
import guilibshadow.cafe4j.image.meta.jpeg.JpegExif;
import guilibshadow.cafe4j.image.meta.jpeg.JpegXMP;
import guilibshadow.cafe4j.image.meta.xmp.XMP;
import guilibshadow.cafe4j.image.tiff.IFD;
import guilibshadow.cafe4j.image.tiff.TiffTag;
import guilibshadow.cafe4j.image.util.IMGUtils;
import guilibshadow.cafe4j.image.writer.ImageWriter;
import guilibshadow.cafe4j.io.FileCacheRandomAccessInputStream;
import guilibshadow.cafe4j.io.IOUtils;
import guilibshadow.cafe4j.io.RandomAccessInputStream;
import guilibshadow.cafe4j.string.Base64;
import guilibshadow.cafe4j.string.StringUtils;
import guilibshadow.cafe4j.string.XMLUtils;
import guilibshadow.cafe4j.util.ArrayUtils;
import guilibshadow.org.slf4j.Logger;
import guilibshadow.org.slf4j.LoggerFactory;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;

public class JPGTweaker {
    private static final EnumSet<Marker> APPnMarkers = EnumSet.range(Marker.APP0, Marker.APP15);
    private static final Logger LOGGER = LoggerFactory.getLogger(JPGTweaker.class);

    private static short copySegment(short marker, InputStream is, OutputStream os) throws IOException {
        int length = IOUtils.readUnsignedShortMM(is);
        byte[] buf = new byte[length - 2];
        IOUtils.readFully(is, buf);
        IOUtils.writeShortMM(os, marker);
        IOUtils.writeShortMM(os, (short)length);
        IOUtils.write(os, buf);
        return IOUtils.readShortMM(is);
    }

    private static short copySOS(InputStream is, OutputStream os) throws IOException {
        int nextByte = 0;
        short marker = 0;
        block3: while ((nextByte = IOUtils.read(is)) != -1) {
            if (nextByte == 255) {
                nextByte = IOUtils.read(is);
                if (nextByte == -1) {
                    throw new IOException("Premature end of SOS segment!");
                }
                if (nextByte != 0) {
                    marker = (short)(0xFF00 | nextByte);
                    switch (Marker.fromShort(marker)) {
                        case RST0: 
                        case RST1: 
                        case RST2: 
                        case RST3: 
                        case RST4: 
                        case RST5: 
                        case RST6: 
                        case RST7: {
                            IOUtils.writeShortMM(os, marker);
                            continue block3;
                        }
                    }
                    break;
                }
                IOUtils.write(os, 255);
                IOUtils.write(os, nextByte);
                continue;
            }
            IOUtils.write(os, nextByte);
        }
        if (nextByte == -1) {
            throw new IOException("Premature end of SOS segment!");
        }
        return marker;
    }

    private static void copyToEnd(InputStream is, OutputStream os) throws IOException {
        byte[] buffer = new byte[10240];
        int bytesRead = -1;
        while ((bytesRead = is.read(buffer)) != -1) {
            os.write(buffer, 0, bytesRead);
        }
    }

    public static byte[] extractICCProfile(InputStream is) throws IOException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        boolean finished = false;
        int length = 0;
        if (Marker.fromShort(IOUtils.readShortMM(is)) != Marker.SOI) {
            throw new IOException("Invalid JPEG image, expected SOI marker not found!");
        }
        short marker = IOUtils.readShortMM(is);
        block6: while (!finished) {
            if (Marker.fromShort(marker) == Marker.EOI) {
                finished = true;
                continue;
            }
            Marker emarker = Marker.fromShort(marker);
            switch (emarker) {
                case JPG: 
                case JPG0: 
                case JPG13: 
                case TEM: {
                    marker = IOUtils.readShortMM(is);
                    continue block6;
                }
                case PADDING: {
                    int nextByte = 0;
                    while ((nextByte = IOUtils.read(is)) == 255) {
                    }
                    marker = (short)(0xFF00 | nextByte);
                    continue block6;
                }
                case SOS: {
                    finished = true;
                    continue block6;
                }
                case APP2: {
                    JPGTweaker.readAPP2(is, bo);
                    marker = IOUtils.readShortMM(is);
                    continue block6;
                }
            }
            length = IOUtils.readUnsignedShortMM(is);
            byte[] buf = new byte[length - 2];
            IOUtils.readFully(is, buf);
            marker = IOUtils.readShortMM(is);
        }
        return bo.toByteArray();
    }

    public static void extractICCProfile(InputStream is, String pathToICCProfile) throws IOException {
        byte[] icc_profile = JPGTweaker.extractICCProfile(is);
        if (icc_profile != null && icc_profile.length > 0) {
            String outpath = "";
            outpath = pathToICCProfile.endsWith("\\") || pathToICCProfile.endsWith("/") ? pathToICCProfile + "icc_profile" : pathToICCProfile.replaceFirst("[.][^.]+$", "");
            FileOutputStream os = new FileOutputStream(outpath + ".icc");
            ((OutputStream)os).write(icc_profile);
            ((OutputStream)os).close();
        }
    }

    public static void extractDepthMap(InputStream is, String pathToDepthMap) throws IOException {
        Map<MetadataType, Metadata> meta = JPGTweaker.readMetadata(is);
        XMP xmp = (XMP)meta.get((Object)MetadataType.XMP);
        if (xmp != null) {
            FileOutputStream fout;
            byte[] image;
            String outpath;
            String data;
            Document xmpDocument = xmp.getMergedDocument();
            String depthMapMime = XMLUtils.getAttribute(xmpDocument, "rdf:Description", "GDepth:Mime");
            String depthData = "GDepth:Data";
            String audioMime = XMLUtils.getAttribute(xmpDocument, "rdf:Description", "GAudio:Mime");
            if (StringUtils.isNullOrEmpty(depthMapMime)) {
                depthMapMime = XMLUtils.getAttribute(xmpDocument, "rdf:Description", "GImage:Mime");
                depthData = "GImage:Data";
            }
            if (!StringUtils.isNullOrEmpty(depthMapMime) && !StringUtils.isNullOrEmpty(data = XMLUtils.getAttribute(xmpDocument, "rdf:Description", depthData))) {
                outpath = "";
                outpath = pathToDepthMap.endsWith("\\") || pathToDepthMap.endsWith("/") ? pathToDepthMap + "google_depthmap" : pathToDepthMap.replaceFirst("[.][^.]+$", "") + "_depthmap";
                if (depthMapMime.equalsIgnoreCase("image/png")) {
                    outpath = outpath + ".png";
                } else if (depthMapMime.equalsIgnoreCase("image/jpeg")) {
                    outpath = outpath + ".jpg";
                }
                try {
                    image = Base64.decodeToByteArray(data);
                    fout = new FileOutputStream(new File(outpath));
                    fout.write(image);
                    fout.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!StringUtils.isNullOrEmpty(audioMime) && !StringUtils.isNullOrEmpty(data = XMLUtils.getAttribute(xmpDocument, "rdf:Description", "GAudio:Data"))) {
                outpath = "";
                outpath = pathToDepthMap.endsWith("\\") || pathToDepthMap.endsWith("/") ? pathToDepthMap + "google_cardboard_audio" : pathToDepthMap.replaceFirst("[.][^.]+$", "") + "_cardboard_audio";
                if (audioMime.equalsIgnoreCase("audio/mp4a-latm")) {
                    outpath = outpath + ".mp4";
                }
                try {
                    image = Base64.decodeToByteArray(data);
                    fout = new FileOutputStream(new File(outpath));
                    fout.write(image);
                    fout.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void extractMetadataFromAPPn(Collection<Segment> appnSegments, Map<MetadataType, Metadata> metadataMap) throws IOException {
        Metadata meta;
        XMP xmp;
        ByteArrayOutputStream iccProfileStream = null;
        ByteArrayOutputStream eightBIMStream = null;
        byte[] extendedXMP = null;
        String xmpGUID = "";
        HashMap<String, Thumbnail> thumbnails = new HashMap<String, Thumbnail>();
        for (Segment segment : appnSegments) {
            byte[] data = segment.getData();
            int length = segment.getLength();
            if (segment.getMarker() == Marker.APP0) {
                if (data.length < "JFIF\u0000".length() || !new String(data, 0, "JFIF\u0000".length()).equals("JFIF\u0000")) continue;
                metadataMap.put(MetadataType.JPG_JFIF, new JFIF(ArrayUtils.subArray(data, "JFIF\u0000".length(), length - "JFIF\u0000".length() - 2)));
                continue;
            }
            if (segment.getMarker() == Marker.APP1) {
                int i;
                byte[] guid;
                if (data.length >= "Exif\u0000\u0000".length() && new String(data, 0, "Exif\u0000\u0000".length()).equals("Exif\u0000\u0000")) {
                    JpegExif exif = new JpegExif(ArrayUtils.subArray(data, "Exif\u0000\u0000".length(), length - "Exif\u0000\u0000".length() - 2));
                    metadataMap.put(MetadataType.EXIF, exif);
                    continue;
                }
                if (data.length >= "http://ns.adobe.com/xap/1.0/\u0000".length() && new String(data, 0, "http://ns.adobe.com/xap/1.0/\u0000".length()).equals("http://ns.adobe.com/xap/1.0/\u0000") || data.length >= "XMP\u0000://ns.adobe.com/xap/1.0/\u0000".length() && new String(data, 0, "XMP\u0000://ns.adobe.com/xap/1.0/\u0000".length()).equals("XMP\u0000://ns.adobe.com/xap/1.0/\u0000")) {
                    JpegXMP xmp2 = new JpegXMP(ArrayUtils.subArray(data, "http://ns.adobe.com/xap/1.0/\u0000".length(), length - "http://ns.adobe.com/xap/1.0/\u0000".length() - 2));
                    metadataMap.put(MetadataType.XMP, xmp2);
                    xmpGUID = XMLUtils.getAttribute(xmp2.getXmpDocument(), "rdf:Description", "xmpNote:HasExtendedXMP");
                    continue;
                }
                if (data.length < "http://ns.adobe.com/xmp/extension/\u0000".length() || !new String(data, 0, "http://ns.adobe.com/xmp/extension/\u0000".length()).equals("http://ns.adobe.com/xmp/extension/\u0000") || !Arrays.equals(guid = ArrayUtils.subArray(data, i = "http://ns.adobe.com/xmp/extension/\u0000".length(), 32), xmpGUID.getBytes())) continue;
                long extendedXMPLength = IOUtils.readUnsignedIntMM(data, i += 32);
                i += 4;
                if (extendedXMP == null) {
                    extendedXMP = new byte[(int)extendedXMPLength];
                }
                long offset = IOUtils.readUnsignedIntMM(data, i);
                byte[] xmpBytes = ArrayUtils.subArray(data, i += 4, length - "http://ns.adobe.com/xmp/extension/\u0000".length() - 42);
                System.arraycopy(xmpBytes, 0, extendedXMP, (int)offset, xmpBytes.length);
                continue;
            }
            if (segment.getMarker() == Marker.APP2) {
                if (data.length < "ICC_PROFILE\u0000".length() || !new String(data, 0, "ICC_PROFILE\u0000".length()).equals("ICC_PROFILE\u0000")) continue;
                if (iccProfileStream == null) {
                    iccProfileStream = new ByteArrayOutputStream();
                }
                iccProfileStream.write(ArrayUtils.subArray(data, "ICC_PROFILE\u0000".length() + 2, length - "ICC_PROFILE\u0000".length() - 4));
                continue;
            }
            if (segment.getMarker() == Marker.APP12) {
                if (data.length < "Ducky".length() || !new String(data, 0, "Ducky".length()).equals("Ducky")) continue;
                metadataMap.put(MetadataType.JPG_DUCKY, new Ducky(ArrayUtils.subArray(data, "Ducky".length(), length - "Ducky".length() - 2)));
                continue;
            }
            if (segment.getMarker() == Marker.APP13) {
                if (data.length < "Photoshop 3.0\u0000".length() || !new String(data, 0, "Photoshop 3.0\u0000".length()).equals("Photoshop 3.0\u0000")) continue;
                if (eightBIMStream == null) {
                    eightBIMStream = new ByteArrayOutputStream();
                }
                eightBIMStream.write(ArrayUtils.subArray(data, "Photoshop 3.0\u0000".length(), length - "Photoshop 3.0\u0000".length() - 2));
                continue;
            }
            if (segment.getMarker() != Marker.APP14 || data.length < "Adobe".length() || !new String(data, 0, "Adobe".length()).equals("Adobe")) continue;
            metadataMap.put(MetadataType.JPG_ADOBE, new Adobe(ArrayUtils.subArray(data, "Adobe".length(), length - "Adobe".length() - 2)));
        }
        if (iccProfileStream != null) {
            ICCProfile icc_profile = new ICCProfile(iccProfileStream.toByteArray());
            metadataMap.put(MetadataType.ICC_PROFILE, icc_profile);
        }
        if (eightBIMStream != null) {
            IRB irb = new IRB(eightBIMStream.toByteArray());
            metadataMap.put(MetadataType.PHOTOSHOP_IRB, irb);
            _8BIM iptc = irb.get8BIM(ImageResourceID.IPTC_NAA.getValue());
            if (iptc != null) {
                metadataMap.put(MetadataType.IPTC, new IPTC(iptc.getData()));
            }
        }
        if (extendedXMP != null && (xmp = (XMP)metadataMap.get((Object)MetadataType.XMP)) != null) {
            xmp.setExtendedXMPData(extendedXMP);
        }
        if ((meta = metadataMap.get((Object)MetadataType.EXIF)) != null) {
            Exif exif = (Exif)meta;
            if (!exif.isDataRead()) {
                exif.read();
            }
            if (exif.containsThumbnail()) {
                thumbnails.put("EXIF", exif.getThumbnail());
            }
        }
        if ((meta = metadataMap.get((Object)MetadataType.PHOTOSHOP_IRB)) != null) {
            IRB irb = (IRB)meta;
            if (!irb.isDataRead()) {
                irb.read();
            }
            if (irb.containsThumbnail()) {
                thumbnails.put("PHOTOSHOP_IRB", irb.getThumbnail());
            }
        }
        metadataMap.put(MetadataType.IMAGE, new ImageMetadata(thumbnails));
    }

    public static BufferedImage extractThumbnail(InputStream is) throws IOException {
        Collection<BufferedImage> thumbnails = JPGTweaker.extractThumbnails(is);
        if (thumbnails.size() > 0) {
            return thumbnails.iterator().next();
        }
        return null;
    }

    public static Collection<BufferedImage> extractThumbnails(InputStream is) throws IOException {
        boolean finished = false;
        int length = 0;
        ArrayList<BufferedImage> thumbnails = new ArrayList<BufferedImage>();
        if (Marker.fromShort(IOUtils.readShortMM(is)) != Marker.SOI) {
            throw new IOException("Invalid JPEG image, expected SOI marker not found!");
        }
        short marker = IOUtils.readShortMM(is);
        block8: while (!finished) {
            if (Marker.fromShort(marker) == Marker.EOI) {
                finished = true;
                continue;
            }
            Marker emarker = Marker.fromShort(marker);
            switch (emarker) {
                case JPG: 
                case JPG0: 
                case JPG13: 
                case TEM: {
                    marker = IOUtils.readShortMM(is);
                    continue block8;
                }
                case PADDING: {
                    int nextByte = 0;
                    while ((nextByte = IOUtils.read(is)) == 255) {
                    }
                    marker = (short)(0xFF00 | nextByte);
                    continue block8;
                }
                case SOS: {
                    finished = true;
                    continue block8;
                }
                case APP0: {
                    length = IOUtils.readUnsignedShortMM(is);
                    byte[] jfif_buf = new byte[length - 2];
                    IOUtils.readFully(is, jfif_buf);
                    if (jfif_buf.length >= "JFIF\u0000".length() && new String(jfif_buf, 0, "JFIF\u0000".length()).equals("JFIF\u0000") || jfif_buf.length >= "JFXX\u0000".length() && new String(jfif_buf, 0, "JFXX\u0000".length()).equals("JFXX\u0000")) {
                        int thumbnailWidth = jfif_buf[12] & 0xFF;
                        int thumbnailHeight = jfif_buf[13] & 0xFF;
                        if (thumbnailWidth != 0 && thumbnailHeight != 0) {
                            int size = 3 * thumbnailWidth * thumbnailHeight;
                            DataBufferByte db = new DataBufferByte(ArrayUtils.subArray(jfif_buf, 14, size), size);
                            int[] off = new int[]{0, 1, 2};
                            int numOfBands = 3;
                            int trans = 1;
                            WritableRaster raster = Raster.createInterleavedRaster(db, thumbnailWidth, thumbnailHeight, 3 * thumbnailWidth, numOfBands, off, null);
                            ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1000), false, false, trans, 0);
                            BufferedImage bi = new BufferedImage(cm, raster, false, null);
                            thumbnails.add(bi);
                        }
                    }
                    marker = IOUtils.readShortMM(is);
                    continue block8;
                }
                case APP1: {
                    byte[] exif_buf = new byte["Exif\u0000\u0000".length()];
                    length = IOUtils.readUnsignedShortMM(is);
                    IOUtils.readFully(is, exif_buf);
                    if (Arrays.equals(exif_buf, "Exif\u0000\u0000".getBytes())) {
                        exif_buf = new byte[length - 8];
                        IOUtils.readFully(is, exif_buf);
                        JpegExif exif = new JpegExif(exif_buf);
                        if (exif.containsThumbnail()) {
                            ExifThumbnail thumbnail = exif.getThumbnail();
                            thumbnails.add(thumbnail.getAsBufferedImage());
                        }
                    } else {
                        IOUtils.skipFully(is, length - 8);
                    }
                    marker = IOUtils.readShortMM(is);
                    continue block8;
                }
                case APP13: {
                    IRB irb;
                    length = IOUtils.readUnsignedShortMM(is);
                    byte[] data = new byte[length - 2];
                    IOUtils.readFully(is, data, 0, length - 2);
                    int i = 0;
                    while (data[i] != 0) {
                        ++i;
                    }
                    if (new String(data, 0, i++).equals("Photoshop 3.0") && (irb = new IRB(ArrayUtils.subArray(data, i, data.length - i))).containsThumbnail()) {
                        IRBThumbnail thumbnail = irb.getThumbnail();
                        thumbnails.add(thumbnail.getAsBufferedImage());
                    }
                    marker = IOUtils.readShortMM(is);
                    continue block8;
                }
            }
            length = IOUtils.readUnsignedShortMM(is);
            byte[] buf = new byte[length - 2];
            IOUtils.readFully(is, buf);
            marker = IOUtils.readShortMM(is);
        }
        return thumbnails;
    }

    public static void extractThumbnails(InputStream is, String pathToThumbnail) throws IOException {
        boolean finished = false;
        int length = 0;
        if (Marker.fromShort(IOUtils.readShortMM(is)) != Marker.SOI) {
            throw new IOException("Invalid JPEG image, expected SOI marker not found!");
        }
        short marker = IOUtils.readShortMM(is);
        block12: while (!finished) {
            if (Marker.fromShort(marker) == Marker.EOI) {
                finished = true;
                continue;
            }
            Marker emarker = Marker.fromShort(marker);
            switch (emarker) {
                case JPG: 
                case JPG0: 
                case JPG13: 
                case TEM: {
                    marker = IOUtils.readShortMM(is);
                    continue block12;
                }
                case PADDING: {
                    int nextByte = 0;
                    while ((nextByte = IOUtils.read(is)) == 255) {
                    }
                    marker = (short)(0xFF00 | nextByte);
                    continue block12;
                }
                case SOS: {
                    finished = true;
                    continue block12;
                }
                case APP0: {
                    length = IOUtils.readUnsignedShortMM(is);
                    byte[] jfif_buf = new byte[length - 2];
                    IOUtils.readFully(is, jfif_buf);
                    if (jfif_buf.length >= "JFIF\u0000".length() && new String(jfif_buf, 0, "JFIF\u0000".length()).equals("JFIF\u0000") || jfif_buf.length >= "JFXX\u0000".length() && new String(jfif_buf, 0, "JFXX\u0000".length()).equals("JFXX\u0000")) {
                        int thumbnailWidth = jfif_buf[12] & 0xFF;
                        int thumbnailHeight = jfif_buf[13] & 0xFF;
                        String outpath = "";
                        outpath = pathToThumbnail.endsWith("\\") || pathToThumbnail.endsWith("/") ? pathToThumbnail + "jfif_thumbnail" : pathToThumbnail.replaceFirst("[.][^.]+$", "") + "_jfif_t";
                        if (thumbnailWidth != 0 && thumbnailHeight != 0) {
                            int size = 3 * thumbnailWidth * thumbnailHeight;
                            DataBufferByte db = new DataBufferByte(ArrayUtils.subArray(jfif_buf, 14, size), size);
                            int[] off = new int[]{0, 1, 2};
                            int numOfBands = 3;
                            int trans = 1;
                            WritableRaster raster = Raster.createInterleavedRaster(db, thumbnailWidth, thumbnailHeight, 3 * thumbnailWidth, numOfBands, off, null);
                            ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1000), false, false, trans, 0);
                            BufferedImage bi = new BufferedImage(cm, raster, false, null);
                            ImageWriter writer = ImageIO.getWriter(ImageType.JPG);
                            FileOutputStream fout = new FileOutputStream(outpath + ".jpg");
                            try {
                                writer.write(bi, fout);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            fout.close();
                        }
                    }
                    marker = IOUtils.readShortMM(is);
                    continue block12;
                }
                case APP1: {
                    byte[] exif_buf = new byte["Exif\u0000\u0000".length()];
                    length = IOUtils.readUnsignedShortMM(is);
                    IOUtils.readFully(is, exif_buf);
                    if (Arrays.equals(exif_buf, "Exif\u0000\u0000".getBytes())) {
                        exif_buf = new byte[length - 8];
                        IOUtils.readFully(is, exif_buf);
                        JpegExif exif = new JpegExif(exif_buf);
                        if (exif.containsThumbnail()) {
                            String outpath = "";
                            outpath = pathToThumbnail.endsWith("\\") || pathToThumbnail.endsWith("/") ? pathToThumbnail + "exif_thumbnail" : pathToThumbnail.replaceFirst("[.][^.]+$", "") + "_exif_t";
                            ExifThumbnail thumbnail = exif.getThumbnail();
                            FileOutputStream fout = null;
                            fout = thumbnail.getDataType() == 1 ? new FileOutputStream(outpath + ".jpg") : new FileOutputStream(outpath + ".tif");
                            ((OutputStream)fout).write(thumbnail.getCompressedImage());
                            ((OutputStream)fout).close();
                        }
                    } else {
                        IOUtils.skipFully(is, length - 8);
                    }
                    marker = IOUtils.readShortMM(is);
                    continue block12;
                }
                case APP13: {
                    IRB irb;
                    length = IOUtils.readUnsignedShortMM(is);
                    byte[] data = new byte[length - 2];
                    IOUtils.readFully(is, data, 0, length - 2);
                    int i = 0;
                    while (data[i] != 0) {
                        ++i;
                    }
                    if (new String(data, 0, i++).equals("Photoshop 3.0") && (irb = new IRB(ArrayUtils.subArray(data, i, data.length - i))).containsThumbnail()) {
                        IRBThumbnail thumbnail = irb.getThumbnail();
                        String outpath = "";
                        outpath = pathToThumbnail.endsWith("\\") || pathToThumbnail.endsWith("/") ? pathToThumbnail + "photoshop_thumbnail.jpg" : pathToThumbnail.replaceFirst("[.][^.]+$", "") + "_photoshop_t.jpg";
                        FileOutputStream fout = new FileOutputStream(outpath);
                        if (thumbnail.getDataType() == 1) {
                            fout.write(thumbnail.getCompressedImage());
                        } else {
                            ImageWriter writer = ImageIO.getWriter(ImageType.JPG);
                            try {
                                writer.write(thumbnail.getRawImage(), fout);
                            }
                            catch (Exception e) {
                                throw new IOException("Writing thumbnail failed!");
                            }
                        }
                        fout.close();
                    }
                    marker = IOUtils.readShortMM(is);
                    continue block12;
                }
            }
            length = IOUtils.readUnsignedShortMM(is);
            byte[] buf = new byte[length - 2];
            IOUtils.readFully(is, buf);
            marker = IOUtils.readShortMM(is);
        }
    }

    public static ICCProfile getICCProfile(InputStream is) throws IOException {
        ICCProfile profile = null;
        byte[] buf = JPGTweaker.extractICCProfile(is);
        if (buf.length > 0) {
            profile = new ICCProfile(buf);
        }
        return profile;
    }

    public static void insertComments(InputStream is, OutputStream os, List<String> comments) throws IOException {
        boolean finished = false;
        if (Marker.fromShort(IOUtils.readShortMM(is)) != Marker.SOI) {
            throw new IOException("Invalid JPEG image, expected SOI marker not found!");
        }
        IOUtils.writeShortMM(os, Marker.SOI.getValue());
        short marker = IOUtils.readShortMM(is);
        block4: while (!finished) {
            if (Marker.fromShort(marker) == Marker.SOS) {
                for (String comment : comments) {
                    JPGTweaker.writeComment(comment, os);
                }
                IOUtils.writeShortMM(os, marker);
                JPGTweaker.copyToEnd(is, os);
                finished = true;
                continue;
            }
            Marker emarker = Marker.fromShort(marker);
            switch (emarker) {
                case JPG: 
                case JPG0: 
                case JPG13: 
                case TEM: {
                    IOUtils.writeShortMM(os, marker);
                    marker = IOUtils.readShortMM(is);
                    continue block4;
                }
                case PADDING: {
                    IOUtils.writeShortMM(os, marker);
                    int nextByte = 0;
                    while ((nextByte = IOUtils.read(is)) == 255) {
                        IOUtils.write(os, nextByte);
                    }
                    marker = (short)(0xFF00 | nextByte);
                    continue block4;
                }
            }
            marker = JPGTweaker.copySegment(marker, is, os);
        }
    }

    public static void insertExif(InputStream is, OutputStream os, Exif exif, boolean update) throws IOException {
        if (exif.isThumbnailRequired() && !exif.containsThumbnail()) {
            is = new FileCacheRandomAccessInputStream(is);
            exif.setThumbnailImage(IMGUtils.createThumbnail(is));
        }
        Exif oldExif = null;
        int app0Index = -1;
        boolean finished = false;
        int length = 0;
        if (Marker.fromShort(IOUtils.readShortMM(is)) != Marker.SOI) {
            throw new IOException("Invalid JPEG image, expected SOI marker not found!");
        }
        IOUtils.writeShortMM(os, Marker.SOI.getValue());
        short marker = IOUtils.readShortMM(is);
        ArrayList<Segment> segments = new ArrayList<Segment>();
        block5: while (!finished) {
            if (Marker.fromShort(marker) == Marker.SOS) {
                for (int i = 0; i <= app0Index; ++i) {
                    ((Segment)segments.get(i)).write(os);
                }
                IFD newExifSubIFD = exif.getExifIFD();
                IFD newGpsSubIFD = exif.getGPSIFD();
                IFD newImageIFD = exif.getImageIFD();
                ExifThumbnail newThumbnail = exif.getThumbnail();
                IFD exifSubIFD = null;
                IFD gpsSubIFD = null;
                IFD imageIFD = null;
                if (update && oldExif != null) {
                    IFD oldImageIFD = oldExif.getImageIFD();
                    IFD oldExifSubIFD = oldExif.getExifIFD();
                    IFD oldGpsSubIFD = oldExif.getGPSIFD();
                    ExifThumbnail thumbnail = oldExif.getThumbnail();
                    if (oldImageIFD != null) {
                        imageIFD = new IFD();
                        imageIFD.addFields(oldImageIFD.getFields());
                    }
                    if (thumbnail != null && newThumbnail == null) {
                        newThumbnail = thumbnail;
                    }
                    if (oldExifSubIFD != null) {
                        exifSubIFD = new IFD();
                        exifSubIFD.addFields(oldExifSubIFD.getFields());
                    }
                    if (oldGpsSubIFD != null) {
                        gpsSubIFD = new IFD();
                        gpsSubIFD.addFields(oldGpsSubIFD.getFields());
                    }
                }
                if (newImageIFD != null) {
                    if (imageIFD == null) {
                        imageIFD = new IFD();
                    }
                    imageIFD.addFields(newImageIFD.getFields());
                }
                if (exifSubIFD != null) {
                    if (newExifSubIFD != null) {
                        exifSubIFD.addFields(newExifSubIFD.getFields());
                    }
                } else {
                    exifSubIFD = newExifSubIFD;
                }
                if (gpsSubIFD != null) {
                    if (newGpsSubIFD != null) {
                        gpsSubIFD.addFields(newGpsSubIFD.getFields());
                    }
                } else {
                    gpsSubIFD = newGpsSubIFD;
                }
                if (imageIFD != null) {
                    if (exifSubIFD != null) {
                        imageIFD.addChild(TiffTag.EXIF_SUB_IFD, exifSubIFD);
                    }
                    if (gpsSubIFD != null) {
                        imageIFD.addChild(TiffTag.GPS_SUB_IFD, gpsSubIFD);
                    }
                    exif.setImageIFD(imageIFD);
                } else {
                    exif.setExifIFD(exifSubIFD);
                    exif.setGPSIFD(gpsSubIFD);
                }
                exif.setThumbnail(newThumbnail);
                exif.write(os);
                for (int i = app0Index + 1; i < segments.size(); ++i) {
                    ((Segment)segments.get(i)).write(os);
                }
                IOUtils.writeShortMM(os, marker);
                JPGTweaker.copyToEnd(is, os);
                finished = true;
                continue;
            }
            Marker emarker = Marker.fromShort(marker);
            switch (emarker) {
                case JPG: 
                case JPG0: 
                case JPG13: 
                case TEM: {
                    segments.add(new Segment(emarker, 0, null));
                    marker = IOUtils.readShortMM(is);
                    continue block5;
                }
                case APP1: {
                    length = IOUtils.readUnsignedShortMM(is);
                    byte[] exifBytes = new byte[length - 2];
                    IOUtils.readFully(is, exifBytes);
                    segments.add(new Segment(emarker, length, exifBytes));
                    if (exifBytes.length >= "Exif\u0000\u0000".length() && new String(exifBytes, 0, "Exif\u0000\u0000".length()).equals("Exif\u0000\u0000")) {
                        oldExif = new JpegExif(ArrayUtils.subArray(exifBytes, "Exif\u0000\u0000".length(), length - "Exif\u0000\u0000".length() - 2));
                        segments.remove(segments.size() - 1);
                    }
                    marker = IOUtils.readShortMM(is);
                    continue block5;
                }
                case APP0: {
                    app0Index = segments.size();
                }
            }
            length = IOUtils.readUnsignedShortMM(is);
            byte[] buf = new byte[length - 2];
            IOUtils.readFully(is, buf);
            if (emarker == Marker.UNKNOWN) {
                segments.add(new UnknownSegment(marker, length, buf));
            } else {
                segments.add(new Segment(emarker, length, buf));
            }
            marker = IOUtils.readShortMM(is);
        }
        if (is instanceof RandomAccessInputStream) {
            ((RandomAccessInputStream)is).shallowClose();
        }
    }

    public static void insertICCProfile(InputStream is, OutputStream os, byte[] data) throws IOException {
        byte[] icc_profile_id = new byte[]{73, 67, 67, 95, 80, 82, 79, 70, 73, 76, 69, 0};
        boolean finished = false;
        int length = 0;
        int app0Index = -1;
        int app1Index = -1;
        if (Marker.fromShort(IOUtils.readShortMM(is)) != Marker.SOI) {
            throw new IOException("Invalid JPEG image, expected SOI marker not found!");
        }
        IOUtils.writeShortMM(os, Marker.SOI.getValue());
        short marker = IOUtils.readShortMM(is);
        ArrayList<Segment> segments = new ArrayList<Segment>();
        block6: while (!finished) {
            if (Marker.fromShort(marker) == Marker.SOS) {
                int i;
                int index = Math.max(app0Index, app1Index);
                for (i = 0; i <= index; ++i) {
                    ((Segment)segments.get(i)).write(os);
                }
                JPGTweaker.writeICCProfile(os, data);
                for (i = index + 1; i < segments.size(); ++i) {
                    ((Segment)segments.get(i)).write(os);
                }
                IOUtils.writeShortMM(os, marker);
                JPGTweaker.copyToEnd(is, os);
                finished = true;
                continue;
            }
            Marker emarker = Marker.fromShort(marker);
            switch (emarker) {
                case JPG: 
                case JPG0: 
                case JPG13: 
                case TEM: {
                    segments.add(new Segment(emarker, 0, null));
                    marker = IOUtils.readShortMM(is);
                    continue block6;
                }
                case APP2: {
                    byte[] icc_profile_buf = new byte[12];
                    length = IOUtils.readUnsignedShortMM(is);
                    if (length < 14) {
                        icc_profile_buf = new byte[length - 2];
                        IOUtils.readFully(is, icc_profile_buf);
                        segments.add(new Segment(emarker, length, icc_profile_buf));
                    } else {
                        IOUtils.readFully(is, icc_profile_buf);
                        if (Arrays.equals(icc_profile_buf, icc_profile_id)) {
                            IOUtils.skipFully(is, length - 14);
                        } else {
                            IOUtils.writeShortMM(os, marker);
                            IOUtils.writeShortMM(os, (short)length);
                            IOUtils.write(os, icc_profile_buf);
                            byte[] temp = new byte[length - "ICC_PROFILE\u0000".length() - 2];
                            IOUtils.readFully(is, temp);
                            segments.add(new Segment(emarker, length, ArrayUtils.concat(icc_profile_buf, new byte[][]{temp})));
                        }
                    }
                    marker = IOUtils.readShortMM(is);
                    continue block6;
                }
                case APP0: {
                    app0Index = segments.size();
                }
                case APP1: {
                    app1Index = segments.size();
                }
            }
            length = IOUtils.readUnsignedShortMM(is);
            byte[] buf = new byte[length - 2];
            IOUtils.readFully(is, buf);
            if (emarker == Marker.UNKNOWN) {
                segments.add(new UnknownSegment(marker, length, buf));
            } else {
                segments.add(new Segment(emarker, length, buf));
            }
            marker = IOUtils.readShortMM(is);
        }
    }

    public static void insertICCProfile(InputStream is, OutputStream os, ICC_Profile icc_profile) throws IOException {
        JPGTweaker.insertICCProfile(is, os, icc_profile.getData());
    }

    public static void insertICCProfile(InputStream is, OutputStream os, ICCProfile icc_profile) throws Exception {
        JPGTweaker.insertICCProfile(is, os, icc_profile.getData());
    }

    public static void insertIPTC(InputStream is, OutputStream os, Collection<IPTCDataSet> iptcs, boolean update) throws IOException {
        boolean finished = false;
        int length = 0;
        int app0Index = -1;
        int app1Index = -1;
        HashMap<Short, _8BIM> bimMap = null;
        ByteArrayOutputStream eightBIMStream = null;
        if (Marker.fromShort(IOUtils.readShortMM(is)) != Marker.SOI) {
            is.close();
            os.close();
            throw new IOException("Invalid JPEG image, expected SOI marker not found!");
        }
        IOUtils.writeShortMM(os, Marker.SOI.getValue());
        short marker = IOUtils.readShortMM(is);
        ArrayList<Segment> segments = new ArrayList<Segment>();
        block6: while (!finished) {
            if (Marker.fromShort(marker) == Marker.SOS) {
                IRB irb;
                _8BIM iptcBIM;
                if (eightBIMStream != null && (iptcBIM = (_8BIM)(bimMap = new HashMap<Short, _8BIM>((irb = new IRB(eightBIMStream.toByteArray())).get8BIM())).remove(ImageResourceID.IPTC_NAA.getValue())) != null && update) {
                    IPTC iptc = new IPTC(iptcBIM.getData());
                    HashMap<IPTCTag, List<IPTCDataSet>> dataSetMap = new HashMap<IPTCTag, List<IPTCDataSet>>(iptc.getDataSets());
                    for (IPTCDataSet set : iptcs) {
                        if (set.allowMultiple()) continue;
                        dataSetMap.remove(set.getTagEnum());
                    }
                    for (List iptcList : dataSetMap.values()) {
                        iptcs.addAll(iptcList);
                    }
                }
                int index = Math.max(app0Index, app1Index);
                for (int i = 0; i <= index; ++i) {
                    ((Segment)segments.get(i)).write(os);
                }
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                ArrayList<IPTCDataSet> iptcList = new ArrayList<IPTCDataSet>(iptcs);
                Collections.sort(iptcList);
                for (IPTCDataSet iptc : iptcList) {
                    iptc.write(bout);
                }
                _8BIM newBIM = new _8BIM(ImageResourceID.IPTC_NAA.getValue(), "iptc", bout.toByteArray());
                if (bimMap != null) {
                    bimMap.put(newBIM.getID(), newBIM);
                    JPGTweaker.writeIRB(os, bimMap.values());
                } else {
                    JPGTweaker.writeIRB(os, newBIM);
                }
                for (int i = index + 1; i < segments.size(); ++i) {
                    ((Segment)segments.get(i)).write(os);
                }
                IOUtils.writeShortMM(os, marker);
                JPGTweaker.copyToEnd(is, os);
                finished = true;
                continue;
            }
            Marker emarker = Marker.fromShort(marker);
            switch (emarker) {
                case JPG: 
                case JPG0: 
                case JPG13: 
                case TEM: {
                    segments.add(new Segment(emarker, 0, null));
                    marker = IOUtils.readShortMM(is);
                    continue block6;
                }
                case APP13: {
                    if (eightBIMStream == null) {
                        eightBIMStream = new ByteArrayOutputStream();
                    }
                    JPGTweaker.readAPP13(is, eightBIMStream);
                    marker = IOUtils.readShortMM(is);
                    continue block6;
                }
                case APP0: {
                    app0Index = segments.size();
                }
                case APP1: {
                    app1Index = segments.size();
                }
            }
            length = IOUtils.readUnsignedShortMM(is);
            byte[] buf = new byte[length - 2];
            IOUtils.readFully(is, buf);
            if (emarker == Marker.UNKNOWN) {
                segments.add(new UnknownSegment(marker, length, buf));
            } else {
                segments.add(new Segment(emarker, length, buf));
            }
            marker = IOUtils.readShortMM(is);
        }
    }

    public static void insertIRB(InputStream is, OutputStream os, Collection<_8BIM> bims, boolean update) throws IOException {
        boolean finished = false;
        int length = 0;
        int app0Index = -1;
        int app1Index = -1;
        ByteArrayOutputStream eightBIMStream = null;
        if (Marker.fromShort(IOUtils.readShortMM(is)) != Marker.SOI) {
            is.close();
            os.close();
            throw new IOException("Invalid JPEG image, expected SOI marker not found!");
        }
        IOUtils.writeShortMM(os, Marker.SOI.getValue());
        short marker = IOUtils.readShortMM(is);
        ArrayList<Segment> segments = new ArrayList<Segment>();
        block6: while (!finished) {
            if (Marker.fromShort(marker) == Marker.SOS) {
                int i;
                if (eightBIMStream != null) {
                    IRB irb = new IRB(eightBIMStream.toByteArray());
                    HashMap<Short, _8BIM> bimMap = new HashMap<Short, _8BIM>(irb.get8BIM());
                    for (_8BIM bim : bims) {
                        bimMap.put(bim.getID(), bim);
                    }
                    if (bimMap.containsKey(ImageResourceID.THUMBNAIL_RESOURCE_PS4.getValue()) && bimMap.containsKey(ImageResourceID.THUMBNAIL_RESOURCE_PS5.getValue())) {
                        bimMap.remove(ImageResourceID.THUMBNAIL_RESOURCE_PS4.getValue());
                    }
                    bims = bimMap.values();
                }
                int index = Math.max(app0Index, app1Index);
                for (i = 0; i <= index; ++i) {
                    ((Segment)segments.get(i)).write(os);
                }
                JPGTweaker.writeIRB(os, bims);
                for (i = index + 1; i < segments.size(); ++i) {
                    ((Segment)segments.get(i)).write(os);
                }
                IOUtils.writeShortMM(os, marker);
                JPGTweaker.copyToEnd(is, os);
                finished = true;
                continue;
            }
            Marker emarker = Marker.fromShort(marker);
            switch (emarker) {
                case JPG: 
                case JPG0: 
                case JPG13: 
                case TEM: {
                    segments.add(new Segment(emarker, 0, null));
                    marker = IOUtils.readShortMM(is);
                    continue block6;
                }
                case APP13: {
                    if (update) {
                        if (eightBIMStream == null) {
                            eightBIMStream = new ByteArrayOutputStream();
                        }
                        JPGTweaker.readAPP13(is, eightBIMStream);
                    } else {
                        length = IOUtils.readUnsignedShortMM(is);
                        IOUtils.skipFully(is, length - 2);
                    }
                    marker = IOUtils.readShortMM(is);
                    continue block6;
                }
                case APP0: {
                    app0Index = segments.size();
                }
                case APP1: {
                    app1Index = segments.size();
                }
            }
            length = IOUtils.readUnsignedShortMM(is);
            byte[] buf = new byte[length - 2];
            IOUtils.readFully(is, buf);
            if (emarker == Marker.UNKNOWN) {
                segments.add(new UnknownSegment(marker, length, buf));
            } else {
                segments.add(new Segment(emarker, length, buf));
            }
            marker = IOUtils.readShortMM(is);
        }
    }

    public static void insertIRBThumbnail(InputStream is, OutputStream os, BufferedImage thumbnail) throws IOException {
        if (thumbnail == null) {
            throw new IllegalArgumentException("Input thumbnail is null");
        }
        ThumbnailResource bim = new ThumbnailResource(thumbnail);
        JPGTweaker.insertIRB(is, os, Arrays.asList(bim), true);
    }

    public static void insertMetadata(Collection<Metadata> metadata, InputStream is, OutputStream os) throws IOException {
        IRB irb;
        boolean finished = false;
        int length = 0;
        int app0Index = -1;
        int exifIndex = -1;
        ByteArrayOutputStream eightBIMStream = null;
        HashMap<MetadataType, Metadata> metadataMap = new HashMap<MetadataType, Metadata>();
        for (Metadata meta : metadata) {
            metadataMap.put(meta.getType(), meta);
        }
        if (metadataMap.get((Object)MetadataType.IPTC) != null && (irb = (IRB)metadataMap.get((Object)MetadataType.PHOTOSHOP_IRB)) != null) {
            HashMap<Short, _8BIM> bimMap = new HashMap<Short, _8BIM>(irb.get8BIM());
            bimMap.remove(ImageResourceID.IPTC_NAA.getValue());
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            for (_8BIM bim : bimMap.values()) {
                bim.write(bout);
            }
            metadataMap.put(MetadataType.PHOTOSHOP_IRB, new IRB(bout.toByteArray()));
        }
        ArrayList<Segment> segments = new ArrayList<Segment>();
        Exif exif = (Exif)metadataMap.remove((Object)MetadataType.EXIF);
        if (exif != null && exif.isThumbnailRequired() && !exif.containsThumbnail()) {
            is = new FileCacheRandomAccessInputStream(is);
            exif.setThumbnailImage(IMGUtils.createThumbnail(is));
        }
        if (Marker.fromShort(IOUtils.readShortMM(is)) != Marker.SOI) {
            throw new IllegalArgumentException("Invalid JPEG image, expected SOI marker not found!");
        }
        IOUtils.writeShortMM(os, Marker.SOI.getValue());
        short marker = IOUtils.readShortMM(is);
        block9: while (!finished) {
            if (Marker.fromShort(marker) == Marker.SOS) {
                Comments comments;
                IRB irb2;
                IPTC iptc;
                ICCProfile profile;
                XMP xmp;
                int i;
                JFIF jfif = (JFIF)metadataMap.remove((Object)MetadataType.JPG_JFIF);
                for (int i2 = 0; i2 < app0Index; ++i2) {
                    ((Segment)segments.get(i2)).write(os);
                }
                if (jfif != null) {
                    // empty if block
                }
                int index = Math.max(app0Index, exifIndex);
                int n = i = app0Index < 0 ? 0 : app0Index;
                while (i < index) {
                    ((Segment)segments.get(i)).write(os);
                    ++i;
                }
                if (exif != null) {
                    exif.write(os);
                }
                if ((xmp = (XMP)metadataMap.remove((Object)MetadataType.XMP)) instanceof JpegXMP) {
                    xmp.write(os);
                }
                if ((profile = (ICCProfile)metadataMap.remove((Object)MetadataType.ICC_PROFILE)) != null) {
                    profile.write(os);
                }
                if ((iptc = (IPTC)metadataMap.remove((Object)MetadataType.IPTC)) != null) {
                    HashMap<Short, _8BIM> bimMap = null;
                    if (eightBIMStream != null) {
                        IRB irb3 = new IRB(eightBIMStream.toByteArray());
                        bimMap = new HashMap<Short, _8BIM>(irb3.get8BIM());
                        bimMap.remove(ImageResourceID.IPTC_NAA.getValue());
                        eightBIMStream.reset();
                    } else {
                        eightBIMStream = new ByteArrayOutputStream();
                    }
                    iptc.write(eightBIMStream);
                    _8BIM newBIM = new _8BIM(ImageResourceID.IPTC_NAA.getValue(), "iptc", eightBIMStream.toByteArray());
                    if (bimMap != null) {
                        bimMap.put(newBIM.getID(), newBIM);
                        JPGTweaker.writeIRB(os, bimMap.values());
                    } else {
                        JPGTweaker.writeIRB(os, newBIM);
                    }
                }
                if ((irb2 = (IRB)metadataMap.remove((Object)MetadataType.PHOTOSHOP_IRB)) != null) {
                    JPGTweaker.writeIRB(os, irb2.get8BIM().values());
                }
                if ((comments = (Comments)metadataMap.remove((Object)MetadataType.COMMENT)) != null) {
                    for (String comment : comments.getComments()) {
                        JPGTweaker.writeComment(comment, os);
                    }
                }
                for (int i3 = index; i3 < segments.size(); ++i3) {
                    ((Segment)segments.get(i3)).write(os);
                }
                IOUtils.writeShortMM(os, marker);
                JPGTweaker.copyToEnd(is, os);
                finished = true;
                continue;
            }
            Marker emarker = Marker.fromShort(marker);
            switch (emarker) {
                case JPG: 
                case JPG0: 
                case JPG13: 
                case TEM: {
                    segments.add(new Segment(emarker, 0, null));
                    marker = IOUtils.readShortMM(is);
                    continue block9;
                }
                case APP0: {
                    length = IOUtils.readUnsignedShortMM(is);
                    byte[] app0Bytes = new byte[length - 2];
                    IOUtils.readFully(is, app0Bytes);
                    if (metadataMap.get((Object)MetadataType.JPG_JFIF) != null) {
                        segments.add(new Segment(emarker, length, app0Bytes));
                    } else {
                        segments.add(new Segment(emarker, length, app0Bytes));
                    }
                    app0Index = segments.size();
                    marker = IOUtils.readShortMM(is);
                    continue block9;
                }
                case APP1: {
                    length = IOUtils.readUnsignedShortMM(is);
                    byte[] temp = new byte[length - 2];
                    IOUtils.readFully(is, temp);
                    if (!(metadataMap.get((Object)MetadataType.XMP) != null && temp.length >= "http://ns.adobe.com/xmp/extension/\u0000".length() && new String(temp, 0, "http://ns.adobe.com/xmp/extension/\u0000".length()).equals("http://ns.adobe.com/xmp/extension/\u0000") || metadataMap.get((Object)MetadataType.XMP) != null && temp.length >= "http://ns.adobe.com/xap/1.0/\u0000".length() && new String(temp, 0, "http://ns.adobe.com/xap/1.0/\u0000".length()).equals("http://ns.adobe.com/xap/1.0/\u0000"))) {
                        if (exif != null && temp.length >= "Exif\u0000\u0000".length() && new String(temp, 0, "Exif\u0000\u0000".length()).equals("Exif\u0000\u0000")) {
                            exifIndex = segments.size();
                        } else {
                            segments.add(new Segment(emarker, length, temp));
                        }
                    }
                    marker = IOUtils.readShortMM(is);
                    continue block9;
                }
                case APP2: {
                    length = IOUtils.readUnsignedShortMM(is);
                    byte[] icc_profile_buf = new byte[length - 2];
                    IOUtils.readFully(is, icc_profile_buf);
                    if (metadataMap.get((Object)MetadataType.ICC_PROFILE) == null || icc_profile_buf.length < "ICC_PROFILE\u0000".length() || !new String(icc_profile_buf, 0, "ICC_PROFILE\u0000".length()).equals("ICC_PROFILE\u0000")) {
                        segments.add(new Segment(emarker, length, icc_profile_buf));
                    }
                    marker = IOUtils.readShortMM(is);
                    continue block9;
                }
                case APP13: {
                    if (eightBIMStream == null) {
                        eightBIMStream = new ByteArrayOutputStream();
                    }
                    JPGTweaker.readAPP13(is, eightBIMStream);
                    marker = IOUtils.readShortMM(is);
                    continue block9;
                }
            }
            length = IOUtils.readUnsignedShortMM(is);
            byte[] buf = new byte[length - 2];
            IOUtils.readFully(is, buf);
            if (emarker == Marker.UNKNOWN) {
                segments.add(new UnknownSegment(marker, length, buf));
            } else {
                segments.add(new Segment(emarker, length, buf));
            }
            marker = IOUtils.readShortMM(is);
        }
        if (is instanceof RandomAccessInputStream) {
            ((RandomAccessInputStream)is).shallowClose();
        }
    }

    public static void insertXMP(InputStream is, OutputStream os, XMP jpegXmp) throws IOException {
        boolean finished = false;
        int length = 0;
        int app0Index = -1;
        int exifIndex = -1;
        if (Marker.fromShort(IOUtils.readShortMM(is)) != Marker.SOI) {
            throw new IOException("Invalid JPEG image, expected SOI marker not found!");
        }
        IOUtils.writeShortMM(os, Marker.SOI.getValue());
        short marker = IOUtils.readShortMM(is);
        ArrayList<Segment> segments = new ArrayList<Segment>();
        block5: while (!finished) {
            if (Marker.fromShort(marker) == Marker.SOS) {
                int i;
                int index = Math.max(app0Index, exifIndex);
                for (i = 0; i <= index; ++i) {
                    ((Segment)segments.get(i)).write(os);
                }
                jpegXmp.write(os);
                for (i = index + 1; i < segments.size(); ++i) {
                    ((Segment)segments.get(i)).write(os);
                }
                IOUtils.writeShortMM(os, marker);
                JPGTweaker.copyToEnd(is, os);
                finished = true;
                continue;
            }
            Marker emarker = Marker.fromShort(marker);
            switch (emarker) {
                case JPG: 
                case JPG0: 
                case JPG13: 
                case TEM: {
                    segments.add(new Segment(emarker, 0, null));
                    marker = IOUtils.readShortMM(is);
                    continue block5;
                }
                case APP1: {
                    length = IOUtils.readUnsignedShortMM(is);
                    byte[] temp = new byte[length - 2];
                    IOUtils.readFully(is, temp);
                    if (!(temp.length >= "http://ns.adobe.com/xmp/extension/\u0000".length() && new String(temp, 0, "http://ns.adobe.com/xmp/extension/\u0000".length()).equals("http://ns.adobe.com/xmp/extension/\u0000") || temp.length >= "http://ns.adobe.com/xap/1.0/\u0000".length() && new String(temp, 0, "http://ns.adobe.com/xap/1.0/\u0000".length()).equals("http://ns.adobe.com/xap/1.0/\u0000"))) {
                        segments.add(new Segment(emarker, length, temp));
                        if (temp.length >= "Exif\u0000\u0000".length() && new String(temp, 0, "Exif\u0000\u0000".length()).equals("Exif\u0000\u0000")) {
                            exifIndex = segments.size() - 1;
                        }
                    }
                    marker = IOUtils.readShortMM(is);
                    continue block5;
                }
                case APP0: {
                    app0Index = segments.size();
                }
            }
            length = IOUtils.readUnsignedShortMM(is);
            byte[] buf = new byte[length - 2];
            IOUtils.readFully(is, buf);
            if (emarker == Marker.UNKNOWN) {
                segments.add(new UnknownSegment(marker, length, buf));
            } else {
                segments.add(new Segment(emarker, length, buf));
            }
            marker = IOUtils.readShortMM(is);
        }
    }

    public static void insertXMP(InputStream is, OutputStream os, String xmp, String extendedXmp) throws IOException {
        JPGTweaker.insertXMP(is, os, new JpegXMP(xmp, extendedXmp));
    }

    private static String hTablesToString(List<HTable> hTables) {
        String[] HT_class_table = new String[]{"DC Component", "AC Component"};
        StringBuilder hufTable = new StringBuilder();
        hufTable.append("Huffman table information =>:\n");
        for (HTable table : hTables) {
            hufTable.append("Class: " + table.getClazz() + " (" + HT_class_table[table.getClazz()] + ")\n");
            hufTable.append("Huffman table #: " + table.getID() + "\n");
            byte[] bits = table.getBits();
            byte[] values = table.getValues();
            int count = 0;
            for (int i = 0; i < bits.length; ++i) {
                count += bits[i] & 0xFF;
            }
            hufTable.append("Number of codes: " + count + "\n");
            if (count > 256) {
                throw new RuntimeException("Invalid huffman code count: " + count);
            }
            int j = 0;
            for (int i = 0; i < 16; ++i) {
                hufTable.append("Codes of length " + (i + 1) + " (" + (bits[i] & 0xFF) + " total): [ ");
                for (int k = 0; k < (bits[i] & 0xFF); ++k) {
                    hufTable.append((values[j++] & 0xFF) + " ");
                }
                hufTable.append("]\n");
            }
            hufTable.append("<= End of Huffman table information>>\n");
        }
        return hufTable.toString();
    }

    private static String qTablesToString(List<QTable> qTables) {
        StringBuilder qtTables = new StringBuilder();
        qtTables.append("Quantization table information =>:\n");
        int count = 0;
        for (QTable table : qTables) {
            int j;
            int QT_precision = table.getPrecision();
            int[] qTable = table.getData();
            qtTables.append("precision of QT is " + QT_precision + "\n");
            qtTables.append("Quantization table #" + table.getID() + ":\n");
            if (QT_precision == 0) {
                for (j = 0; j < 64; ++j) {
                    if (j != 0 && j % 8 == 0) {
                        qtTables.append("\n");
                    }
                    qtTables.append(qTable[j] + " ");
                }
            } else {
                for (j = 0; j < 64; ++j) {
                    if (j != 0 && j % 8 == 0) {
                        qtTables.append("\n");
                    }
                    qtTables.append(qTable[j] + " ");
                }
            }
            ++count;
            qtTables.append("\n");
            qtTables.append("***************************\n");
        }
        qtTables.append("Total number of Quantation tables: " + count + "\n");
        qtTables.append("End of quantization table information\n");
        return qtTables.toString();
    }

    private static String sofToString(SOFReader reader) {
        StringBuilder sof = new StringBuilder();
        sof.append("SOF information =>\n");
        sof.append("Precision: " + reader.getPrecision() + "\n");
        sof.append("Image height: " + reader.getFrameHeight() + "\n");
        sof.append("Image width: " + reader.getFrameWidth() + "\n");
        sof.append("# of Components: " + reader.getNumOfComponents() + "\n");
        sof.append("(1 = grey scaled, 3 = color YCbCr or YIQ, 4 = color CMYK)\n");
        for (Component component : reader.getComponents()) {
            sof.append("\n");
            sof.append("Component ID: " + component.getId() + "\n");
            sof.append("Herizontal sampling factor: " + component.getHSampleFactor() + "\n");
            sof.append("Vertical sampling factor: " + component.getVSampleFactor() + "\n");
            sof.append("Quantization table #: " + component.getQTableNumber() + "\n");
            sof.append("DC table number: " + component.getDCTableNumber() + "\n");
            sof.append("AC table number: " + component.getACTableNumber() + "\n");
        }
        sof.append("<= End of SOF information");
        return sof.toString();
    }

    private static void readAPP13(InputStream is, OutputStream os) throws IOException {
        int length = IOUtils.readUnsignedShortMM(is);
        byte[] temp = new byte[length - 2];
        IOUtils.readFully(is, temp);
        if (new String(temp, 0, "Photoshop 3.0\u0000".length()).equals("Photoshop 3.0\u0000")) {
            os.write(ArrayUtils.subArray(temp, "Photoshop 3.0\u0000".length(), temp.length - "Photoshop 3.0\u0000".length()));
        }
    }

    private static void readAPP2(InputStream is, OutputStream os) throws IOException {
        byte[] icc_profile_buf = new byte["ICC_PROFILE\u0000".length()];
        int length = IOUtils.readUnsignedShortMM(is);
        IOUtils.readFully(is, icc_profile_buf);
        if (Arrays.equals(icc_profile_buf, "ICC_PROFILE\u0000".getBytes())) {
            icc_profile_buf = new byte[length - "ICC_PROFILE\u0000".length() - 2];
            IOUtils.readFully(is, icc_profile_buf);
            os.write(icc_profile_buf, 2, length - "ICC_PROFILE\u0000".length() - 4);
        } else {
            IOUtils.skipFully(is, length - "ICC_PROFILE\u0000".length() - 2);
        }
    }

    private static void readDHT(InputStream is, List<HTable> m_acTables, List<HTable> m_dcTables) throws IOException {
        int len = IOUtils.readUnsignedShortMM(is);
        byte[] buf = new byte[len - 2];
        IOUtils.readFully(is, buf);
        DHTReader reader = new DHTReader(new Segment(Marker.DHT, len, buf));
        List<HTable> dcTables = reader.getDCTables();
        List<HTable> acTables = reader.getACTables();
        m_acTables.addAll(acTables);
        m_dcTables.addAll(dcTables);
    }

    private static void readDQT(InputStream is, List<QTable> m_qTables) throws IOException {
        int len = IOUtils.readUnsignedShortMM(is);
        byte[] buf = new byte[len - 2];
        IOUtils.readFully(is, buf);
        DQTReader reader = new DQTReader(new Segment(Marker.DQT, len, buf));
        List<QTable> qTables = reader.getTables();
        m_qTables.addAll(qTables);
    }

    public static Map<MetadataType, Metadata> readMetadata(InputStream is) throws IOException {
        HashMap<MetadataType, Metadata> metadataMap = new HashMap<MetadataType, Metadata>();
        if (!(is instanceof BufferedInputStream)) {
            is = new BufferedInputStream(is);
        }
        ArrayList<QTable> m_qTables = new ArrayList<QTable>(4);
        ArrayList<HTable> m_acTables = new ArrayList<HTable>(4);
        ArrayList<HTable> m_dcTables = new ArrayList<HTable>(4);
        ArrayList<SOFReader> readers = new ArrayList<SOFReader>();
        Comments comments = null;
        ArrayList<Segment> appnSegments = new ArrayList<Segment>();
        boolean finished = false;
        int length = 0;
        if (Marker.fromShort(IOUtils.readShortMM(is)) != Marker.SOI) {
            throw new IllegalArgumentException("Invalid JPEG image, expected SOI marker not found!");
        }
        short marker = IOUtils.readShortMM(is);
        block10: while (!finished) {
            if (Marker.fromShort(marker) == Marker.EOI) {
                finished = true;
                continue;
            }
            Marker emarker = Marker.fromShort(marker);
            switch (emarker) {
                case APP2: 
                case APP0: 
                case APP1: 
                case APP13: 
                case APP3: 
                case APP4: 
                case APP5: 
                case APP6: 
                case APP7: 
                case APP8: 
                case APP9: 
                case APP10: 
                case APP11: 
                case APP12: 
                case APP14: 
                case APP15: {
                    byte[] appBytes = JPGTweaker.readSegmentData(is);
                    appnSegments.add(new Segment(emarker, appBytes.length + 2, appBytes));
                    marker = IOUtils.readShortMM(is);
                    continue block10;
                }
                case COM: {
                    if (comments == null) {
                        comments = new Comments();
                    }
                    comments.addComment(JPGTweaker.readSegmentData(is));
                    marker = IOUtils.readShortMM(is);
                    continue block10;
                }
                case DHT: {
                    JPGTweaker.readDHT(is, m_acTables, m_dcTables);
                    marker = IOUtils.readShortMM(is);
                    continue block10;
                }
                case DQT: {
                    JPGTweaker.readDQT(is, m_qTables);
                    marker = IOUtils.readShortMM(is);
                    continue block10;
                }
                case SOF0: 
                case SOF1: 
                case SOF2: 
                case SOF3: 
                case SOF5: 
                case SOF6: 
                case SOF7: 
                case SOF9: 
                case SOF10: 
                case SOF11: 
                case SOF13: 
                case SOF14: 
                case SOF15: {
                    readers.add(JPGTweaker.readSOF(is, emarker));
                    marker = IOUtils.readShortMM(is);
                    continue block10;
                }
                case SOS: {
                    SOFReader reader = (SOFReader)readers.get(readers.size() - 1);
                    marker = JPGTweaker.readSOS(is, reader);
                    LOGGER.debug("\n{}", (Object)JPGTweaker.sofToString(reader));
                    continue block10;
                }
                case JPG: 
                case JPG0: 
                case JPG13: 
                case TEM: {
                    marker = IOUtils.readShortMM(is);
                    continue block10;
                }
                case PADDING: {
                    int nextByte = 0;
                    while ((nextByte = IOUtils.read(is)) == 255) {
                    }
                    marker = (short)(0xFF00 | nextByte);
                    continue block10;
                }
            }
            length = IOUtils.readUnsignedShortMM(is);
            IOUtils.skipFully(is, length - 2);
            marker = IOUtils.readShortMM(is);
        }
        is.close();
        LOGGER.debug("\n{}", (Object)JPGTweaker.qTablesToString(m_qTables));
        LOGGER.debug("\n{}", (Object)JPGTweaker.hTablesToString(m_acTables));
        LOGGER.debug("\n{}", (Object)JPGTweaker.hTablesToString(m_dcTables));
        JPGTweaker.extractMetadataFromAPPn(appnSegments, metadataMap);
        if (comments != null) {
            metadataMap.put(MetadataType.COMMENT, comments);
        }
        return metadataMap;
    }

    private static byte[] readSegmentData(InputStream is) throws IOException {
        int length = IOUtils.readUnsignedShortMM(is);
        byte[] data = new byte[length - 2];
        IOUtils.readFully(is, data);
        return data;
    }

    private static SOFReader readSOF(InputStream is, Marker marker) throws IOException {
        int len = IOUtils.readUnsignedShortMM(is);
        byte[] buf = new byte[len - 2];
        IOUtils.readFully(is, buf);
        Segment segment = new Segment(marker, len, buf);
        SOFReader reader = new SOFReader(segment);
        return reader;
    }

    private static short readSOS(InputStream is, SOFReader sofReader) throws IOException {
        int len = IOUtils.readUnsignedShortMM(is);
        byte[] buf = new byte[len - 2];
        IOUtils.readFully(is, buf);
        Segment segment = new Segment(Marker.SOS, len, buf);
        new SOSReader(segment, sofReader);
        int nextByte = 0;
        short marker = 0;
        block3: while ((nextByte = IOUtils.read(is)) != -1) {
            if (nextByte != 255) continue;
            nextByte = IOUtils.read(is);
            if (nextByte == -1) {
                return Marker.EOI.getValue();
            }
            if (nextByte == 0) continue;
            marker = (short)(0xFF00 | nextByte);
            switch (Marker.fromShort(marker)) {
                case RST0: 
                case RST1: 
                case RST2: 
                case RST3: 
                case RST4: 
                case RST5: 
                case RST6: 
                case RST7: {
                    continue block3;
                }
            }
        }
        if (nextByte == -1) {
            return Marker.EOI.getValue();
        }
        if (Marker.fromShort(marker) == Marker.UNKNOWN) {
            return Marker.EOI.getValue();
        }
        return marker;
    }

    public static void removeAPPn(Marker APPn, InputStream is, OutputStream os) throws IOException {
        if (APPn.getValue() < -32 || APPn.getValue() > -17) {
            throw new IllegalArgumentException("Input marker is not an APPn marker");
        }
        boolean finished = false;
        int length = 0;
        if (Marker.fromShort(IOUtils.readShortMM(is)) != Marker.SOI) {
            throw new IOException("Invalid JPEG image, expected SOI marker not found!");
        }
        IOUtils.writeShortMM(os, Marker.SOI.getValue());
        short marker = IOUtils.readShortMM(is);
        block5: while (!finished) {
            if (Marker.fromShort(marker) == Marker.EOI) {
                IOUtils.writeShortMM(os, Marker.EOI.getValue());
                finished = true;
                continue;
            }
            Marker emarker = Marker.fromShort(marker);
            switch (emarker) {
                case JPG: 
                case JPG0: 
                case JPG13: 
                case TEM: {
                    IOUtils.writeShortMM(os, marker);
                    marker = IOUtils.readShortMM(is);
                    continue block5;
                }
                case PADDING: {
                    IOUtils.writeShortMM(os, marker);
                    int nextByte = 0;
                    while ((nextByte = IOUtils.read(is)) == 255) {
                        IOUtils.write(os, nextByte);
                    }
                    marker = (short)(0xFF00 | nextByte);
                    continue block5;
                }
                case SOS: {
                    IOUtils.writeShortMM(os, marker);
                    JPGTweaker.copyToEnd(is, os);
                    finished = true;
                    continue block5;
                }
            }
            length = IOUtils.readUnsignedShortMM(is);
            byte[] buf = new byte[length - 2];
            IOUtils.readFully(is, buf);
            if (emarker != APPn) {
                IOUtils.writeShortMM(os, marker);
                IOUtils.writeShortMM(os, (short)length);
                IOUtils.write(os, buf);
            }
            marker = IOUtils.readShortMM(is);
        }
    }

    public static Map<MetadataType, Metadata> removeMetadata(InputStream is, OutputStream os, MetadataType ... metadataTypes) throws IOException {
        return JPGTweaker.removeMetadata(new HashSet<MetadataType>(Arrays.asList(metadataTypes)), is, os);
    }

    public static Map<MetadataType, Metadata> removeMetadata(Set<MetadataType> metadataTypes, InputStream is, OutputStream os) throws IOException {
        Metadata meta;
        HashMap<MetadataType, Metadata> metadataMap = new HashMap<MetadataType, Metadata>();
        HashMap<MetadataType, Metadata> extraMetadataMap = new HashMap<MetadataType, Metadata>();
        Comments comments = null;
        ArrayList<Segment> appnSegments = new ArrayList<Segment>();
        boolean finished = false;
        int length = 0;
        if (Marker.fromShort(IOUtils.readShortMM(is)) != Marker.SOI) {
            throw new IOException("Invalid JPEG image, expected SOI marker not found!");
        }
        IOUtils.writeShortMM(os, Marker.SOI.getValue());
        short marker = IOUtils.readShortMM(is);
        block12: while (!finished) {
            if (Marker.fromShort(marker) == Marker.EOI) {
                IOUtils.writeShortMM(os, Marker.EOI.getValue());
                finished = true;
                continue;
            }
            Marker emarker = Marker.fromShort(marker);
            switch (emarker) {
                case JPG: 
                case JPG0: 
                case JPG13: 
                case TEM: {
                    IOUtils.writeShortMM(os, marker);
                    marker = IOUtils.readShortMM(is);
                    continue block12;
                }
                case PADDING: {
                    IOUtils.writeShortMM(os, marker);
                    int nextByte = 0;
                    while ((nextByte = IOUtils.read(is)) == 255) {
                        IOUtils.write(os, nextByte);
                    }
                    marker = (short)(0xFF00 | nextByte);
                    continue block12;
                }
                case SOS: {
                    IOUtils.writeShortMM(os, marker);
                    JPGTweaker.copyToEnd(is, os);
                    finished = true;
                    continue block12;
                }
                case COM: {
                    if (metadataTypes.contains((Object)MetadataType.COMMENT)) {
                        if (comments == null) {
                            comments = new Comments();
                        }
                        comments.addComment(JPGTweaker.readSegmentData(is));
                        marker = IOUtils.readShortMM(is);
                        continue block12;
                    }
                    marker = JPGTweaker.copySegment(marker, is, os);
                    continue block12;
                }
                case APP0: {
                    byte[] temp;
                    if (metadataTypes.contains((Object)MetadataType.JPG_JFIF)) {
                        length = IOUtils.readUnsignedShortMM(is);
                        temp = new byte[length - 2];
                        IOUtils.readFully(is, temp);
                        if (temp.length < "JFIF\u0000".length() || !"JFIF\u0000".equals(new String(temp, 0, "JFIF\u0000".length()))) {
                            IOUtils.writeShortMM(os, marker);
                            IOUtils.writeShortMM(os, (short)length);
                            IOUtils.write(os, temp);
                        } else {
                            appnSegments.add(new Segment(emarker, length, temp));
                        }
                        marker = IOUtils.readShortMM(is);
                        continue block12;
                    }
                    marker = JPGTweaker.copySegment(marker, is, os);
                    continue block12;
                }
                case APP1: {
                    byte[] temp;
                    if (metadataTypes.contains((Object)MetadataType.EXIF) || metadataTypes.contains((Object)MetadataType.XMP)) {
                        length = IOUtils.readUnsignedShortMM(is);
                        temp = new byte[length - 2];
                        IOUtils.readFully(is, temp);
                        if (metadataTypes.contains((Object)MetadataType.XMP) && temp.length >= "http://ns.adobe.com/xmp/extension/\u0000".length() && new String(temp, 0, "http://ns.adobe.com/xmp/extension/\u0000".length()).equals("http://ns.adobe.com/xmp/extension/\u0000") || metadataTypes.contains((Object)MetadataType.XMP) && temp.length >= "http://ns.adobe.com/xap/1.0/\u0000".length() && new String(temp, 0, "http://ns.adobe.com/xap/1.0/\u0000".length()).equals("http://ns.adobe.com/xap/1.0/\u0000") || metadataTypes.contains((Object)MetadataType.XMP) && temp.length >= "XMP\u0000://ns.adobe.com/xap/1.0/\u0000".length() && new String(temp, 0, "XMP\u0000://ns.adobe.com/xap/1.0/\u0000".length()).equals("XMP\u0000://ns.adobe.com/xap/1.0/\u0000") || metadataTypes.contains((Object)MetadataType.EXIF) && temp.length >= "Exif\u0000\u0000".length() && new String(temp, 0, "Exif\u0000\u0000".length()).equals("Exif\u0000\u0000")) {
                            appnSegments.add(new Segment(emarker, length, temp));
                        } else {
                            IOUtils.writeShortMM(os, marker);
                            IOUtils.writeShortMM(os, (short)length);
                            IOUtils.write(os, temp);
                        }
                        marker = IOUtils.readShortMM(is);
                        continue block12;
                    }
                    marker = JPGTweaker.copySegment(marker, is, os);
                    continue block12;
                }
                case APP2: {
                    byte[] temp;
                    if (metadataTypes.contains((Object)MetadataType.ICC_PROFILE)) {
                        length = IOUtils.readUnsignedShortMM(is);
                        temp = new byte[length - 2];
                        IOUtils.readFully(is, temp);
                        if (temp.length < "ICC_PROFILE\u0000".length() || !"ICC_PROFILE\u0000".equals(new String(temp, 0, "ICC_PROFILE\u0000".length()))) {
                            IOUtils.writeShortMM(os, marker);
                            IOUtils.writeShortMM(os, (short)length);
                            IOUtils.write(os, temp);
                        } else {
                            appnSegments.add(new Segment(emarker, length, temp));
                        }
                        marker = IOUtils.readShortMM(is);
                        continue block12;
                    }
                    marker = JPGTweaker.copySegment(marker, is, os);
                    continue block12;
                }
                case APP12: {
                    byte[] temp;
                    if (metadataTypes.contains((Object)MetadataType.JPG_DUCKY)) {
                        length = IOUtils.readUnsignedShortMM(is);
                        temp = new byte[length - 2];
                        IOUtils.readFully(is, temp);
                        if (temp.length < "Ducky".length() || !"Ducky".equals(new String(temp, 0, "Ducky".length()))) {
                            IOUtils.writeShortMM(os, marker);
                            IOUtils.writeShortMM(os, (short)length);
                            IOUtils.write(os, temp);
                        } else {
                            appnSegments.add(new Segment(emarker, length, temp));
                        }
                        marker = IOUtils.readShortMM(is);
                        continue block12;
                    }
                    marker = JPGTweaker.copySegment(marker, is, os);
                    continue block12;
                }
                case APP13: {
                    byte[] temp;
                    if (metadataTypes.contains((Object)MetadataType.PHOTOSHOP_IRB) || metadataTypes.contains((Object)MetadataType.IPTC) || metadataTypes.contains((Object)MetadataType.XMP) || metadataTypes.contains((Object)MetadataType.EXIF)) {
                        length = IOUtils.readUnsignedShortMM(is);
                        temp = new byte[length - 2];
                        IOUtils.readFully(is, temp);
                        if (temp.length >= "Photoshop 3.0\u0000".length() && new String(temp, 0, "Photoshop 3.0\u0000".length()).equals("Photoshop 3.0\u0000")) {
                            IRB irb = new IRB(ArrayUtils.subArray(temp, "Photoshop 3.0\u0000".length(), temp.length - "Photoshop 3.0\u0000".length()));
                            HashMap<Short, _8BIM> bimMap = new HashMap<Short, _8BIM>(irb.get8BIM());
                            if (!metadataTypes.contains((Object)MetadataType.PHOTOSHOP_IRB)) {
                                _8BIM bim;
                                if (metadataTypes.contains((Object)MetadataType.IPTC) && (bim = (_8BIM)bimMap.remove(ImageResourceID.IPTC_NAA.getValue())) != null) {
                                    extraMetadataMap.put(MetadataType.IPTC, new IPTC(bim.getData()));
                                }
                                if (metadataTypes.contains((Object)MetadataType.XMP) && (bim = (_8BIM)bimMap.remove(ImageResourceID.XMP_METADATA.getValue())) != null) {
                                    extraMetadataMap.put(MetadataType.XMP, new JpegXMP(bim.getData()));
                                }
                                if (metadataTypes.contains((Object)MetadataType.EXIF)) {
                                    bim = (_8BIM)bimMap.remove(ImageResourceID.EXIF_DATA1.getValue());
                                    if (bim != null) {
                                        extraMetadataMap.put(MetadataType.EXIF, new JpegExif(bim.getData()));
                                    }
                                    bimMap.remove(ImageResourceID.EXIF_DATA3.getValue());
                                }
                                JPGTweaker.writeIRB(os, bimMap.values());
                            } else {
                                appnSegments.add(new Segment(emarker, length, temp));
                            }
                        } else {
                            IOUtils.writeShortMM(os, marker);
                            IOUtils.writeShortMM(os, (short)length);
                            IOUtils.write(os, temp);
                        }
                        marker = IOUtils.readShortMM(is);
                        continue block12;
                    }
                    marker = JPGTweaker.copySegment(marker, is, os);
                    continue block12;
                }
                case APP14: {
                    byte[] temp;
                    if (metadataTypes.contains((Object)MetadataType.JPG_ADOBE)) {
                        length = IOUtils.readUnsignedShortMM(is);
                        temp = new byte[length - 2];
                        IOUtils.readFully(is, temp);
                        if (temp.length < "Adobe".length() || !"Adobe".equals(new String(temp, 0, "Adobe".length()))) {
                            IOUtils.writeShortMM(os, marker);
                            IOUtils.writeShortMM(os, (short)length);
                            IOUtils.write(os, temp);
                        } else {
                            appnSegments.add(new Segment(emarker, length, temp));
                        }
                        marker = IOUtils.readShortMM(is);
                        continue block12;
                    }
                    marker = JPGTweaker.copySegment(marker, is, os);
                    continue block12;
                }
            }
            marker = JPGTweaker.copySegment(marker, is, os);
        }
        JPGTweaker.extractMetadataFromAPPn(appnSegments, metadataMap);
        if (metadataTypes.contains((Object)MetadataType.IPTC) && metadataMap.get((Object)MetadataType.IPTC) == null && (meta = (Metadata)extraMetadataMap.get((Object)MetadataType.IPTC)) != null) {
            metadataMap.put(MetadataType.IPTC, meta);
        }
        if (metadataTypes.contains((Object)MetadataType.XMP) && metadataMap.get((Object)MetadataType.XMP) == null && (meta = (Metadata)extraMetadataMap.get((Object)MetadataType.XMP)) != null) {
            metadataMap.put(MetadataType.XMP, meta);
        }
        if (metadataTypes.contains((Object)MetadataType.EXIF) && metadataMap.get((Object)MetadataType.EXIF) == null && (meta = (Metadata)extraMetadataMap.get((Object)MetadataType.EXIF)) != null) {
            metadataMap.put(MetadataType.EXIF, meta);
        }
        if (comments != null) {
            metadataMap.put(MetadataType.COMMENT, comments);
        }
        return metadataMap;
    }

    private static short skipSOS(InputStream is) throws IOException {
        int nextByte = 0;
        short marker = 0;
        block3: while ((nextByte = IOUtils.read(is)) != -1) {
            if (nextByte != 255) continue;
            nextByte = IOUtils.read(is);
            if (nextByte == -1) {
                throw new IOException("Premature end of SOS segment!");
            }
            if (nextByte == 0) continue;
            marker = (short)(0xFF00 | nextByte);
            switch (Marker.fromShort(marker)) {
                case RST0: 
                case RST1: 
                case RST2: 
                case RST3: 
                case RST4: 
                case RST5: 
                case RST6: 
                case RST7: {
                    continue block3;
                }
            }
        }
        if (nextByte == -1) {
            throw new IOException("Premature end of SOS segment!");
        }
        return marker;
    }

    private static void writeComment(String comment, OutputStream os) throws IOException {
        new COMBuilder().comment(comment).build().write(os);
    }

    private static void writeICCProfile(OutputStream os, byte[] data) throws IOException {
        int maxSegmentLen = 65535;
        int maxICCDataLen = 65519;
        int numOfSegment = data.length / maxICCDataLen;
        int leftOver = data.length % maxICCDataLen;
        int totalSegment = numOfSegment == 0 ? 1 : (leftOver == 0 ? numOfSegment : numOfSegment + 1);
        for (int i = 0; i < numOfSegment; ++i) {
            IOUtils.writeShortMM(os, Marker.APP2.getValue());
            IOUtils.writeShortMM(os, maxSegmentLen);
            IOUtils.write(os, "ICC_PROFILE\u0000".getBytes());
            IOUtils.writeShortMM(os, totalSegment | i + 1 << 8);
            IOUtils.write(os, data, i * maxICCDataLen, maxICCDataLen);
        }
        if (leftOver != 0) {
            IOUtils.writeShortMM(os, Marker.APP2.getValue());
            IOUtils.writeShortMM(os, leftOver + 16);
            IOUtils.write(os, "ICC_PROFILE\u0000".getBytes());
            IOUtils.writeShortMM(os, totalSegment | totalSegment << 8);
            IOUtils.write(os, data, data.length - leftOver, leftOver);
        }
    }

    private static void writeIRB(OutputStream os, _8BIM ... bims) throws IOException {
        if (bims != null && bims.length > 0) {
            JPGTweaker.writeIRB(os, Arrays.asList(bims));
        }
    }

    private static void writeIRB(OutputStream os, Collection<_8BIM> bims) throws IOException {
        if (bims != null && bims.size() > 0) {
            IOUtils.writeShortMM(os, Marker.APP13.getValue());
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            for (_8BIM bim : bims) {
                bim.write(bout);
            }
            IOUtils.writeShortMM(os, 16 + bout.size());
            os.write("Photoshop 3.0\u0000".getBytes());
            os.write(bout.toByteArray());
        }
    }

    private JPGTweaker() {
    }
}

