/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.jpeg;

import guilibshadow.cafe4j.image.jpeg.Component;
import guilibshadow.cafe4j.image.jpeg.Marker;
import guilibshadow.cafe4j.image.jpeg.Segment;
import guilibshadow.cafe4j.io.IOUtils;
import guilibshadow.cafe4j.util.Reader;
import java.io.IOException;
import java.util.EnumSet;

public class SOFReader
implements Reader {
    private int precision;
    private int frameHeight;
    private int frameWidth;
    private int numOfComponents;
    private Component[] components;
    private static final EnumSet<Marker> SOFS = EnumSet.of(Marker.SOF0, new Marker[]{Marker.SOF1, Marker.SOF2, Marker.SOF3, Marker.SOF5, Marker.SOF6, Marker.SOF7, Marker.SOF9, Marker.SOF10, Marker.SOF11, Marker.SOF13, Marker.SOF14, Marker.SOF15});
    private Segment segment;

    public SOFReader(Segment segment) throws IOException {
        if (!SOFS.contains((Object)segment.getMarker())) {
            throw new IllegalArgumentException("Not a valid SOF segment: " + (Object)((Object)segment.getMarker()));
        }
        this.segment = segment;
        this.read();
    }

    public int getLength() {
        return this.segment.getLength();
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getFrameHeight() {
        return this.frameHeight;
    }

    public int getFrameWidth() {
        return this.frameWidth;
    }

    public int getNumOfComponents() {
        return this.numOfComponents;
    }

    public Component[] getComponents() {
        return (Component[])this.components.clone();
    }

    @Override
    public void read() throws IOException {
        byte[] data = this.segment.getData();
        this.precision = data[0];
        this.frameHeight = IOUtils.readUnsignedShortMM(data, 1);
        this.frameWidth = IOUtils.readUnsignedShortMM(data, 3);
        this.numOfComponents = data[5];
        this.components = new Component[this.numOfComponents];
        int offset = 6;
        for (int i = 0; i < this.numOfComponents; ++i) {
            byte componentId = data[offset++];
            byte sampleFactor = data[offset++];
            byte hSampleFactor = (byte)(sampleFactor >> 4 & 0xF);
            byte vSampleFactor = (byte)(sampleFactor & 0xF);
            byte qTableNumber = data[offset++];
            this.components[i] = new Component(componentId, hSampleFactor, vSampleFactor, qTableNumber);
        }
    }
}

