/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.jpeg;

import guilibshadow.cafe4j.image.jpeg.Component;
import guilibshadow.cafe4j.image.jpeg.Marker;
import guilibshadow.cafe4j.image.jpeg.SOFReader;
import guilibshadow.cafe4j.image.jpeg.Segment;
import guilibshadow.cafe4j.util.Reader;
import java.io.IOException;

public class SOSReader
implements Reader {
    private Segment segment;
    private SOFReader reader;
    int Ss;
    int Se;
    int Ah_Al;
    int Ah;
    int Al;

    public SOSReader(Segment segment) throws IOException {
        if (segment.getMarker() != Marker.SOS) {
            throw new IllegalArgumentException("Not a valid SOS segment!");
        }
        this.segment = segment;
        this.read();
    }

    public SOSReader(Segment segment, SOFReader reader) throws IOException {
        if (segment.getMarker() != Marker.SOS) {
            throw new IllegalArgumentException("Not a valid SOS segment!");
        }
        this.segment = segment;
        this.reader = reader;
        this.read();
    }

    @Override
    public void read() throws IOException {
        byte[] data = this.segment.getData();
        int count = 0;
        int numOfComponents = data[count++];
        Component[] components = this.reader.getComponents();
        block0: for (int i = 0; i < numOfComponents; ++i) {
            byte id = data[count++];
            byte tbl_no = data[count++];
            for (Component component : components) {
                if (component.getId() != id) continue;
                component.setACTableNumber((byte)(tbl_no & 0xF));
                component.setDCTableNumber((byte)(tbl_no >> 4 & 0xF));
                continue block0;
            }
        }
        this.Ss = data[count++];
        this.Se = data[count++];
        this.Ah_Al = data[count++];
        this.Ah = this.Ah_Al >> 4 & 0xF;
        this.Al = this.Ah_Al & 0xF;
    }

    public void setSOFReader(SOFReader reader) {
        this.reader = reader;
    }
}

