/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.meta;

import guilibshadow.cafe4j.image.ImageType;
import guilibshadow.cafe4j.image.bmp.BMPTweaker;
import guilibshadow.cafe4j.image.gif.GIFTweaker;
import guilibshadow.cafe4j.image.jpeg.JPGTweaker;
import guilibshadow.cafe4j.image.meta.MetadataEntry;
import guilibshadow.cafe4j.image.meta.MetadataReader;
import guilibshadow.cafe4j.image.meta.MetadataType;
import guilibshadow.cafe4j.image.meta.adobe._8BIM;
import guilibshadow.cafe4j.image.meta.exif.Exif;
import guilibshadow.cafe4j.image.meta.iptc.IPTCDataSet;
import guilibshadow.cafe4j.image.meta.xmp.XMP;
import guilibshadow.cafe4j.image.png.PNGTweaker;
import guilibshadow.cafe4j.image.tiff.TIFFTweaker;
import guilibshadow.cafe4j.image.util.IMGUtils;
import guilibshadow.cafe4j.io.FileCacheRandomAccessInputStream;
import guilibshadow.cafe4j.io.FileCacheRandomAccessOutputStream;
import guilibshadow.cafe4j.io.PeekHeadInputStream;
import guilibshadow.cafe4j.io.RandomAccessInputStream;
import guilibshadow.cafe4j.io.RandomAccessOutputStream;
import guilibshadow.org.slf4j.Logger;
import guilibshadow.org.slf4j.LoggerFactory;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class Metadata
implements MetadataReader,
Iterable<MetadataEntry> {
    public static final int IMAGE_MAGIC_NUMBER_LEN = 4;
    private MetadataType type;
    protected byte[] data;
    protected boolean isDataRead;
    private static final Logger LOGGER = LoggerFactory.getLogger(Metadata.class);

    public static BufferedImage extractThumbnail(File image) throws IOException {
        FileInputStream fin = new FileInputStream(image);
        BufferedImage thumbnail = Metadata.extractThumbnail(fin);
        fin.close();
        return thumbnail;
    }

    public static BufferedImage extractThumbnail(InputStream is) throws IOException {
        Collection<BufferedImage> thumbnails = Metadata.extractThumbnails(is);
        if (thumbnails.size() > 0) {
            return thumbnails.iterator().next();
        }
        return null;
    }

    public static Collection<BufferedImage> extractThumbnails(File image) throws IOException {
        FileInputStream fin = new FileInputStream(image);
        Collection<BufferedImage> thumbnails = Metadata.extractThumbnails(fin);
        fin.close();
        return thumbnails;
    }

    public static Collection<BufferedImage> extractThumbnails(InputStream is) throws IOException {
        PeekHeadInputStream peekHeadInputStream = new PeekHeadInputStream(is, 4);
        ImageType imageType = IMGUtils.guessImageType(peekHeadInputStream);
        Collection<Object> thumbnails = Collections.emptyList();
        switch (imageType) {
            case JPG: {
                thumbnails = JPGTweaker.extractThumbnails(peekHeadInputStream);
                break;
            }
            case TIFF: {
                FileCacheRandomAccessInputStream randIS = new FileCacheRandomAccessInputStream(peekHeadInputStream);
                thumbnails = TIFFTweaker.extractThumbnails(randIS);
                ((RandomAccessInputStream)randIS).shallowClose();
                break;
            }
            case PNG: {
                LOGGER.info("PNG image format does not contain any thumbnail");
                break;
            }
            case GIF: 
            case PCX: 
            case TGA: 
            case BMP: {
                LOGGER.info("{} image format does not contain any thumbnails", (Object)imageType);
                break;
            }
            default: {
                peekHeadInputStream.close();
                throw new IllegalArgumentException("Thumbnail extracting is not supported for " + (Object)((Object)imageType) + " image");
            }
        }
        peekHeadInputStream.shallowClose();
        return thumbnails;
    }

    public static void extractThumbnails(File image, String pathToThumbnail) throws IOException {
        FileInputStream fin = new FileInputStream(image);
        Metadata.extractThumbnails(fin, pathToThumbnail);
        fin.close();
    }

    public static void extractThumbnails(InputStream is, String pathToThumbnail) throws IOException {
        PeekHeadInputStream peekHeadInputStream = new PeekHeadInputStream(is, 4);
        ImageType imageType = IMGUtils.guessImageType(peekHeadInputStream);
        switch (imageType) {
            case JPG: {
                JPGTweaker.extractThumbnails(peekHeadInputStream, pathToThumbnail);
                break;
            }
            case TIFF: {
                FileCacheRandomAccessInputStream randIS = new FileCacheRandomAccessInputStream(peekHeadInputStream);
                TIFFTweaker.extractThumbnail(randIS, pathToThumbnail);
                ((RandomAccessInputStream)randIS).shallowClose();
                break;
            }
            case PNG: {
                LOGGER.info("PNG image format does not contain any thumbnail");
                break;
            }
            case GIF: 
            case PCX: 
            case TGA: 
            case BMP: {
                LOGGER.info("{} image format does not contain any thumbnails", (Object)imageType);
                break;
            }
            default: {
                peekHeadInputStream.close();
                throw new IllegalArgumentException("Thumbnail extracting is not supported for " + (Object)((Object)imageType) + " image");
            }
        }
        peekHeadInputStream.shallowClose();
    }

    public static void extractThumbnails(String image, String pathToThumbnail) throws IOException {
        Metadata.extractThumbnails(new File(image), pathToThumbnail);
    }

    public static void insertComment(InputStream is, OutputStream os, String comment) throws IOException {
        Metadata.insertComments(is, os, Arrays.asList(comment));
    }

    public static void insertComments(InputStream is, OutputStream os, List<String> comments) throws IOException {
        PeekHeadInputStream peekHeadInputStream = new PeekHeadInputStream(is, 4);
        ImageType imageType = IMGUtils.guessImageType(peekHeadInputStream);
        switch (imageType) {
            case JPG: {
                JPGTweaker.insertComments(peekHeadInputStream, os, comments);
                break;
            }
            case TIFF: {
                FileCacheRandomAccessInputStream randIS = new FileCacheRandomAccessInputStream(peekHeadInputStream);
                FileCacheRandomAccessOutputStream randOS = new FileCacheRandomAccessOutputStream(os);
                TIFFTweaker.insertComments(comments, randIS, randOS);
                ((RandomAccessInputStream)randIS).shallowClose();
                ((RandomAccessOutputStream)randOS).shallowClose();
                break;
            }
            case PNG: {
                PNGTweaker.insertComments(peekHeadInputStream, os, comments);
                break;
            }
            case GIF: {
                GIFTweaker.insertComments(peekHeadInputStream, os, comments);
                break;
            }
            case PCX: 
            case TGA: 
            case BMP: {
                LOGGER.info("{} image format does not support comment data", (Object)imageType);
                break;
            }
            default: {
                peekHeadInputStream.close();
                throw new IllegalArgumentException("comment data inserting is not supported for " + (Object)((Object)imageType) + " image");
            }
        }
        peekHeadInputStream.shallowClose();
    }

    public static void insertExif(InputStream is, OutputStream os, Exif exif) throws IOException {
        Metadata.insertExif(is, os, exif, false);
    }

    public static void insertExif(InputStream is, OutputStream os, Exif exif, boolean update) throws IOException {
        PeekHeadInputStream peekHeadInputStream = new PeekHeadInputStream(is, 4);
        ImageType imageType = IMGUtils.guessImageType(peekHeadInputStream);
        switch (imageType) {
            case JPG: {
                JPGTweaker.insertExif(peekHeadInputStream, os, exif, update);
                break;
            }
            case TIFF: {
                FileCacheRandomAccessInputStream randIS = new FileCacheRandomAccessInputStream(peekHeadInputStream);
                FileCacheRandomAccessOutputStream randOS = new FileCacheRandomAccessOutputStream(os);
                TIFFTweaker.insertExif(randIS, randOS, exif, update);
                ((RandomAccessInputStream)randIS).shallowClose();
                ((RandomAccessOutputStream)randOS).shallowClose();
                break;
            }
            case PNG: 
            case GIF: 
            case PCX: 
            case TGA: 
            case BMP: {
                LOGGER.info("{} image format does not support EXIF data", (Object)imageType);
                break;
            }
            default: {
                peekHeadInputStream.close();
                throw new IllegalArgumentException("EXIF data inserting is not supported for " + (Object)((Object)imageType) + " image");
            }
        }
        peekHeadInputStream.shallowClose();
    }

    public static void insertICCProfile(InputStream is, OutputStream out, ICC_Profile icc_profile) throws IOException {
        Metadata.insertICCProfile(is, out, icc_profile.getData());
    }

    public static void insertICCProfile(InputStream is, OutputStream out, byte[] icc_profile) throws IOException {
        PeekHeadInputStream peekHeadInputStream = new PeekHeadInputStream(is, 4);
        ImageType imageType = IMGUtils.guessImageType(peekHeadInputStream);
        switch (imageType) {
            case JPG: {
                JPGTweaker.insertICCProfile((InputStream)peekHeadInputStream, out, icc_profile);
                break;
            }
            case TIFF: {
                FileCacheRandomAccessInputStream randIS = new FileCacheRandomAccessInputStream(peekHeadInputStream);
                FileCacheRandomAccessOutputStream randOS = new FileCacheRandomAccessOutputStream(out);
                TIFFTweaker.insertICCProfile(icc_profile, 0, (RandomAccessInputStream)randIS, (RandomAccessOutputStream)randOS);
                ((RandomAccessInputStream)randIS).shallowClose();
                ((RandomAccessOutputStream)randOS).shallowClose();
                break;
            }
            case GIF: 
            case PCX: 
            case TGA: 
            case BMP: {
                LOGGER.info("{} image format does not support ICCProfile data", (Object)imageType);
                break;
            }
            default: {
                peekHeadInputStream.close();
                throw new IllegalArgumentException("ICCProfile data inserting is not supported for " + (Object)((Object)imageType) + " image");
            }
        }
        peekHeadInputStream.shallowClose();
    }

    public static void insertIPTC(InputStream is, OutputStream out, Collection<IPTCDataSet> iptcs) throws IOException {
        Metadata.insertIPTC(is, out, iptcs, false);
    }

    public static void insertIPTC(InputStream is, OutputStream out, Collection<IPTCDataSet> iptcs, boolean update) throws IOException {
        PeekHeadInputStream peekHeadInputStream = new PeekHeadInputStream(is, 4);
        ImageType imageType = IMGUtils.guessImageType(peekHeadInputStream);
        switch (imageType) {
            case JPG: {
                JPGTweaker.insertIPTC(peekHeadInputStream, out, iptcs, update);
                break;
            }
            case TIFF: {
                FileCacheRandomAccessInputStream randIS = new FileCacheRandomAccessInputStream(peekHeadInputStream);
                FileCacheRandomAccessOutputStream randOS = new FileCacheRandomAccessOutputStream(out);
                TIFFTweaker.insertIPTC(randIS, randOS, iptcs, update);
                ((RandomAccessInputStream)randIS).shallowClose();
                ((RandomAccessOutputStream)randOS).shallowClose();
                break;
            }
            case PNG: 
            case GIF: 
            case PCX: 
            case TGA: 
            case BMP: {
                LOGGER.info("{} image format does not support IPTC data", (Object)imageType);
                break;
            }
            default: {
                peekHeadInputStream.close();
                throw new IllegalArgumentException("IPTC data inserting is not supported for " + (Object)((Object)imageType) + " image");
            }
        }
        peekHeadInputStream.shallowClose();
    }

    public static void insertIRB(InputStream is, OutputStream out, Collection<_8BIM> bims) throws IOException {
        Metadata.insertIRB(is, out, bims, false);
    }

    public static void insertIRB(InputStream is, OutputStream out, Collection<_8BIM> bims, boolean update) throws IOException {
        PeekHeadInputStream peekHeadInputStream = new PeekHeadInputStream(is, 4);
        ImageType imageType = IMGUtils.guessImageType(peekHeadInputStream);
        switch (imageType) {
            case JPG: {
                JPGTweaker.insertIRB(peekHeadInputStream, out, bims, update);
                break;
            }
            case TIFF: {
                FileCacheRandomAccessInputStream randIS = new FileCacheRandomAccessInputStream(peekHeadInputStream);
                FileCacheRandomAccessOutputStream randOS = new FileCacheRandomAccessOutputStream(out);
                TIFFTweaker.insertIRB(randIS, randOS, bims, update);
                ((RandomAccessInputStream)randIS).shallowClose();
                ((RandomAccessOutputStream)randOS).shallowClose();
                break;
            }
            case PNG: 
            case GIF: 
            case PCX: 
            case TGA: 
            case BMP: {
                LOGGER.info("{} image format does not support IRB data", (Object)imageType);
                break;
            }
            default: {
                peekHeadInputStream.close();
                throw new IllegalArgumentException("IRB data inserting is not supported for " + (Object)((Object)imageType) + " image");
            }
        }
        peekHeadInputStream.shallowClose();
    }

    public static void insertIRBThumbnail(InputStream is, OutputStream out, BufferedImage thumbnail) throws IOException {
        PeekHeadInputStream peekHeadInputStream = new PeekHeadInputStream(is, 4);
        ImageType imageType = IMGUtils.guessImageType(peekHeadInputStream);
        switch (imageType) {
            case JPG: {
                JPGTweaker.insertIRBThumbnail(peekHeadInputStream, out, thumbnail);
                break;
            }
            case TIFF: {
                FileCacheRandomAccessInputStream randIS = new FileCacheRandomAccessInputStream(peekHeadInputStream);
                FileCacheRandomAccessOutputStream randOS = new FileCacheRandomAccessOutputStream(out);
                TIFFTweaker.insertThumbnail(randIS, randOS, thumbnail);
                ((RandomAccessInputStream)randIS).shallowClose();
                ((RandomAccessOutputStream)randOS).shallowClose();
                break;
            }
            case PNG: 
            case GIF: 
            case PCX: 
            case TGA: 
            case BMP: {
                LOGGER.info("{} image format does not support IRB thumbnail", (Object)imageType);
                break;
            }
            default: {
                peekHeadInputStream.close();
                throw new IllegalArgumentException("IRB thumbnail inserting is not supported for " + (Object)((Object)imageType) + " image");
            }
        }
        peekHeadInputStream.shallowClose();
    }

    public static void insertXMP(InputStream is, OutputStream out, XMP xmp) throws IOException {
        PeekHeadInputStream peekHeadInputStream = new PeekHeadInputStream(is, 4);
        ImageType imageType = IMGUtils.guessImageType(peekHeadInputStream);
        switch (imageType) {
            case JPG: {
                JPGTweaker.insertXMP(peekHeadInputStream, out, xmp);
                break;
            }
            case TIFF: {
                FileCacheRandomAccessInputStream randIS = new FileCacheRandomAccessInputStream(peekHeadInputStream);
                FileCacheRandomAccessOutputStream randOS = new FileCacheRandomAccessOutputStream(out);
                TIFFTweaker.insertXMP(xmp, (RandomAccessInputStream)randIS, (RandomAccessOutputStream)randOS);
                ((RandomAccessInputStream)randIS).shallowClose();
                ((RandomAccessOutputStream)randOS).shallowClose();
                break;
            }
            case PNG: {
                PNGTweaker.insertXMP((InputStream)peekHeadInputStream, out, xmp);
                break;
            }
            case GIF: {
                GIFTweaker.insertXMPApplicationBlock((InputStream)peekHeadInputStream, out, xmp);
                break;
            }
            case PCX: 
            case TGA: 
            case BMP: {
                LOGGER.info("{} image format does not support XMP data", (Object)imageType);
                break;
            }
            default: {
                peekHeadInputStream.close();
                throw new IllegalArgumentException("XMP inserting is not supported for " + (Object)((Object)imageType) + " image");
            }
        }
        peekHeadInputStream.shallowClose();
    }

    public static void insertMetadata(Collection<Metadata> metadata, InputStream is, OutputStream os) throws IOException {
        PeekHeadInputStream peekHeadInputStream = new PeekHeadInputStream(is, 4);
        ImageType imageType = IMGUtils.guessImageType(peekHeadInputStream);
        switch (imageType) {
            case JPG: {
                JPGTweaker.insertMetadata(metadata, peekHeadInputStream, os);
                break;
            }
            case TIFF: {
                FileCacheRandomAccessInputStream randIS = new FileCacheRandomAccessInputStream(peekHeadInputStream);
                FileCacheRandomAccessOutputStream randOS = new FileCacheRandomAccessOutputStream(os);
                TIFFTweaker.insertMetadata(randIS, randOS, metadata);
                ((RandomAccessInputStream)randIS).shallowClose();
                ((RandomAccessOutputStream)randOS).shallowClose();
                break;
            }
            default: {
                peekHeadInputStream.close();
                throw new IllegalArgumentException("inserting more than one metadata is not supported for " + (Object)((Object)imageType) + " image");
            }
        }
        peekHeadInputStream.shallowClose();
    }

    public static void insertXMP(InputStream is, OutputStream out, String xmp) throws IOException {
        PeekHeadInputStream peekHeadInputStream = new PeekHeadInputStream(is, 4);
        ImageType imageType = IMGUtils.guessImageType(peekHeadInputStream);
        switch (imageType) {
            case JPG: {
                JPGTweaker.insertXMP(peekHeadInputStream, out, xmp, null);
                break;
            }
            case TIFF: {
                FileCacheRandomAccessInputStream randIS = new FileCacheRandomAccessInputStream(peekHeadInputStream);
                FileCacheRandomAccessOutputStream randOS = new FileCacheRandomAccessOutputStream(out);
                TIFFTweaker.insertXMP(xmp, (RandomAccessInputStream)randIS, (RandomAccessOutputStream)randOS);
                ((RandomAccessInputStream)randIS).shallowClose();
                ((RandomAccessOutputStream)randOS).shallowClose();
                break;
            }
            case PNG: {
                PNGTweaker.insertXMP((InputStream)peekHeadInputStream, out, xmp);
                break;
            }
            case GIF: {
                GIFTweaker.insertXMPApplicationBlock((InputStream)peekHeadInputStream, out, xmp);
                break;
            }
            case PCX: 
            case TGA: 
            case BMP: {
                LOGGER.info("{} image format does not support XMP data", (Object)imageType);
                break;
            }
            default: {
                peekHeadInputStream.close();
                throw new IllegalArgumentException("XMP inserting is not supported for " + (Object)((Object)imageType) + " image");
            }
        }
        peekHeadInputStream.shallowClose();
    }

    @Override
    public abstract Iterator<MetadataEntry> iterator();

    public static Map<MetadataType, Metadata> readMetadata(File image) throws IOException {
        FileInputStream fin = new FileInputStream(image);
        Map<MetadataType, Metadata> metadataMap = Metadata.readMetadata(fin);
        fin.close();
        return metadataMap;
    }

    public static Map<MetadataType, Metadata> readMetadata(InputStream is) throws IOException {
        Map<Object, Object> metadataMap = new HashMap();
        PeekHeadInputStream peekHeadInputStream = new PeekHeadInputStream(is, 4);
        ImageType imageType = IMGUtils.guessImageType(peekHeadInputStream);
        switch (imageType) {
            case JPG: {
                metadataMap = JPGTweaker.readMetadata(peekHeadInputStream);
                break;
            }
            case TIFF: {
                FileCacheRandomAccessInputStream randIS = new FileCacheRandomAccessInputStream(peekHeadInputStream);
                metadataMap = TIFFTweaker.readMetadata(randIS);
                ((RandomAccessInputStream)randIS).shallowClose();
                break;
            }
            case PNG: {
                metadataMap = PNGTweaker.readMetadata(peekHeadInputStream);
                break;
            }
            case GIF: {
                metadataMap = GIFTweaker.readMetadata(peekHeadInputStream);
                break;
            }
            case BMP: {
                metadataMap = BMPTweaker.readMetadata(peekHeadInputStream);
                break;
            }
            default: {
                peekHeadInputStream.close();
                throw new IllegalArgumentException("Metadata reading is not supported for " + (Object)((Object)imageType) + " image");
            }
        }
        peekHeadInputStream.shallowClose();
        return metadataMap;
    }

    public static Map<MetadataType, Metadata> readMetadata(String image) throws IOException {
        return Metadata.readMetadata(new File(image));
    }

    public static Map<MetadataType, Metadata> removeMetadata(InputStream is, OutputStream os, MetadataType ... metadataTypes) throws IOException {
        PeekHeadInputStream peekHeadInputStream = new PeekHeadInputStream(is, 4);
        ImageType imageType = IMGUtils.guessImageType(peekHeadInputStream);
        Map<MetadataType, Metadata> metadataMap = Collections.emptyMap();
        switch (imageType) {
            case JPG: {
                metadataMap = JPGTweaker.removeMetadata(peekHeadInputStream, os, metadataTypes);
                break;
            }
            case TIFF: {
                FileCacheRandomAccessInputStream randIS = new FileCacheRandomAccessInputStream(peekHeadInputStream);
                FileCacheRandomAccessOutputStream randOS = new FileCacheRandomAccessOutputStream(os);
                metadataMap = TIFFTweaker.removeMetadata(randIS, randOS, metadataTypes);
                ((RandomAccessInputStream)randIS).shallowClose();
                ((RandomAccessOutputStream)randOS).shallowClose();
                break;
            }
            case PCX: 
            case TGA: 
            case BMP: {
                LOGGER.info("{} image format does not support meta data", (Object)imageType);
                break;
            }
            default: {
                peekHeadInputStream.close();
                throw new UnsupportedOperationException("Metadata removing is not supported for " + (Object)((Object)imageType) + " image");
            }
        }
        peekHeadInputStream.shallowClose();
        return metadataMap;
    }

    public Metadata(MetadataType type) {
        this.type = type;
    }

    public Metadata(MetadataType type, byte[] data) {
        if (type == null) {
            throw new IllegalArgumentException("Metadata type must be specified");
        }
        if (data == null) {
            throw new IllegalArgumentException("Input data array is null");
        }
        if (data.length == 0) {
            this.isDataRead = true;
        }
        this.type = type;
        this.data = data;
    }

    @Override
    public void ensureDataRead() {
        if (!this.isDataRead) {
            try {
                this.read();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public byte[] getData() {
        if (this.data != null) {
            return (byte[])this.data.clone();
        }
        return null;
    }

    @Override
    public MetadataType getType() {
        return this.type;
    }

    @Override
    public boolean isDataRead() {
        return this.isDataRead;
    }

    public void write(OutputStream out) throws IOException {
        byte[] data = this.getData();
        if (data != null) {
            out.write(data);
        }
    }
}

