/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.meta;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public abstract class Thumbnail {
    public static final int DATA_TYPE_KRawRGB = 0;
    public static final int DATA_TYPE_KJpegRGB = 1;
    public static final int DATA_TYPE_TIFF = 2;
    protected BufferedImage thumbnail;
    protected byte[] compressedThumbnail;
    protected int writeQuality = 100;
    protected int width;
    protected int height;
    protected int dataType = 0;

    public Thumbnail() {
    }

    public Thumbnail(BufferedImage thumbnail) {
        this.setImage(thumbnail);
    }

    public Thumbnail(int width, int height, int dataType, byte[] compressedThumbnail) {
        this.setImage(width, height, dataType, compressedThumbnail);
    }

    public boolean containsImage() {
        return this.thumbnail != null || this.compressedThumbnail != null;
    }

    public BufferedImage getAsBufferedImage() {
        if (this.dataType == 1 || this.dataType == 2) {
            try {
                return ImageIO.read(new ByteArrayInputStream(this.getCompressedImage()));
            }
            catch (IOException e) {
                throw new RuntimeException("Error decoding compressed thumbnail data to BufferedImage");
            }
        }
        if (this.dataType == 0) {
            return this.getRawImage();
        }
        return null;
    }

    public byte[] getCompressedImage() {
        return this.compressedThumbnail;
    }

    public int getDataType() {
        return this.dataType;
    }

    public String getDataTypeAsString() {
        switch (this.dataType) {
            case 0: {
                return "DATA_TYPE_KRawRGB";
            }
            case 1: {
                return "DATA_TYPE_KJpegRGB";
            }
            case 2: {
                return "DATA_TYPE_TIFF";
            }
        }
        return "DATA_TYPE_Unknown";
    }

    public int getHeight() {
        return this.height;
    }

    public BufferedImage getRawImage() {
        return this.thumbnail;
    }

    public int getWidth() {
        return this.width;
    }

    public void setImage(BufferedImage thumbnail) {
        this.width = thumbnail.getWidth();
        this.height = thumbnail.getHeight();
        this.thumbnail = thumbnail;
        this.dataType = 0;
    }

    public void setImage(int width, int height, int dataType, byte[] compressedThumbnail) {
        this.width = width;
        this.height = height;
        if (dataType == 1 || dataType == 2) {
            this.compressedThumbnail = compressedThumbnail;
            this.dataType = dataType;
        }
    }

    public void setWriteQuality(int quality) {
        this.writeQuality = quality;
    }

    public abstract void write(OutputStream var1) throws IOException;
}

