/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.meta.adobe;

import java.util.HashMap;
import java.util.Map;

public enum BlendModeKey {
    pass("pass through", 1885434739),
    norm("normal", 1852797549),
    diss("dissolve", 1684632435),
    dark("darken", 1684107883),
    mul("multiply", 1836411936),
    idiv("color burn", 1768188278),
    lbrn("linear burn", 1818391150),
    dkCl("darker color", 1684751212),
    lite("lighten", 1818850405),
    scrn("screen", 1935897198),
    div("color dodge", 1684633120),
    lddg("linear dodge", 1818518631),
    lgCl("lighter color", 1818706796),
    over("overlay", 1870030194),
    sLit("soft light", 1934387572),
    hLit("hard light", 1749838196),
    vLit("vivid light", 1984719220),
    lLit("linear light", 1816947060),
    pLit("pin light", 1884055924),
    hMix("hard mix", 1749903736),
    diff("difference", 0x64696666),
    smud("exclusion", 1936553316),
    fsub("subtract", 1718842722),
    fdiv("divide", 1717856630),
    hue("hue", 1752524064),
    sat("saturation", 1935766560),
    colr("color", 1668246642),
    lum("luminosity", 1819634976),
    UNKNOWN("Unknown Blending Mode", -1);

    private static final Map<Integer, BlendModeKey> keyMap;
    private final String description;
    private final int value;

    private BlendModeKey(String description, int value) {
        this.description = description;
        this.value = value;
    }

    public String getDescription() {
        return this.description;
    }

    public int getValue() {
        return this.value;
    }

    public static BlendModeKey fromInt(int value) {
        BlendModeKey key = keyMap.get(value);
        if (key == null) {
            return UNKNOWN;
        }
        return key;
    }

    static {
        keyMap = new HashMap<Integer, BlendModeKey>();
        for (BlendModeKey key : BlendModeKey.values()) {
            keyMap.put(key.getValue(), key);
        }
    }
}

