/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.meta.adobe;

import guilibshadow.cafe4j.image.meta.Metadata;
import guilibshadow.cafe4j.image.meta.MetadataEntry;
import guilibshadow.cafe4j.image.meta.MetadataType;
import guilibshadow.cafe4j.image.meta.adobe.DDBEntry;
import guilibshadow.cafe4j.image.meta.adobe.DataBlockType;
import guilibshadow.cafe4j.image.meta.adobe.FilterMask;
import guilibshadow.cafe4j.image.meta.adobe.LayerData;
import guilibshadow.cafe4j.image.meta.adobe.UserMask;
import guilibshadow.cafe4j.io.IOUtils;
import guilibshadow.cafe4j.io.ReadStrategy;
import guilibshadow.cafe4j.util.ArrayUtils;
import guilibshadow.org.slf4j.Logger;
import guilibshadow.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DDB
extends Metadata {
    private ReadStrategy readStrategy;
    private Map<Integer, DDBEntry> entries = new HashMap<Integer, DDBEntry>();
    public static final String DDB_ID = "Adobe Photoshop Document Data Block\u0000";
    public static final int _8BIM = 943868237;
    private static final Logger LOGGER = LoggerFactory.getLogger(DDB.class);

    public static void showDDB(byte[] data, ReadStrategy readStrategy) {
        if (data != null && data.length > 0) {
            DDB ddb = new DDB(data, readStrategy);
            try {
                ddb.read();
                for (MetadataEntry item : ddb) {
                    LOGGER.info(item.getKey() + ": " + item.getValue());
                    if (!item.isMetadataEntryGroup()) continue;
                    String indent = "    ";
                    Collection<MetadataEntry> entries = item.getMetadataEntries();
                    for (MetadataEntry e : entries) {
                        LOGGER.info(indent + e.getKey() + ": " + e.getValue());
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void showDDB(InputStream is, ReadStrategy readStrategy) {
        try {
            DDB.showDDB(IOUtils.inputStreamToByteArray(is), readStrategy);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public DDB(byte[] data, ReadStrategy readStrategy) {
        super(MetadataType.PHOTOSHOP_DDB, data);
        if (readStrategy == null) {
            throw new IllegalArgumentException("Input readStategy is null");
        }
        this.readStrategy = readStrategy;
    }

    public Map<Integer, DDBEntry> getEntries() {
        return Collections.unmodifiableMap(this.entries);
    }

    @Override
    public Iterator<MetadataEntry> iterator() {
        this.ensureDataRead();
        ArrayList<MetadataEntry> entries = new ArrayList<MetadataEntry>();
        for (DDBEntry entry : this.entries.values()) {
            entries.add(entry.getMetadataEntry());
        }
        return Collections.unmodifiableCollection(entries).iterator();
    }

    @Override
    public void read() throws IOException {
        if (!this.isDataRead) {
            int i = 0;
            if (!new String(this.data, i, DDB_ID.length()).equals(DDB_ID)) {
                throw new RuntimeException("Invalid Photoshop Document Data Block");
            }
            i += DDB_ID.length();
            while (i + 4 < this.data.length) {
                int signature = this.readStrategy.readInt(this.data, i);
                i += 4;
                if (signature != 943868237) continue;
                int type = this.readStrategy.readInt(this.data, i);
                int size = this.readStrategy.readInt(this.data, i += 4);
                i += 4;
                DataBlockType etype = DataBlockType.fromInt(type);
                switch (etype) {
                    case Layr: {
                        this.entries.put(type, new LayerData(size, ArrayUtils.subArray(this.data, i, size), this.readStrategy));
                        break;
                    }
                    case LMsk: {
                        this.entries.put(type, new UserMask(size, ArrayUtils.subArray(this.data, i, size), this.readStrategy));
                        break;
                    }
                    case FMsk: {
                        this.entries.put(type, new FilterMask(size, ArrayUtils.subArray(this.data, i, size), this.readStrategy));
                        break;
                    }
                    default: {
                        this.entries.put(type, new DDBEntry(type, size, ArrayUtils.subArray(this.data, i, size), this.readStrategy));
                    }
                }
                i += size + 3 >> 2 << 2;
            }
            this.isDataRead = true;
        }
    }
}

