/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.meta.adobe;

import guilibshadow.cafe4j.image.meta.MetadataEntry;
import guilibshadow.cafe4j.image.meta.adobe.DataBlockType;
import guilibshadow.cafe4j.io.ReadStrategy;
import guilibshadow.cafe4j.string.StringUtils;

public class DDBEntry {
    private int type;
    private int size;
    protected byte[] data;
    protected ReadStrategy readStrategy;

    public DDBEntry(DataBlockType etype, int size, byte[] data, ReadStrategy readStrategy) {
        this(etype.getValue(), size, data, readStrategy);
    }

    public DDBEntry(int type, int size, byte[] data, ReadStrategy readStrategy) {
        this.type = type;
        if (size < 0) {
            throw new IllegalArgumentException("Input size is negative");
        }
        this.size = size;
        this.data = data;
        if (readStrategy == null) {
            throw new IllegalArgumentException("Input readStrategy is null");
        }
        this.readStrategy = readStrategy;
    }

    public int getType() {
        return this.type;
    }

    public DataBlockType getTypeEnum() {
        return DataBlockType.fromInt(this.type);
    }

    protected MetadataEntry getMetadataEntry() {
        DataBlockType eType = DataBlockType.fromInt(this.type);
        if (eType == DataBlockType.UNKNOWN) {
            return new MetadataEntry("UNKNOWN [" + StringUtils.intToHexStringMM(this.type) + "]:", eType.getDescription());
        }
        return new MetadataEntry("" + (Object)((Object)eType), eType.getDescription());
    }

    public int getSize() {
        return this.size;
    }

    public byte[] getData() {
        return (byte[])this.data.clone();
    }
}

