/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.meta.adobe;

import java.util.HashMap;
import java.util.Map;

public enum DataBlockType {
    Layr("Layer Data", 1281456498),
    LMsk("User Mask Same as Global layer mask info table", 1280144235),
    Patt("Pattern", 1348564084),
    FMsk("Filter Mask", 1179480939),
    Anno("Annotations", 1097756271),
    UNKNOWN("Unknown Data Block", -1);

    private static final Map<Integer, DataBlockType> typeMap;
    private final String description;
    private final int value;

    private DataBlockType(String description, int value) {
        this.description = description;
        this.value = value;
    }

    public String getDescription() {
        return this.description;
    }

    public int getValue() {
        return this.value;
    }

    public static DataBlockType fromInt(int value) {
        DataBlockType type = typeMap.get(value);
        if (type == null) {
            return UNKNOWN;
        }
        return type;
    }

    static {
        typeMap = new HashMap<Integer, DataBlockType>();
        for (DataBlockType type : DataBlockType.values()) {
            typeMap.put(type.getValue(), type);
        }
    }
}

