/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.meta.adobe;

import guilibshadow.cafe4j.image.meta.MetadataEntry;
import guilibshadow.cafe4j.image.meta.adobe.ImageResourceID;
import guilibshadow.cafe4j.image.meta.adobe._8BIM;
import guilibshadow.cafe4j.image.meta.iptc.IPTC;
import guilibshadow.cafe4j.image.meta.iptc.IPTCDataSet;
import guilibshadow.cafe4j.image.meta.iptc.IPTCTag;
import guilibshadow.cafe4j.string.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IPTC_NAA
extends _8BIM {
    private IPTC iptc;

    public IPTC_NAA() {
        this("IPTC_NAA");
    }

    public IPTC_NAA(String name) {
        super(ImageResourceID.IPTC_NAA, name, null);
        this.iptc = new IPTC();
    }

    public IPTC_NAA(String name, byte[] data) {
        super(ImageResourceID.IPTC_NAA, name, data);
        this.iptc = new IPTC(data);
    }

    public void addDataSet(IPTCDataSet dataSet) {
        this.iptc.addDataSet(dataSet);
    }

    public void addDataSets(Collection<? extends IPTCDataSet> dataSets) {
        this.iptc.addDataSets(dataSets);
    }

    public Map<IPTCTag, List<IPTCDataSet>> getDataSets() {
        return this.iptc.getDataSets();
    }

    public List<IPTCDataSet> getDataSet(IPTCTag key) {
        return this.iptc.getDataSet(key);
    }

    @Override
    protected MetadataEntry getMetadataEntry() {
        ImageResourceID eId = ImageResourceID.fromShort(this.getID());
        MetadataEntry entry = new MetadataEntry(eId.name(), eId.getDescription(), true);
        Map<IPTCTag, List<IPTCDataSet>> datasetMap = this.getDataSets();
        if (datasetMap != null) {
            Set<Map.Entry<IPTCTag, List<IPTCDataSet>>> entries = datasetMap.entrySet();
            for (Map.Entry<IPTCTag, List<IPTCDataSet>> entryMap : entries) {
                StringBuilder strBuilder = new StringBuilder();
                for (IPTCDataSet item : entryMap.getValue()) {
                    strBuilder.append(item.getDataAsString()).append(";");
                }
                String key = entryMap.getKey().getName();
                String value = StringUtils.replaceLast(strBuilder.toString(), ";", "");
                entry.addEntry(new MetadataEntry(key, value));
            }
            return entry;
        }
        return super.getMetadataEntry();
    }

    @Override
    public void write(OutputStream os) throws IOException {
        if (this.data == null) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.iptc.write(bout);
            this.data = bout.toByteArray();
            this.size = this.data.length;
        }
        super.write(os);
    }
}

