/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.meta.adobe;

import guilibshadow.cafe4j.image.meta.Metadata;
import guilibshadow.cafe4j.image.meta.MetadataEntry;
import guilibshadow.cafe4j.image.meta.MetadataType;
import guilibshadow.cafe4j.image.meta.adobe.IPTC_NAA;
import guilibshadow.cafe4j.image.meta.adobe.IRBThumbnail;
import guilibshadow.cafe4j.image.meta.adobe.ImageResourceID;
import guilibshadow.cafe4j.image.meta.adobe.JPGQuality;
import guilibshadow.cafe4j.image.meta.adobe.ThumbnailResource;
import guilibshadow.cafe4j.image.meta.adobe.VersionInfo;
import guilibshadow.cafe4j.image.meta.adobe._8BIM;
import guilibshadow.cafe4j.io.IOUtils;
import guilibshadow.cafe4j.string.StringUtils;
import guilibshadow.cafe4j.util.ArrayUtils;
import guilibshadow.org.slf4j.Logger;
import guilibshadow.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class IRB
extends Metadata {
    private boolean containsThumbnail;
    private ThumbnailResource thumbnail;
    Map<Short, _8BIM> _8bims = new HashMap<Short, _8BIM>();
    private static final Logger LOGGER = LoggerFactory.getLogger(IRB.class);

    public static void showIRB(byte[] data) {
        if (data != null && data.length > 0) {
            IRB irb = new IRB(data);
            try {
                irb.read();
                for (MetadataEntry item : irb) {
                    LOGGER.info(item.getKey() + ": " + item.getValue());
                    if (!item.isMetadataEntryGroup()) continue;
                    String indent = "    ";
                    Collection<MetadataEntry> entries = item.getMetadataEntries();
                    for (MetadataEntry e : entries) {
                        LOGGER.info(indent + e.getKey() + ": " + e.getValue());
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void showIRB(InputStream is) {
        try {
            IRB.showIRB(IOUtils.inputStreamToByteArray(is));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public IRB(byte[] data) {
        super(MetadataType.PHOTOSHOP_IRB, data);
    }

    public String getAsString(ImageResourceID id) {
        String emptyStr = "";
        short value = id.getValue();
        _8BIM bim = this._8bims.get(value);
        if (bim != null) {
            StringBuilder strBuilder = new StringBuilder();
            MetadataEntry item = bim.getMetadataEntry();
            strBuilder.append(item.getKey() + ":" + item.getValue() + ";");
            if (item.isMetadataEntryGroup()) {
                for (MetadataEntry entry : item.getMetadataEntries()) {
                    strBuilder.append(entry.getKey() + ":" + entry.getValue() + ";");
                }
            }
            return StringUtils.replaceLast(strBuilder.toString(), ";", "");
        }
        return emptyStr;
    }

    @Override
    public Iterator<MetadataEntry> iterator() {
        this.ensureDataRead();
        ArrayList<MetadataEntry> items = new ArrayList<MetadataEntry>();
        for (_8BIM _8bim : this._8bims.values()) {
            items.add(_8bim.getMetadataEntry());
        }
        if (this.containsThumbnail) {
            int thumbnailFormat = this.thumbnail.getDataType();
            switch (thumbnailFormat) {
                case 1: {
                    items.add(new MetadataEntry("Thumbnail Format", "DATA_TYPE_KJpegRGB"));
                    break;
                }
                case 0: {
                    items.add(new MetadataEntry("Thumbnail Format", "DATA_TYPE_KRawRGB"));
                }
            }
            items.add(new MetadataEntry("Thumbnail width", "" + this.thumbnail.getWidth()));
            items.add(new MetadataEntry("Thumbnail height", "" + this.thumbnail.getHeight()));
            items.add(new MetadataEntry("Thumbnail Padded row bytes", "" + this.thumbnail.getPaddedRowBytes()));
            items.add(new MetadataEntry("Thumbnail Total size", "" + this.thumbnail.getTotalSize()));
            items.add(new MetadataEntry("Thumbnail Size after compression", "" + this.thumbnail.getCompressedSize()));
            items.add(new MetadataEntry("Thumbnail Bits per pixel", "" + this.thumbnail.getBitsPerPixel()));
            items.add(new MetadataEntry("Thumbnail Number of planes", "" + this.thumbnail.getNumOfPlanes()));
        }
        return Collections.unmodifiableList(items).iterator();
    }

    public boolean containsThumbnail() {
        this.ensureDataRead();
        return this.containsThumbnail;
    }

    public _8BIM get8BIM(short tag) {
        this.ensureDataRead();
        return this._8bims.get(tag);
    }

    public Map<Short, _8BIM> get8BIM() {
        this.ensureDataRead();
        return Collections.unmodifiableMap(this._8bims);
    }

    public IRBThumbnail getThumbnail() {
        this.ensureDataRead();
        return this.thumbnail.getThumbnail();
    }

    public ThumbnailResource getThumbnailResource() {
        this.ensureDataRead();
        return this.thumbnail;
    }

    @Override
    public void read() throws IOException {
        if (!this.isDataRead) {
            int i = 0;
            while (i + 4 < this.data.length) {
                int nameLen;
                String _8bim = new String(this.data, i, 4);
                i += 4;
                if (!_8bim.equals("8BIM") && !_8bim.equals("PHUT")) continue;
                short id = IOUtils.readShortMM(this.data, i);
                i += 2;
                if ((nameLen = this.data[i++] & 0xFF) % 2 == 0) {
                    ++nameLen;
                }
                String name = new String(this.data, i, nameLen).trim();
                int size = IOUtils.readIntMM(this.data, i += nameLen);
                i += 4;
                if (size <= 0) continue;
                ImageResourceID eId = ImageResourceID.fromShort(id);
                switch (eId) {
                    case JPEG_QUALITY: {
                        this._8bims.put(id, new JPGQuality(name, ArrayUtils.subArray(this.data, i, size)));
                        break;
                    }
                    case VERSION_INFO: {
                        this._8bims.put(id, new VersionInfo(name, ArrayUtils.subArray(this.data, i, size)));
                        break;
                    }
                    case IPTC_NAA: {
                        byte[] newData = ArrayUtils.subArray(this.data, i, size);
                        _8BIM iptcBim = this._8bims.get(id);
                        if (iptcBim != null) {
                            byte[] oldData = iptcBim.getData();
                            this._8bims.put(id, new IPTC_NAA(name, ArrayUtils.concat(oldData, new byte[][]{newData})));
                            break;
                        }
                        this._8bims.put(id, new IPTC_NAA(name, newData));
                        break;
                    }
                    case THUMBNAIL_RESOURCE_PS4: 
                    case THUMBNAIL_RESOURCE_PS5: {
                        this.containsThumbnail = true;
                        this.thumbnail = new ThumbnailResource(eId, ArrayUtils.subArray(this.data, i, size));
                        this._8bims.put(id, this.thumbnail);
                        break;
                    }
                    default: {
                        this._8bims.put(id, new _8BIM(id, name, size, ArrayUtils.subArray(this.data, i, size)));
                    }
                }
                i += size;
                if (size % 2 == 0) continue;
                ++i;
            }
            this.isDataRead = true;
        }
    }
}

