/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.meta.adobe;

import guilibshadow.cafe4j.image.ImageIO;
import guilibshadow.cafe4j.image.ImageParam;
import guilibshadow.cafe4j.image.ImageType;
import guilibshadow.cafe4j.image.meta.Thumbnail;
import guilibshadow.cafe4j.image.options.JPGOptions;
import guilibshadow.cafe4j.image.writer.ImageWriter;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;

public class IRBThumbnail
extends Thumbnail {
    public IRBThumbnail() {
    }

    public IRBThumbnail(BufferedImage thumbnail) {
        super(thumbnail);
    }

    public IRBThumbnail(int width, int height, int dataType, byte[] compressedThumbnail) {
        super(width, height, dataType, compressedThumbnail);
    }

    public IRBThumbnail(IRBThumbnail other) {
        this.dataType = other.dataType;
        this.height = other.height;
        this.width = other.width;
        this.thumbnail = other.thumbnail;
        this.compressedThumbnail = other.compressedThumbnail;
    }

    @Override
    public void write(OutputStream os) throws IOException {
        if (this.getDataType() == 1) {
            os.write(this.getCompressedImage());
        } else if (this.getDataType() == 0) {
            BufferedImage thumbnail = this.getRawImage();
            if (thumbnail == null) {
                throw new IllegalArgumentException("Expected raw data thumbnail does not exist!");
            }
            ImageWriter jpgWriter = ImageIO.getWriter(ImageType.JPG);
            ImageParam.ImageParamBuilder builder = ImageParam.getBuilder();
            JPGOptions jpegOptions = new JPGOptions();
            jpegOptions.setQuality(this.writeQuality);
            builder.imageOptions(jpegOptions);
            jpgWriter.setImageParam(builder.build());
            try {
                jpgWriter.write(thumbnail, os);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to compress thumbnail as JPEG");
            }
        }
    }
}

