/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.meta.adobe;

import guilibshadow.cafe4j.image.meta.MetadataEntry;
import guilibshadow.cafe4j.image.meta.adobe.ImageResourceID;
import guilibshadow.cafe4j.image.meta.adobe._8BIM;
import guilibshadow.cafe4j.io.IOUtils;
import guilibshadow.org.slf4j.Logger;
import guilibshadow.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.OutputStream;

public class JPGQuality
extends _8BIM {
    private int quality = Quality.QUALITY_5_MEDIUM.getValue();
    private int format = Format.FORMAT_STANDARD.getValue();
    private int progressiveScans = ProgressiveScans.PROGRESSIVE_3_SCANS.getValue();
    private byte trailer = 1;
    private static final Logger LOGGER = LoggerFactory.getLogger(JPGQuality.class);

    public JPGQuality() {
        this("JPGQuality");
    }

    public JPGQuality(String name) {
        super(ImageResourceID.JPEG_QUALITY, name, null);
    }

    public JPGQuality(String name, byte[] data) {
        super(ImageResourceID.JPEG_QUALITY, name, data);
        this.read();
    }

    public JPGQuality(Quality quality, Format format, ProgressiveScans progressiveScans) {
        this("JPGQuality", quality, format, progressiveScans);
    }

    public JPGQuality(String name, Quality quality, Format format, ProgressiveScans progressiveScans) {
        super(ImageResourceID.JPEG_QUALITY, name, null);
        if (quality == null || format == null || progressiveScans == null) {
            throw new IllegalArgumentException("Input parameter(s) is null");
        }
        this.quality = quality.getValue();
        this.format = format.getValue();
        this.progressiveScans = progressiveScans.getValue();
    }

    public int getFormat() {
        return this.format;
    }

    public String getFormatAsString() {
        String retVal = "";
        switch (this.format) {
            case 0: {
                retVal = "Standard Format";
                break;
            }
            case 1: {
                retVal = "Optimised Format";
                break;
            }
            case 257: {
                retVal = "Progressive Format";
                break;
            }
        }
        return retVal;
    }

    @Override
    protected MetadataEntry getMetadataEntry() {
        ImageResourceID eId = ImageResourceID.fromShort(this.getID());
        MetadataEntry entry = new MetadataEntry(eId.name(), eId.getDescription(), true);
        entry.addEntry(new MetadataEntry("Quality", this.getQualityAsString()));
        entry.addEntry(new MetadataEntry("Format", this.getFormatAsString()));
        entry.addEntry(new MetadataEntry("Progressive Scans", this.getProgressiveScansAsString()));
        return entry;
    }

    public int getProgressiveScans() {
        return this.progressiveScans;
    }

    public String getProgressiveScansAsString() {
        String retVal = "";
        switch (this.progressiveScans) {
            case 1: {
                retVal = "3 Scans";
                break;
            }
            case 2: {
                retVal = "4 Scans";
                break;
            }
            case 3: {
                retVal = "5 Scans";
                break;
            }
        }
        return retVal;
    }

    public int getQuality() {
        return this.quality;
    }

    public String getQualityAsString() {
        String retVal = "";
        switch (this.quality) {
            case 65533: {
                retVal = "Quality 1 (Low)";
                break;
            }
            case 65534: {
                retVal = "Quality 2 (Low)";
                break;
            }
            case 65535: {
                retVal = "Quality 3 (Low)";
                break;
            }
            case 0: {
                retVal = "Quality 4 (Low)";
                break;
            }
            case 1: {
                retVal = "Quality 5 (Medium)";
                break;
            }
            case 2: {
                retVal = "Quality 6 (Medium)";
                break;
            }
            case 3: {
                retVal = "Quality 7 (Medium)";
                break;
            }
            case 4: {
                retVal = "Quality 8 (High)";
                break;
            }
            case 5: {
                retVal = "Quality 9 (High)";
                break;
            }
            case 6: {
                retVal = "Quality 10 (Maximum)";
                break;
            }
            case 7: {
                retVal = "Quality 11 (Maximum)";
                break;
            }
            case 8: {
                retVal = "Quality 12 (Maximum)";
                break;
            }
        }
        return retVal;
    }

    @Override
    public void print() {
        super.print();
        LOGGER.info("{} : {} : {} - Plus 1 byte unknown trailer value = {}", this.getQualityAsString(), this.getFormatAsString(), this.getProgressiveScansAsString(), this.trailer);
    }

    private void read() {
        this.quality = IOUtils.readUnsignedShortMM(this.data, 0);
        this.format = IOUtils.readUnsignedShortMM(this.data, 2);
        this.progressiveScans = IOUtils.readUnsignedShortMM(this.data, 4);
        this.trailer = this.data[6];
    }

    public void setFormat(Format format) {
        if (format == null) {
            throw new IllegalArgumentException("Input format is null");
        }
        this.format = format.getValue();
    }

    public void setProgressiveScans(ProgressiveScans progressiveScans) {
        if (progressiveScans == null) {
            throw new IllegalArgumentException("Input progressive scans is null");
        }
        this.progressiveScans = progressiveScans.getValue();
    }

    public void setQuality(Quality quality) {
        if (quality == null) {
            throw new IllegalArgumentException("Input quality is null");
        }
        this.quality = quality.getValue();
    }

    @Override
    public void write(OutputStream os) throws IOException {
        if (this.data == null) {
            this.data = new byte[7];
            this.data[0] = (byte)(this.quality >> 8 & 0xFF);
            this.data[1] = (byte)(this.quality & 0xFF);
            this.data[2] = (byte)(this.format >> 8 & 0xFF);
            this.data[3] = (byte)(this.format & 0xFF);
            this.data[4] = (byte)(this.progressiveScans >> 8 & 0xFF);
            this.data[5] = (byte)(this.progressiveScans & 0xFF);
            this.data[6] = this.trailer;
            this.size = this.data.length;
        }
        super.write(os);
    }

    public static enum Quality {
        QUALITY_1_LOW(65533),
        QUALITY_2_LOW(65534),
        QUALITY_3_LOW(65535),
        QUALITY_4_LOW(0),
        QUALITY_5_MEDIUM(1),
        QUALITY_6_MEDIUM(2),
        QUALITY_7_MEDIUM(3),
        QUALITY_8_HIGH(4),
        QUALITY_9_HIGH(5),
        QUALITY_10_MAXIMUM(6),
        QUALITY_11_MAXIMUM(7),
        QUALITY_12_MAXIMUM(8);

        private final int value;

        private Quality(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum ProgressiveScans {
        PROGRESSIVE_3_SCANS(1),
        PROGRESSIVE_4_SCANS(2),
        PROGRESSIVE_5_SCANS(3);

        private final int value;

        private ProgressiveScans(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum Format {
        FORMAT_STANDARD(0),
        FORMAT_OPTIMISED(1),
        FORMAT_PROGRESSIVE(257);

        private final int value;

        private Format(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

