/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.meta.adobe;

import guilibshadow.cafe4j.image.meta.MetadataEntry;
import guilibshadow.cafe4j.image.meta.adobe.Channel;
import guilibshadow.cafe4j.image.meta.adobe.DDBEntry;
import guilibshadow.cafe4j.image.meta.adobe.DataBlockType;
import guilibshadow.cafe4j.io.ReadStrategy;
import java.util.ArrayList;
import java.util.List;

public class LayerData
extends DDBEntry {
    private int layerCount;
    private List<Channel> channels = new ArrayList<Channel>();

    public LayerData(int size, byte[] data, ReadStrategy readStrategy) {
        super(DataBlockType.Layr, size, data, readStrategy);
        this.read();
    }

    @Override
    protected MetadataEntry getMetadataEntry() {
        MetadataEntry root = new MetadataEntry(DataBlockType.Layr.name(), DataBlockType.Layr.getDescription(), true);
        root.addEntry(new MetadataEntry("Size", this.getSize() + ""));
        root.addEntry(new MetadataEntry("Number of layers", this.layerCount + ""));
        return root;
    }

    private void read() {
        int i = 0;
        this.layerCount = this.readStrategy.readUnsignedShort(this.data, i);
        i += 2;
        for (int j = 0; j < this.layerCount; ++j) {
            int topCoord = this.readStrategy.readInt(this.data, i);
            int leftCoord = this.readStrategy.readInt(this.data, i += 4);
            int bottomCoord = this.readStrategy.readInt(this.data, i += 4);
            int rightCoord = this.readStrategy.readInt(this.data, i += 4);
            int channelCount = this.readStrategy.readUnsignedShort(this.data, i += 4);
            i += 2;
            for (int k = 0; k < channelCount; ++k) {
                short id = this.readStrategy.readShort(this.data, i);
                int len = this.readStrategy.readInt(this.data, i += 2);
                i += 4;
                this.channels.add(new Channel(id, len));
            }
            int blendModeSignature = this.readStrategy.readInt(this.data, i);
            int blendMode = this.readStrategy.readInt(this.data, i += 4);
            i += 4;
            int opacity = this.data[i++] & 0xFF;
            int clipping = this.data[i++] & 0xFF;
            int flags = this.data[i++] & 0xFF;
            int filler = this.data[i++] & 0xFF;
            int extraLen = this.readStrategy.readInt(this.data, i);
            i += 4;
            i += extraLen;
        }
    }
}

