/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.meta.adobe;

import guilibshadow.cafe4j.image.ImageIO;
import guilibshadow.cafe4j.image.ImageType;
import guilibshadow.cafe4j.image.meta.Thumbnail;
import guilibshadow.cafe4j.image.meta.adobe.IRBThumbnail;
import guilibshadow.cafe4j.image.meta.adobe.ImageResourceID;
import guilibshadow.cafe4j.image.meta.adobe._8BIM;
import guilibshadow.cafe4j.image.writer.ImageWriter;
import guilibshadow.cafe4j.io.IOUtils;
import guilibshadow.cafe4j.util.ArrayUtils;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ThumbnailResource
extends _8BIM {
    private int width;
    private int height;
    private int paddedRowBytes;
    private int totalSize;
    private int compressedSize;
    private int bitsPerPixel;
    private int numOfPlanes;
    private ImageResourceID id;
    private int dataType;
    private IRBThumbnail thumbnail = new IRBThumbnail();

    private static ImageResourceID validateID(ImageResourceID id) {
        if (id != ImageResourceID.THUMBNAIL_RESOURCE_PS4 && id != ImageResourceID.THUMBNAIL_RESOURCE_PS5) {
            throw new IllegalArgumentException("Unsupported thumbnail ImageResourceID: " + (Object)((Object)id));
        }
        return id;
    }

    public ThumbnailResource(BufferedImage thumbnail) {
        this("THUMBNAIL_RESOURCE", thumbnail);
    }

    public ThumbnailResource(ImageResourceID id, byte[] data) {
        super(ThumbnailResource.validateID(id), "THUMBNAIL_RESOURCE", data);
        this.id = id;
        this.read();
    }

    public ThumbnailResource(ImageResourceID id, int dataType, int width, int height, byte[] thumbnailData) {
        super(ThumbnailResource.validateID(id), "THUMBNAIL_RESOURCE", null);
        this.id = id;
        this.dataType = dataType;
        this.width = width > 0 ? width : 0;
        this.height = height > 0 ? height : 0;
        this.paddedRowBytes = (width * 24 + 31) / 32 * 4;
        this.totalSize = this.paddedRowBytes * height * this.numOfPlanes;
        this.compressedSize = thumbnailData.length;
        this.bitsPerPixel = 24;
        this.numOfPlanes = 1;
        this.setThumbnailImage(id, dataType, width, height, this.totalSize, thumbnailData);
    }

    public ThumbnailResource(String name, BufferedImage thumbnail) {
        super(ImageResourceID.THUMBNAIL_RESOURCE_PS5, name, null);
        try {
            this.thumbnail = this.createThumbnail(thumbnail);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create IRBThumbnail from BufferedImage");
        }
    }

    public ThumbnailResource(ImageResourceID id, Thumbnail thumbnail) {
        this(id, thumbnail.getDataType(), thumbnail.getWidth(), thumbnail.getHeight(), thumbnail.getCompressedImage());
    }

    private IRBThumbnail createThumbnail(BufferedImage thumbnail) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ImageWriter writer = ImageIO.getWriter(ImageType.JPG);
        try {
            writer.write(thumbnail, bout);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        byte[] data = bout.toByteArray();
        this.id = ImageResourceID.THUMBNAIL_RESOURCE_PS5;
        this.width = thumbnail.getWidth();
        this.height = thumbnail.getHeight();
        this.bitsPerPixel = 24;
        this.numOfPlanes = 1;
        this.paddedRowBytes = (this.width * this.bitsPerPixel + 31) / 32 * 4;
        this.totalSize = this.paddedRowBytes * this.height * this.numOfPlanes;
        this.compressedSize = data.length;
        this.dataType = 1;
        return new IRBThumbnail(this.width, this.height, this.dataType, data);
    }

    public int getBitsPerPixel() {
        return this.bitsPerPixel;
    }

    public int getCompressedSize() {
        return this.compressedSize;
    }

    public int getDataType() {
        return this.dataType;
    }

    public int getHeight() {
        return this.height;
    }

    public int getNumOfPlanes() {
        return this.numOfPlanes;
    }

    public int getPaddedRowBytes() {
        return this.paddedRowBytes;
    }

    public ImageResourceID getResouceID() {
        return this.id;
    }

    public IRBThumbnail getThumbnail() {
        return new IRBThumbnail(this.thumbnail);
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public int getWidth() {
        return this.width;
    }

    private void read() {
        this.dataType = IOUtils.readIntMM(this.data, 0);
        this.width = IOUtils.readIntMM(this.data, 4);
        this.height = IOUtils.readIntMM(this.data, 8);
        this.paddedRowBytes = IOUtils.readIntMM(this.data, 12);
        this.totalSize = IOUtils.readIntMM(this.data, 16);
        this.compressedSize = IOUtils.readIntMM(this.data, 20);
        this.bitsPerPixel = IOUtils.readShortMM(this.data, 24);
        this.numOfPlanes = IOUtils.readShortMM(this.data, 26);
        byte[] thumbnailData = null;
        if (this.dataType == 1) {
            thumbnailData = ArrayUtils.subArray(this.data, 28, this.compressedSize);
        } else if (this.dataType == 0) {
            thumbnailData = ArrayUtils.subArray(this.data, 28, this.totalSize);
        }
        this.setThumbnailImage(this.id, this.dataType, this.width, this.height, this.totalSize, thumbnailData);
    }

    private void setThumbnailImage(ImageResourceID id, int dataType, int width, int height, int totalSize, byte[] thumbnailData) {
        if (dataType == 1) {
            this.thumbnail.setImage(width, height, dataType, thumbnailData);
        } else if (dataType == 0) {
            DataBufferByte db = new DataBufferByte(thumbnailData, totalSize);
            int[] off = new int[]{0, 1, 2};
            if (id == ImageResourceID.THUMBNAIL_RESOURCE_PS4) {
                off = new int[]{2, 1, 0};
            }
            int numOfBands = 3;
            int trans = 1;
            WritableRaster raster = Raster.createInterleavedRaster(db, width, height, this.paddedRowBytes, numOfBands, off, null);
            ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1000), false, false, trans, 0);
            this.thumbnail.setImage(new BufferedImage(cm, raster, false, null));
        } else {
            throw new UnsupportedOperationException("Unsupported IRB thumbnail data type: " + dataType);
        }
    }

    @Override
    public void write(OutputStream os) throws IOException {
        if (this.data == null) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.thumbnail.write(bout);
            byte[] compressedData = bout.toByteArray();
            bout.reset();
            IOUtils.writeIntMM(bout, this.dataType);
            IOUtils.writeIntMM(bout, this.width);
            IOUtils.writeIntMM(bout, this.height);
            IOUtils.writeIntMM(bout, this.paddedRowBytes);
            IOUtils.writeIntMM(bout, this.totalSize);
            IOUtils.writeIntMM(bout, compressedData.length);
            IOUtils.writeShortMM(bout, this.bitsPerPixel);
            IOUtils.writeShortMM(bout, this.numOfPlanes);
            bout.write(compressedData);
            this.data = bout.toByteArray();
            this.size = this.data.length;
        }
        super.write(os);
    }
}

