/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.meta.adobe;

import guilibshadow.cafe4j.image.meta.MetadataEntry;
import guilibshadow.cafe4j.image.meta.adobe.ColorSpaceID;
import guilibshadow.cafe4j.image.meta.adobe.DDBEntry;
import guilibshadow.cafe4j.image.meta.adobe.DataBlockType;
import guilibshadow.cafe4j.io.ReadStrategy;
import java.util.Arrays;

public class UserMask
extends DDBEntry {
    private int colorSpaceId;
    private int[] colors = new int[4];
    private int opacity;
    private int flag;

    public UserMask(int size, byte[] data, ReadStrategy readStrategy) {
        super(DataBlockType.LMsk, size, data, readStrategy);
        this.read();
    }

    public int[] getColors() {
        return (int[])this.colors.clone();
    }

    @Override
    protected MetadataEntry getMetadataEntry() {
        MetadataEntry root = new MetadataEntry(DataBlockType.LMsk.name(), DataBlockType.LMsk.getDescription(), true);
        root.addEntry(new MetadataEntry("Size", this.getSize() + ""));
        root.addEntry(new MetadataEntry("Color Space", this.getColorSpaceID().name()));
        root.addEntry(new MetadataEntry("Color Values", Arrays.toString(this.colors)));
        root.addEntry(new MetadataEntry("Opacity", this.opacity + ""));
        root.addEntry(new MetadataEntry("Flag", this.flag + ""));
        return root;
    }

    public int getOpacity() {
        return this.opacity;
    }

    public int getFlag() {
        return this.flag;
    }

    public int getColorSpace() {
        return this.colorSpaceId;
    }

    public ColorSpaceID getColorSpaceID() {
        return ColorSpaceID.fromInt(this.colorSpaceId);
    }

    private void read() {
        int i = 0;
        this.colorSpaceId = this.readStrategy.readShort(this.data, i);
        this.colors[0] = this.readStrategy.readUnsignedShort(this.data, i += 2);
        this.colors[1] = this.readStrategy.readUnsignedShort(this.data, i += 2);
        this.colors[2] = this.readStrategy.readUnsignedShort(this.data, i += 2);
        this.colors[3] = this.readStrategy.readUnsignedShort(this.data, i += 2);
        this.opacity = this.readStrategy.readShort(this.data, i += 2);
        this.flag = this.data[i += 2] & 0xFF;
    }
}

