/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.meta.adobe;

import guilibshadow.cafe4j.image.meta.MetadataEntry;
import guilibshadow.cafe4j.image.meta.adobe.ImageResourceID;
import guilibshadow.cafe4j.image.meta.adobe._8BIM;
import guilibshadow.cafe4j.io.IOUtils;
import guilibshadow.cafe4j.string.StringUtils;
import guilibshadow.org.slf4j.Logger;
import guilibshadow.org.slf4j.LoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class VersionInfo
extends _8BIM {
    private int version;
    private boolean hasRealMergedData;
    private String writerName;
    private String readerName;
    private int fileVersion;
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionInfo.class);

    public VersionInfo() {
        this("VersionInfo");
    }

    public VersionInfo(String name) {
        super(ImageResourceID.VERSION_INFO, name, null);
    }

    public VersionInfo(String name, byte[] data) {
        super(ImageResourceID.VERSION_INFO, name, data);
        this.read();
    }

    public VersionInfo(int version, boolean hasRealMergedData, String writerName, String readerName, int fileVersion) {
        this("VersionInfo", version, hasRealMergedData, writerName, readerName, fileVersion);
    }

    public VersionInfo(String name, int version, boolean hasRealMergedData, String writerName, String readerName, int fileVersion) {
        super(ImageResourceID.VERSION_INFO, name, null);
        this.version = version;
        this.hasRealMergedData = hasRealMergedData;
        this.writerName = writerName;
        this.readerName = readerName;
        this.fileVersion = fileVersion;
    }

    public int getFileVersion() {
        return this.fileVersion;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean hasRealMergedData() {
        return this.hasRealMergedData;
    }

    @Override
    protected MetadataEntry getMetadataEntry() {
        ImageResourceID eId = ImageResourceID.fromShort(this.getID());
        MetadataEntry entry = new MetadataEntry(eId.name(), eId.getDescription(), true);
        entry.addEntry(new MetadataEntry("Version", "" + this.getVersion()));
        entry.addEntry(new MetadataEntry("Has Real Merged Data", "" + this.hasRealMergedData));
        entry.addEntry(new MetadataEntry("Writer name", this.writerName));
        entry.addEntry(new MetadataEntry("Reader name", this.readerName));
        entry.addEntry(new MetadataEntry("File Version", "" + this.getFileVersion()));
        return entry;
    }

    public String getReaderName() {
        return this.readerName;
    }

    public String getWriterName() {
        return this.writerName;
    }

    private void read() {
        int i = 0;
        this.version = IOUtils.readIntMM(this.data, i);
        i += 4;
        this.hasRealMergedData = this.data[i++] != 0;
        int writer_size = IOUtils.readIntMM(this.data, i);
        this.writerName = StringUtils.toUTF16BE(this.data, i += 4, writer_size * 2);
        int reader_size = IOUtils.readIntMM(this.data, i += writer_size * 2);
        this.readerName = StringUtils.toUTF16BE(this.data, i += 4, reader_size * 2);
        this.fileVersion = IOUtils.readIntMM(this.data, i += reader_size * 2);
    }

    @Override
    public void print() {
        super.print();
        LOGGER.info("Version: {}", (Object)this.getVersion());
        LOGGER.info("Has Real Merged Data: {}", (Object)this.hasRealMergedData);
        LOGGER.info("Writer name: {}", (Object)this.writerName);
        LOGGER.info("Reader name: {}", (Object)this.readerName);
        LOGGER.info("File Version: {}", (Object)this.getFileVersion());
    }

    public void setHasRealMergedData(boolean hasRealMergedData) {
        this.hasRealMergedData = hasRealMergedData;
    }

    public void setFileVersion(int fileVersion) {
        if (fileVersion < 0) {
            throw new IllegalArgumentException("File version number is negative");
        }
        this.fileVersion = fileVersion;
    }

    public void setVersion(int version) {
        if (version < 0) {
            throw new IllegalArgumentException("Version number is negative");
        }
        this.version = version;
    }

    public void setWriterName(String writerName) {
        this.writerName = writerName;
    }

    public void setReaderName(String readerName) {
        this.readerName = readerName;
    }

    @Override
    public void write(OutputStream os) throws IOException {
        if (this.data == null) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            IOUtils.writeIntMM(bout, this.version);
            bout.write(this.hasRealMergedData ? 1 : 0);
            byte[] writerNameBytes = null;
            writerNameBytes = this.writerName.getBytes("UTF-16BE");
            IOUtils.writeIntMM(bout, this.writerName.length());
            bout.write(writerNameBytes);
            byte[] readerNameBytes = null;
            readerNameBytes = this.readerName.getBytes("UTF-16BE");
            IOUtils.writeIntMM(bout, this.readerName.length());
            bout.write(readerNameBytes);
            IOUtils.writeIntMM(bout, this.fileVersion);
            this.data = bout.toByteArray();
            this.size = this.data.length;
        }
        super.write(os);
    }
}

