/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.meta.adobe;

import guilibshadow.cafe4j.image.meta.MetadataEntry;
import guilibshadow.cafe4j.image.meta.adobe.ImageResourceID;
import guilibshadow.cafe4j.io.IOUtils;
import guilibshadow.cafe4j.string.StringUtils;
import guilibshadow.org.slf4j.Logger;
import guilibshadow.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.OutputStream;

public class _8BIM {
    private short id;
    private String name;
    protected int size;
    protected byte[] data;
    private static final Logger LOGGER = LoggerFactory.getLogger(_8BIM.class);

    public _8BIM(short id, String name, byte[] data) {
        this(id, name, data == null ? 0 : data.length, data);
    }

    public _8BIM(short id, String name, int size, byte[] data) {
        this.id = id;
        this.name = name;
        this.size = size;
        this.data = data;
    }

    public _8BIM(ImageResourceID eId, String name, byte[] data) {
        this(eId.getValue(), name, data);
    }

    public byte[] getData() {
        return (byte[])this.data.clone();
    }

    protected MetadataEntry getMetadataEntry() {
        ImageResourceID eId = ImageResourceID.fromShort(this.id);
        if (this.id >= ImageResourceID.PATH_INFO0.getValue() && this.id <= ImageResourceID.PATH_INFO998.getValue()) {
            return new MetadataEntry("PATH_INFO [" + StringUtils.shortToHexStringMM(this.id) + "]", eId.getDescription());
        }
        if (this.id >= ImageResourceID.PLUGIN_RESOURCE0.getValue() && this.id <= ImageResourceID.PLUGIN_RESOURCE999.getValue()) {
            return new MetadataEntry("PLUGIN_RESOURCE [" + StringUtils.shortToHexStringMM(this.id) + "]", eId.getDescription());
        }
        if (eId == ImageResourceID.UNKNOWN) {
            return new MetadataEntry("UNKNOWN [" + StringUtils.shortToHexStringMM(this.id) + "]", eId.getDescription());
        }
        return new MetadataEntry("" + (Object)((Object)eId), eId.getDescription());
    }

    public String getName() {
        return this.name;
    }

    public short getID() {
        return this.id;
    }

    public int getSize() {
        return this.size;
    }

    public void print() {
        ImageResourceID eId = ImageResourceID.fromShort(this.id);
        if (this.id >= ImageResourceID.PATH_INFO0.getValue() && this.id <= ImageResourceID.PATH_INFO998.getValue()) {
            LOGGER.info("PATH_INFO [Value: {}] - Path Information (saved paths).", (Object)StringUtils.shortToHexStringMM(this.id));
        } else if (this.id >= ImageResourceID.PLUGIN_RESOURCE0.getValue() && this.id <= ImageResourceID.PLUGIN_RESOURCE999.getValue()) {
            LOGGER.info("PLUGIN_RESOURCE [Value: {}] - Plug-In resource.", (Object)StringUtils.shortToHexStringMM(this.id));
        } else if (eId == ImageResourceID.UNKNOWN) {
            LOGGER.info("{} [Value: {}]", (Object)eId, (Object)StringUtils.shortToHexStringMM(this.id));
        } else {
            LOGGER.info("{}", (Object)eId);
        }
        LOGGER.info("Type: 8BIM");
        LOGGER.info("Name: {}", (Object)this.name);
        LOGGER.info("Size: {}", (Object)this.size);
    }

    public void write(OutputStream os) throws IOException {
        os.write("8BIM".getBytes());
        IOUtils.writeShortMM(os, this.id);
        byte[] temp = this.name.trim().getBytes();
        os.write(temp.length);
        os.write(temp);
        if (temp.length % 2 == 0) {
            os.write(0);
        }
        IOUtils.writeIntMM(os, this.size);
        os.write(this.data);
        if (this.data.length % 2 != 0) {
            os.write(0);
        }
    }
}

