/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.meta.exif;

import guilibshadow.cafe4j.image.meta.Metadata;
import guilibshadow.cafe4j.image.meta.MetadataEntry;
import guilibshadow.cafe4j.image.meta.MetadataType;
import guilibshadow.cafe4j.image.meta.exif.ExifTag;
import guilibshadow.cafe4j.image.meta.exif.ExifThumbnail;
import guilibshadow.cafe4j.image.meta.exif.GPSTag;
import guilibshadow.cafe4j.image.meta.exif.InteropTag;
import guilibshadow.cafe4j.image.tiff.FieldType;
import guilibshadow.cafe4j.image.tiff.IFD;
import guilibshadow.cafe4j.image.tiff.TIFFTweaker;
import guilibshadow.cafe4j.image.tiff.Tag;
import guilibshadow.cafe4j.image.tiff.TiffField;
import guilibshadow.cafe4j.image.tiff.TiffTag;
import guilibshadow.cafe4j.io.FileCacheRandomAccessInputStream;
import guilibshadow.cafe4j.io.FileCacheRandomAccessOutputStream;
import guilibshadow.cafe4j.io.IOUtils;
import guilibshadow.cafe4j.io.RandomAccessInputStream;
import guilibshadow.cafe4j.io.RandomAccessOutputStream;
import guilibshadow.cafe4j.string.StringUtils;
import guilibshadow.org.slf4j.Logger;
import guilibshadow.org.slf4j.LoggerFactory;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class Exif
extends Metadata {
    protected IFD imageIFD;
    protected IFD exifSubIFD;
    protected IFD gpsSubIFD;
    protected ExifThumbnail thumbnail;
    private boolean containsThumbnail;
    private boolean isThumbnailRequired;
    public static final int FIRST_IFD_OFFSET = 8;
    private static final Logger LOGGER = LoggerFactory.getLogger(Exif.class);

    public Exif() {
        super(MetadataType.EXIF);
        this.isDataRead = true;
    }

    public Exif(byte[] data) {
        super(MetadataType.EXIF, data);
        this.ensureDataRead();
    }

    public Exif(IFD imageIFD) {
        this();
        this.setImageIFD(imageIFD);
    }

    public Exif(InputStream is) throws IOException {
        this(IOUtils.inputStreamToByteArray(is));
    }

    public void addExifField(ExifTag tag, FieldType type, Object data) {
        TiffField<?> field;
        if (this.exifSubIFD == null) {
            this.exifSubIFD = new IFD();
        }
        if ((field = FieldType.createField(tag, type, data)) == null) {
            throw new IllegalArgumentException("Cannot create required EXIF TIFF field");
        }
        this.exifSubIFD.addField(field);
    }

    public void addGPSField(GPSTag tag, FieldType type, Object data) {
        TiffField<?> field;
        if (this.gpsSubIFD == null) {
            this.gpsSubIFD = new IFD();
        }
        if ((field = FieldType.createField(tag, type, data)) == null) {
            throw new IllegalArgumentException("Cannot create required GPS TIFF field");
        }
        this.gpsSubIFD.addField(field);
    }

    public void addImageField(TiffTag tag, FieldType type, Object data) {
        TiffField<?> field;
        if (this.imageIFD == null) {
            this.imageIFD = new IFD();
        }
        if ((field = FieldType.createField(tag, type, data)) == null) {
            throw new IllegalArgumentException("Cannot create required Image TIFF field");
        }
        this.imageIFD.addField(field);
    }

    public boolean containsThumbnail() {
        if (this.containsThumbnail) {
            return true;
        }
        return this.thumbnail != null;
    }

    public String getAsString(Tag tag) {
        IFD ifd = null;
        String emptyString = "";
        if (tag instanceof TiffTag) {
            ifd = this.getImageIFD();
        } else if (tag instanceof ExifTag) {
            ifd = this.getExifIFD();
        } else if (tag instanceof GPSTag) {
            ifd = this.getGPSIFD();
        } else if (tag instanceof InteropTag) {
            throw new UnsupportedOperationException("InteropTag is not supported by Exif");
        }
        if (ifd != null) {
            return ifd.getFieldAsString(tag);
        }
        return emptyString;
    }

    public IFD getExifIFD() {
        if (this.exifSubIFD != null) {
            return new IFD(this.exifSubIFD);
        }
        return null;
    }

    public IFD getGPSIFD() {
        if (this.gpsSubIFD != null) {
            return new IFD(this.gpsSubIFD);
        }
        return null;
    }

    public IFD getImageIFD() {
        if (this.imageIFD != null) {
            return new IFD(this.imageIFD);
        }
        return null;
    }

    public ExifThumbnail getThumbnail() {
        if (this.thumbnail != null) {
            return new ExifThumbnail(this.thumbnail);
        }
        return null;
    }

    public boolean isThumbnailRequired() {
        return this.isThumbnailRequired;
    }

    @Override
    public Iterator<MetadataEntry> iterator() {
        this.ensureDataRead();
        ArrayList<MetadataEntry> items = new ArrayList<MetadataEntry>();
        if (this.imageIFD != null) {
            this.getMetadataEntries(this.imageIFD, TiffTag.class, items);
        }
        if (this.containsThumbnail) {
            MetadataEntry thumbnailEntry = new MetadataEntry("IFD1", "Thumbnail Image", true);
            thumbnailEntry.addEntry(new MetadataEntry("Thumbnail format", this.thumbnail.getDataType() == 1 ? "DATA_TYPE_KJpegRGB" : "DATA_TYPE_TIFF"));
            thumbnailEntry.addEntry(new MetadataEntry("Thumbnail data length", "" + this.thumbnail.getCompressedImage().length));
            items.add(thumbnailEntry);
        }
        return Collections.unmodifiableList(items).iterator();
    }

    private void getMetadataEntries(IFD currIFD, Class<? extends Tag> tagClass, List<MetadataEntry> items) {
        Method method = null;
        try {
            method = tagClass.getDeclaredMethod("fromShort", Short.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Method 'fromShort' is not defined for class " + tagClass);
        }
        catch (SecurityException e) {
            throw new RuntimeException("The operation is not allowed by the current security setup");
        }
        Collection<TiffField<?>> fields = currIFD.getFields();
        MetadataEntry entry = null;
        entry = tagClass.equals(TiffTag.class) ? new MetadataEntry("IFD0", "Image Info", true) : (tagClass.equals(ExifTag.class) ? new MetadataEntry("EXIF SubIFD", "EXIF Info", true) : (tagClass.equals(GPSTag.class) ? new MetadataEntry("GPS SubIFD", "GPS Info", true) : new MetadataEntry("UNKNOWN", "UNKNOWN SubIFD", true)));
        for (TiffField<?> field : fields) {
            short tag = field.getTag();
            Tag ftag = TiffTag.UNKNOWN;
            if (tag == ExifTag.PADDING.getValue()) {
                ftag = ExifTag.PADDING;
            } else {
                try {
                    ftag = (Tag)method.invoke(null, tag);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Illegal access for method: " + method);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException("Illegal argument for method:  " + method);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException("Incorrect invocation target");
                }
            }
            if (ftag == TiffTag.UNKNOWN) {
                LOGGER.warn("Tag: {} [Value: 0x{}] (Unknown)", (Object)ftag, (Object)Integer.toHexString(tag & 0xFFFF));
            }
            FieldType ftype = field.getType();
            String tagString = null;
            tagString = ftype == FieldType.SHORT || ftype == FieldType.SSHORT ? ftag.getFieldAsString(field.getDataAsLong()) : ftag.getFieldAsString(field.getData());
            if (StringUtils.isNullOrEmpty(tagString)) {
                entry.addEntry(new MetadataEntry(ftag.getName(), field.getDataAsString()));
                continue;
            }
            entry.addEntry(new MetadataEntry(ftag.getName(), tagString));
        }
        items.add(entry);
        Map<Tag, IFD> children = currIFD.getChildren();
        if (children.get(TiffTag.EXIF_SUB_IFD) != null) {
            this.getMetadataEntries(children.get(TiffTag.EXIF_SUB_IFD), ExifTag.class, items);
        }
        if (children.get(TiffTag.GPS_SUB_IFD) != null) {
            this.getMetadataEntries(children.get(TiffTag.GPS_SUB_IFD), GPSTag.class, items);
        }
    }

    @Override
    public void read() throws IOException {
        if (!this.isDataRead) {
            FileCacheRandomAccessInputStream exifIn = new FileCacheRandomAccessInputStream(new ByteArrayInputStream(this.data));
            ArrayList<IFD> ifds = new ArrayList<IFD>(3);
            TIFFTweaker.readIFDs(ifds, exifIn);
            if (ifds.size() > 0) {
                this.imageIFD = (IFD)ifds.get(0);
                this.exifSubIFD = this.imageIFD.getChild(TiffTag.EXIF_SUB_IFD);
                this.gpsSubIFD = this.imageIFD.getChild(TiffTag.GPS_SUB_IFD);
            }
            if (ifds.size() >= 2) {
                IFD thumbnailIFD = (IFD)ifds.get(1);
                int width = -1;
                int height = -1;
                TiffField<?> field = thumbnailIFD.getField(TiffTag.IMAGE_WIDTH);
                if (field != null) {
                    width = field.getDataAsLong()[0];
                }
                if ((field = thumbnailIFD.getField(TiffTag.IMAGE_LENGTH)) != null) {
                    height = field.getDataAsLong()[0];
                }
                if ((field = thumbnailIFD.getField(TiffTag.JPEG_INTERCHANGE_FORMAT)) != null) {
                    int thumbnailOffset = field.getDataAsLong()[0];
                    ((RandomAccessInputStream)exifIn).seek(thumbnailOffset);
                    field = thumbnailIFD.getField(TiffTag.JPEG_INTERCHANGE_FORMAT_LENGTH);
                    int thumbnailLen = field.getDataAsLong()[0];
                    if (thumbnailLen > 0) {
                        byte[] thumbnailData = new byte[thumbnailLen];
                        exifIn.readFully(thumbnailData);
                        this.thumbnail = new ExifThumbnail(width, height, 1, thumbnailData, thumbnailIFD);
                        this.containsThumbnail = true;
                    }
                } else {
                    field = thumbnailIFD.getField(TiffTag.STRIP_OFFSETS);
                    if (field == null) {
                        field = thumbnailIFD.getField(TiffTag.TILE_OFFSETS);
                    }
                    if (field != null) {
                        ((RandomAccessInputStream)exifIn).seek(0L);
                        ByteArrayOutputStream bout = new ByteArrayOutputStream();
                        FileCacheRandomAccessOutputStream tiffout = new FileCacheRandomAccessOutputStream(bout);
                        TIFFTweaker.retainPages(exifIn, tiffout, 1);
                        ((RandomAccessOutputStream)tiffout).close();
                        this.thumbnail = new ExifThumbnail(width, height, 2, bout.toByteArray(), thumbnailIFD);
                        this.containsThumbnail = true;
                    }
                }
            }
            ((RandomAccessInputStream)exifIn).shallowClose();
            this.isDataRead = true;
        }
    }

    public void setExifIFD(IFD exifSubIFD) {
        this.exifSubIFD = exifSubIFD;
    }

    public void setGPSIFD(IFD gpsSubIFD) {
        this.gpsSubIFD = gpsSubIFD;
    }

    public void setImageIFD(IFD imageIFD) {
        if (imageIFD == null) {
            throw new IllegalArgumentException("Input image IFD is null");
        }
        this.imageIFD = imageIFD;
        this.exifSubIFD = imageIFD.getChild(TiffTag.EXIF_SUB_IFD);
        this.gpsSubIFD = imageIFD.getChild(TiffTag.GPS_SUB_IFD);
    }

    public void setThumbnail(ExifThumbnail thumbnail) {
        this.thumbnail = thumbnail;
    }

    public void setThumbnailImage(BufferedImage thumbnail) {
        if (this.thumbnail == null) {
            this.thumbnail = new ExifThumbnail();
        }
        this.thumbnail.setImage(thumbnail);
    }

    public void setThumbnailRequired(boolean isThumbnailRequired) {
        this.isThumbnailRequired = isThumbnailRequired;
    }

    @Override
    public abstract void write(OutputStream var1) throws IOException;
}

