/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.meta.exif;

import guilibshadow.cafe4j.image.ImageIO;
import guilibshadow.cafe4j.image.ImageParam;
import guilibshadow.cafe4j.image.ImageType;
import guilibshadow.cafe4j.image.meta.Thumbnail;
import guilibshadow.cafe4j.image.options.JPGOptions;
import guilibshadow.cafe4j.image.tiff.IFD;
import guilibshadow.cafe4j.image.tiff.LongField;
import guilibshadow.cafe4j.image.tiff.RationalField;
import guilibshadow.cafe4j.image.tiff.ShortField;
import guilibshadow.cafe4j.image.tiff.TIFFTweaker;
import guilibshadow.cafe4j.image.tiff.TiffField;
import guilibshadow.cafe4j.image.tiff.TiffFieldEnum;
import guilibshadow.cafe4j.image.tiff.TiffTag;
import guilibshadow.cafe4j.image.writer.ImageWriter;
import guilibshadow.cafe4j.io.FileCacheRandomAccessInputStream;
import guilibshadow.cafe4j.io.MemoryCacheRandomAccessOutputStream;
import guilibshadow.cafe4j.io.RandomAccessInputStream;
import guilibshadow.cafe4j.io.RandomAccessOutputStream;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class ExifThumbnail
extends Thumbnail {
    private IFD thumbnailIFD = new IFD();

    public ExifThumbnail() {
    }

    public ExifThumbnail(BufferedImage thumbnail) {
        super(thumbnail);
    }

    public ExifThumbnail(ExifThumbnail other) {
        this.dataType = other.dataType;
        this.height = other.height;
        this.width = other.width;
        this.thumbnail = other.thumbnail;
        this.compressedThumbnail = other.compressedThumbnail;
        this.thumbnailIFD = other.thumbnailIFD;
    }

    public ExifThumbnail(int width, int height, int dataType, byte[] compressedThumbnail) {
        super(width, height, dataType, compressedThumbnail);
    }

    public ExifThumbnail(int width, int height, int dataType, byte[] compressedThumbnail, IFD thumbnailIFD) {
        super(width, height, dataType, compressedThumbnail);
        this.thumbnailIFD = thumbnailIFD;
    }

    @Override
    public void write(OutputStream os) throws IOException {
        RandomAccessOutputStream randOS = null;
        randOS = os instanceof RandomAccessOutputStream ? (RandomAccessOutputStream)os : new MemoryCacheRandomAccessOutputStream(os);
        int offset = (int)randOS.getStreamPointer();
        if (this.getDataType() == 1) {
            byte[] compressedImage = this.getCompressedImage();
            if (compressedImage == null) {
                throw new IllegalArgumentException("Expected compressed thumbnail data does not exist!");
            }
            this.thumbnailIFD.addField(new LongField(TiffTag.JPEG_INTERCHANGE_FORMAT.getValue(), new int[]{0}));
            this.thumbnailIFD.addField(new LongField(TiffTag.JPEG_INTERCHANGE_FORMAT_LENGTH.getValue(), new int[]{compressedImage.length}));
            offset = this.thumbnailIFD.write(randOS, offset);
            randOS.seek(offset);
            randOS.write(this.getCompressedImage());
            randOS.seek(this.thumbnailIFD.getField(TiffTag.JPEG_INTERCHANGE_FORMAT).getDataOffset());
            randOS.writeInt(offset);
        } else if (this.getDataType() == 2) {
            TiffField<?> stripByteCounts;
            ArrayList<IFD> list = new ArrayList<IFD>();
            FileCacheRandomAccessInputStream tiffIn = new FileCacheRandomAccessInputStream(new ByteArrayInputStream(this.getCompressedImage()));
            TIFFTweaker.readIFDs(list, tiffIn);
            TiffField<?> stripOffset = ((IFD)list.get(0)).getField(TiffTag.STRIP_OFFSETS);
            if (stripOffset == null) {
                stripOffset = ((IFD)list.get(0)).getField(TiffTag.TILE_OFFSETS);
            }
            if ((stripByteCounts = ((IFD)list.get(0)).getField(TiffTag.STRIP_BYTE_COUNTS)) == null) {
                stripByteCounts = ((IFD)list.get(0)).getField(TiffTag.TILE_BYTE_COUNTS);
            }
            offset = ((IFD)list.get(0)).write(randOS, offset);
            int[] off = new int[]{};
            if (stripOffset != null) {
                off = stripOffset.getDataAsLong();
                int[] counts = stripByteCounts.getDataAsLong();
                for (int i = 0; i < off.length; ++i) {
                    ((RandomAccessInputStream)tiffIn).seek(off[i]);
                    byte[] temp = new byte[counts[i]];
                    tiffIn.readFully(temp);
                    randOS.seek(offset);
                    randOS.write(temp);
                    off[i] = offset;
                    offset += counts[i];
                }
            }
            ((RandomAccessInputStream)tiffIn).shallowClose();
            randOS.seek(stripOffset.getDataOffset());
            for (int i : off) {
                randOS.writeInt(i);
            }
        } else {
            BufferedImage thumbnail = this.getRawImage();
            if (thumbnail == null) {
                throw new IllegalArgumentException("Expected raw data thumbnail does not exist!");
            }
            int thumbnailWidth = thumbnail.getWidth();
            int thumbnailHeight = thumbnail.getHeight();
            this.thumbnailIFD.addField(new ShortField(TiffTag.IMAGE_WIDTH.getValue(), new short[]{(short)thumbnailWidth}));
            this.thumbnailIFD.addField(new ShortField(TiffTag.IMAGE_LENGTH.getValue(), new short[]{(short)thumbnailHeight}));
            this.thumbnailIFD.addField(new LongField(TiffTag.JPEG_INTERCHANGE_FORMAT.getValue(), new int[]{0}));
            this.thumbnailIFD.addField(new LongField(TiffTag.JPEG_INTERCHANGE_FORMAT_LENGTH.getValue(), new int[]{0}));
            this.thumbnailIFD.addField(new RationalField(TiffTag.X_RESOLUTION.getValue(), new int[]{thumbnailWidth, 1}));
            this.thumbnailIFD.addField(new RationalField(TiffTag.Y_RESOLUTION.getValue(), new int[]{thumbnailHeight, 1}));
            this.thumbnailIFD.addField(new ShortField(TiffTag.RESOLUTION_UNIT.getValue(), new short[]{1}));
            this.thumbnailIFD.addField(new ShortField(TiffTag.PHOTOMETRIC_INTERPRETATION.getValue(), new short[]{(short)TiffFieldEnum.PhotoMetric.YCbCr.getValue()}));
            this.thumbnailIFD.addField(new ShortField(TiffTag.SAMPLES_PER_PIXEL.getValue(), new short[]{3}));
            this.thumbnailIFD.addField(new ShortField(TiffTag.BITS_PER_SAMPLE.getValue(), new short[]{8, 8, 8}));
            this.thumbnailIFD.addField(new ShortField(TiffTag.YCbCr_SUB_SAMPLING.getValue(), new short[]{1, 1}));
            this.thumbnailIFD.addField(new ShortField(TiffTag.PLANAR_CONFIGURATTION.getValue(), new short[]{(short)TiffFieldEnum.PlanarConfiguration.CONTIGUOUS.getValue()}));
            this.thumbnailIFD.addField(new ShortField(TiffTag.COMPRESSION.getValue(), new short[]{(short)TiffFieldEnum.Compression.OLD_JPG.getValue()}));
            this.thumbnailIFD.addField(new ShortField(TiffTag.ROWS_PER_STRIP.getValue(), new short[]{(short)thumbnailHeight}));
            randOS.seek(this.thumbnailIFD.write(randOS, offset));
            ImageWriter jpgWriter = ImageIO.getWriter(ImageType.JPG);
            ImageParam.ImageParamBuilder builder = ImageParam.getBuilder();
            JPGOptions jpegOptions = new JPGOptions();
            jpegOptions.setQuality(this.writeQuality);
            builder.imageOptions(jpegOptions);
            jpgWriter.setImageParam(builder.build());
            long startOffset = randOS.getStreamPointer();
            try {
                jpgWriter.write(thumbnail, randOS);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            long finishOffset = randOS.getStreamPointer();
            int totalOut = (int)(finishOffset - startOffset);
            randOS.seek(this.thumbnailIFD.getField(TiffTag.JPEG_INTERCHANGE_FORMAT).getDataOffset());
            randOS.writeInt((int)startOffset);
            randOS.seek(this.thumbnailIFD.getField(TiffTag.JPEG_INTERCHANGE_FORMAT_LENGTH).getDataOffset());
            randOS.writeInt(totalOut);
        }
        if (!(os instanceof RandomAccessOutputStream)) {
            randOS.shallowClose();
        }
    }
}

