/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.meta.exif;

import guilibshadow.cafe4j.image.tiff.FieldType;
import guilibshadow.cafe4j.image.tiff.Tag;
import guilibshadow.cafe4j.image.tiff.TiffTag;
import guilibshadow.cafe4j.string.StringUtils;
import java.util.HashMap;
import java.util.Map;

public enum InteropTag implements Tag
{
    INTEROPERABILITY_INDEX("Interoperability Index", 1){

        @Override
        public FieldType getFieldType() {
            return FieldType.ASCII;
        }
    }
    ,
    INTEROPERABILITY_VERSION("Interoperability Version", 2){

        @Override
        public FieldType getFieldType() {
            return FieldType.UNDEFINED;
        }
    }
    ,
    RELATED_IMAGE_FILE_FORMAT("Related Image File Format", 4096){

        @Override
        public FieldType getFieldType() {
            return FieldType.ASCII;
        }
    }
    ,
    RELATED_IMAGE_WIDTH("Related Image Width", 4097){

        @Override
        public FieldType getFieldType() {
            return FieldType.SHORT;
        }
    }
    ,
    RELATED_IMAGE_LENGTH("Related Image Length", 4098){

        @Override
        public FieldType getFieldType() {
            return FieldType.SHORT;
        }
    }
    ,
    UNKNOWN("Unknown", -1);

    private static final Map<Short, InteropTag> tagMap;
    private final String name;
    private final short value;

    private InteropTag(String name, short value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public short getValue() {
        return this.value;
    }

    public String toString() {
        if (this == UNKNOWN) {
            return this.name;
        }
        return this.name + " [Value: " + StringUtils.shortToHexStringMM(this.value) + "]";
    }

    public static Tag fromShort(short value) {
        InteropTag tag = tagMap.get(value);
        if (tag == null) {
            return TiffTag.UNKNOWN;
        }
        return tag;
    }

    @Override
    public String getFieldAsString(Object value) {
        return "";
    }

    @Override
    public boolean isCritical() {
        return true;
    }

    @Override
    public FieldType getFieldType() {
        return FieldType.UNKNOWN;
    }

    static {
        tagMap = new HashMap<Short, InteropTag>();
        for (InteropTag tag : InteropTag.values()) {
            tagMap.put(tag.getValue(), tag);
        }
    }
}

