/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.meta.icc;

import guilibshadow.cafe4j.image.meta.Metadata;
import guilibshadow.cafe4j.image.meta.MetadataEntry;
import guilibshadow.cafe4j.image.meta.MetadataType;
import guilibshadow.cafe4j.image.meta.icc.ProfileTag;
import guilibshadow.cafe4j.image.meta.icc.ProfileTagTable;
import guilibshadow.cafe4j.io.IOUtils;
import guilibshadow.cafe4j.string.StringUtils;
import guilibshadow.org.slf4j.Logger;
import guilibshadow.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ICCProfile
extends Metadata {
    public static final int TAG_TABLE_OFFSET = 128;
    private static final Logger LOGGER = LoggerFactory.getLogger(ICCProfile.class);
    private ICCProfileHeader header;
    private ProfileTagTable tagTable;

    public static void showProfile(byte[] data) {
        if (data != null && data.length > 0) {
            ICCProfile icc_profile = new ICCProfile(data);
            try {
                icc_profile.read();
                for (MetadataEntry item : icc_profile) {
                    LOGGER.info(item.getKey() + ": " + item.getValue());
                    if (!item.isMetadataEntryGroup()) continue;
                    String indent = "    ";
                    Collection<MetadataEntry> entries = item.getMetadataEntries();
                    for (MetadataEntry e : entries) {
                        LOGGER.info(indent + e.getKey() + ": " + e.getValue());
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void showProfile(InputStream is) {
        try {
            ICCProfile.showProfile(IOUtils.inputStreamToByteArray(is));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ICCProfile(byte[] profile) {
        super(MetadataType.ICC_PROFILE, profile);
        this.ensureDataRead();
    }

    public ICCProfile(InputStream is) throws IOException {
        this(IOUtils.inputStreamToByteArray(is));
    }

    public boolean canBeUsedIndependently() {
        return (this.header.profileFlags[0] >> 6 & 1) == 0;
    }

    public String getAsString(ProfileTag tag) {
        throw new UnsupportedOperationException("getAsString() is not implemented for ICCProfile");
    }

    public String getBytesReserved() {
        return StringUtils.byteArrayToHexString(this.header.bytesReserved);
    }

    public String getColorSpace() {
        return new String(this.header.colorSpace).trim();
    }

    public String getDateTimeCreated() {
        int year = IOUtils.readUnsignedShortMM(this.header.dateTimeCreated, 0);
        int month = IOUtils.readUnsignedShortMM(this.header.dateTimeCreated, 2);
        int day = IOUtils.readUnsignedShortMM(this.header.dateTimeCreated, 4);
        int hour = IOUtils.readUnsignedShortMM(this.header.dateTimeCreated, 6);
        int minutes = IOUtils.readUnsignedShortMM(this.header.dateTimeCreated, 8);
        int seconds = IOUtils.readUnsignedShortMM(this.header.dateTimeCreated, 10);
        return year + "/" + month + "/" + day + ", " + hour + ":" + minutes + ":" + seconds;
    }

    public String getDeviceAttributes() {
        return (this.isReflective() ? "reflective" : "transparency") + ", " + (this.isGlossy() ? "glossy" : "matte") + ", " + (this.isPositive() ? "positive" : "negative") + ", " + (this.isColor() ? "color" : "black & white");
    }

    public String getDeviceManufacturer() {
        return new String(this.header.deviceManufacturer).trim();
    }

    public String getDeviceModel() {
        return new String(this.header.deviceModel).trim();
    }

    public String getPCS() {
        return new String(this.header.PCS).trim();
    }

    public float[] getPCSXYZ() {
        float PCSX = IOUtils.readS15Fixed16MMNumber(this.header.PCSXYZ, 0);
        float PCSY = IOUtils.readS15Fixed16MMNumber(this.header.PCSXYZ, 4);
        float PCSZ = IOUtils.readS15Fixed16MMNumber(this.header.PCSXYZ, 8);
        return new float[]{PCSX, PCSY, PCSZ};
    }

    public String getPreferredCMMType() {
        return new String(this.header.preferredCMMType).trim();
    }

    public String getPrimaryPlatformSignature() {
        return new String(this.header.primaryPlatformSignature).trim();
    }

    public String getProfileClass() {
        switch (this.header.profileClass) {
            case 1935896178: {
                return "scnr";
            }
            case 1835955314: {
                return "mntr";
            }
            case 1886549106: {
                return "prtr";
            }
            case 1818848875: {
                return "link";
            }
            case 1936744803: {
                return "spac";
            }
            case 1633842036: {
                return "abst";
            }
            case 1852662636: {
                return "nmcl";
            }
        }
        return "unknown";
    }

    public String getProfileClassDescription() {
        switch (this.header.profileClass) {
            case 1935896178: {
                return "'scnr': input devices - scanners and digital cameras";
            }
            case 1835955314: {
                return "'mntr': display devices - CRTs and LCDs";
            }
            case 1886549106: {
                return "'prtr': output devices - printers";
            }
            case 1818848875: {
                return "'link': device link profiles";
            }
            case 1936744803: {
                return "'spac': color space conversion profiles";
            }
            case 1633842036: {
                return "'abst': abstract profiles";
            }
            case 1852662636: {
                return "'nmcl': named color profiles";
            }
        }
        throw new IllegalArgumentException("Unknown profile/device class: " + this.header.profileClass);
    }

    public String getProfileCreator() {
        return new String(this.header.profileCreator).trim();
    }

    public String getProfileFileSignature() {
        return new String(this.header.profileFileSignature).trim();
    }

    public String getProfileFlags() {
        return (this.isEmbeddedInFile() ? "embedded in file" : "not embedded") + ", " + (this.canBeUsedIndependently() ? "used independently" : "cannot be used independently");
    }

    public String getProfileID() {
        return StringUtils.byteArrayToHexString(this.header.profileID);
    }

    public long getProfileSize() {
        return this.header.profileSize;
    }

    public String getProfileVersionNumber() {
        int majorVersion = this.header.profileVersionNumber[0] & 0xFF;
        int minorRevision = this.header.profileVersionNumber[1] >> 4 & 0xF;
        int bugFix = this.header.profileVersionNumber[1] & 0xF;
        return "" + majorVersion + "." + minorRevision + bugFix;
    }

    public int getRenderingIntent() {
        return this.header.renderingIntent & 0xFFFF;
    }

    public String getRenderingIntentDescription() {
        switch (this.header.renderingIntent & 0xFFFF) {
            case 0: {
                return "perceptual";
            }
            case 1: {
                return "media-relative colorimetric";
            }
            case 2: {
                return "saturation";
            }
            case 3: {
                return "ICC-absolute colorimetric";
            }
        }
        throw new IllegalArgumentException("Unknown rendering intent: " + (this.header.renderingIntent & 0xFFFF));
    }

    public ProfileTagTable getTagTable() {
        return this.tagTable;
    }

    public boolean isColor() {
        return (this.header.deviceAttributes[0] >> 4 & 1) == 0;
    }

    public boolean isEmbeddedInFile() {
        return (this.header.profileFlags[0] >> 7 & 1) == 1;
    }

    public boolean isGlossy() {
        return (this.header.deviceAttributes[0] >> 6 & 1) == 0;
    }

    public boolean isPositive() {
        return (this.header.deviceAttributes[0] >> 5 & 1) == 0;
    }

    public boolean isReflective() {
        return (this.header.deviceAttributes[0] >> 7 & 1) == 0;
    }

    @Override
    public Iterator<MetadataEntry> iterator() {
        this.ensureDataRead();
        ArrayList<MetadataEntry> entries = new ArrayList<MetadataEntry>();
        MetadataEntry header = new MetadataEntry("ICC Profile", "Header", true);
        header.addEntry(new MetadataEntry("Profile Size", this.getProfileSize() + ""));
        header.addEntry(new MetadataEntry("CMM Type", this.getPreferredCMMType()));
        header.addEntry(new MetadataEntry("Version", this.getProfileVersionNumber() + ""));
        header.addEntry(new MetadataEntry("Profile/Device Class", this.getProfileClassDescription()));
        header.addEntry(new MetadataEntry("Color Space", this.getColorSpace()));
        header.addEntry(new MetadataEntry("PCS", this.getPCS()));
        header.addEntry(new MetadataEntry("Date Created", this.getDateTimeCreated()));
        header.addEntry(new MetadataEntry("Profile File Signature", this.getProfileFileSignature()));
        header.addEntry(new MetadataEntry("Primary Platform Signature", this.getPrimaryPlatformSignature()));
        header.addEntry(new MetadataEntry("Flags", this.getProfileFlags()));
        header.addEntry(new MetadataEntry("Device Manufacturer", this.getDeviceManufacturer()));
        header.addEntry(new MetadataEntry("Device Model", this.getDeviceModel()));
        header.addEntry(new MetadataEntry("Device Attributes", this.getDeviceAttributes()));
        header.addEntry(new MetadataEntry("Rendering Intent", this.getRenderingIntentDescription()));
        header.addEntry(new MetadataEntry("PCS Illuminant [X]", this.getPCSXYZ()[0] + ""));
        header.addEntry(new MetadataEntry("PCS Illuminant [Y]", this.getPCSXYZ()[1] + ""));
        header.addEntry(new MetadataEntry("PCS Illuminant [Z]", this.getPCSXYZ()[2] + ""));
        header.addEntry(new MetadataEntry("Profile Creator", this.getProfileCreator()));
        header.addEntry(new MetadataEntry("Profile ID", this.getProfileID()));
        entries.add(header);
        MetadataEntry tagTableEntry = new MetadataEntry("ICC Profile", "Tag Table", true);
        tagTableEntry.addEntry(new MetadataEntry("Tag Count", this.tagTable.getTagCount() + ""));
        List<ProfileTagTable.TagEntry> tagEntries = this.tagTable.getTagEntries();
        Collections.sort(tagEntries);
        for (ProfileTagTable.TagEntry entry : tagEntries) {
            tagTableEntry.addEntry(new MetadataEntry("Tag Name", (Object)((Object)ProfileTag.fromInt(entry.getProfileTag())) + ""));
            tagTableEntry.addEntry(new MetadataEntry("Data Offset", entry.getDataOffset() + ""));
            tagTableEntry.addEntry(new MetadataEntry("Data Length", entry.getDataLength() + ""));
        }
        entries.add(tagTableEntry);
        return Collections.unmodifiableCollection(entries).iterator();
    }

    @Override
    public void read() throws IOException {
        if (!this.isDataRead) {
            this.header = new ICCProfileHeader();
            this.tagTable = new ProfileTagTable();
            this.readHeader(this.data);
            this.readTagTable(this.data);
            this.isDataRead = true;
        }
    }

    private void readHeader(byte[] data) {
        this.header.profileSize = IOUtils.readUnsignedIntMM(data, 0);
        System.arraycopy(data, 4, this.header.preferredCMMType, 0, 4);
        System.arraycopy(data, 8, this.header.profileVersionNumber, 0, 4);
        this.header.profileClass = IOUtils.readIntMM(data, 12);
        System.arraycopy(data, 16, this.header.colorSpace, 0, 4);
        System.arraycopy(data, 20, this.header.PCS, 0, 4);
        System.arraycopy(data, 24, this.header.dateTimeCreated, 0, 12);
        System.arraycopy(data, 36, this.header.profileFileSignature, 0, 4);
        System.arraycopy(data, 40, this.header.primaryPlatformSignature, 0, 4);
        System.arraycopy(data, 44, this.header.profileFlags, 0, 4);
        System.arraycopy(data, 48, this.header.deviceManufacturer, 0, 4);
        System.arraycopy(data, 52, this.header.deviceModel, 0, 4);
        System.arraycopy(data, 56, this.header.deviceAttributes, 0, 8);
        this.header.renderingIntent = IOUtils.readIntMM(data, 64);
        System.arraycopy(data, 68, this.header.PCSXYZ, 0, 12);
        System.arraycopy(data, 80, this.header.profileCreator, 0, 4);
        System.arraycopy(data, 84, this.header.profileID, 0, 16);
        System.arraycopy(data, 100, this.header.bytesReserved, 0, 28);
    }

    private void readTagTable(byte[] data) {
        this.tagTable.read(data);
    }

    private static class ICCProfileHeader {
        private long profileSize;
        private byte[] preferredCMMType = new byte[4];
        private byte[] profileVersionNumber = new byte[4];
        private int profileClass;
        private byte[] colorSpace = new byte[4];
        private byte[] PCS = new byte[4];
        private byte[] dateTimeCreated = new byte[12];
        private byte[] profileFileSignature = new byte[4];
        private byte[] primaryPlatformSignature = new byte[4];
        private byte[] profileFlags = new byte[4];
        private byte[] deviceManufacturer = new byte[4];
        private byte[] deviceModel = new byte[4];
        private byte[] deviceAttributes = new byte[8];
        private int renderingIntent;
        private byte[] PCSXYZ = new byte[12];
        private byte[] profileCreator = new byte[4];
        private byte[] profileID = new byte[16];
        private byte[] bytesReserved = new byte[28];

        private ICCProfileHeader() {
        }
    }
}

