/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.meta.icc;

import guilibshadow.cafe4j.image.meta.icc.ProfileTag;
import guilibshadow.cafe4j.io.IOUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProfileTagTable {
    private int tagCount;
    private Map<Integer, TagEntry> tagEntries = new HashMap<Integer, TagEntry>();

    public void addTagEntry(TagEntry tagEntry) {
        this.tagEntries.put(tagEntry.getProfileTag(), tagEntry);
    }

    public void read(byte[] data) {
        int offset = 128;
        this.tagCount = IOUtils.readIntMM(data, offset);
        offset += 4;
        for (int i = 0; i < this.tagCount; ++i) {
            int tagSignature = IOUtils.readIntMM(data, offset);
            ProfileTag tag = ProfileTag.fromInt(tagSignature);
            int dataOffset = IOUtils.readIntMM(data, offset += 4);
            int dataLength = IOUtils.readIntMM(data, offset += 4);
            offset += 4;
            byte[] temp = new byte[dataLength];
            System.arraycopy(data, dataOffset, temp, 0, temp.length);
            this.tagEntries.put(tagSignature, new TagEntry(tag.getValue(), dataOffset, dataLength, temp));
        }
    }

    public int getTagCount() {
        return this.tagCount;
    }

    public TagEntry getTagEntry(ProfileTag profileTag) {
        return this.tagEntries.get(profileTag.getValue());
    }

    public List<TagEntry> getTagEntries() {
        return new ArrayList<TagEntry>(this.tagEntries.values());
    }

    public static class TagEntry
    implements Comparable<TagEntry> {
        private int profileTag;
        private int dataOffset;
        private int dataLength;
        private byte[] data;

        public TagEntry(int profileTag, int dataOffset, int dataLength, byte[] data) {
            this.profileTag = profileTag;
            this.dataOffset = dataOffset;
            this.dataLength = dataLength;
            this.data = data;
        }

        @Override
        public int compareTo(TagEntry o) {
            return (int)(((long)this.profileTag & 0xFFFFFFFFL) - ((long)o.profileTag & 0xFFFFFFFFL));
        }

        public int getProfileTag() {
            return this.profileTag;
        }

        public int getDataOffset() {
            return this.dataOffset;
        }

        public int getDataLength() {
            return this.dataLength;
        }

        public byte[] getData() {
            return this.data;
        }
    }
}

