/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.meta.image;

import guilibshadow.cafe4j.image.meta.Metadata;
import guilibshadow.cafe4j.image.meta.MetadataEntry;
import guilibshadow.cafe4j.image.meta.MetadataType;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class Comments
extends Metadata {
    private Queue<byte[]> queue = new LinkedList<byte[]>();
    private List<String> comments;

    public Comments() {
        super(MetadataType.COMMENT);
        this.comments = new ArrayList<String>();
    }

    public Comments(List<String> comments) {
        super(MetadataType.COMMENT);
        if (comments == null) {
            throw new IllegalArgumentException("Input is null");
        }
        this.comments = comments;
    }

    public List<String> getComments() {
        this.ensureDataRead();
        return Collections.unmodifiableList(this.comments);
    }

    public void addComment(byte[] comment) {
        if (comment == null) {
            throw new IllegalArgumentException("Input is null");
        }
        this.queue.offer(comment);
    }

    public void addComment(String comment) {
        if (comment == null) {
            throw new IllegalArgumentException("Input is null");
        }
        this.comments.add(comment);
    }

    @Override
    public Iterator<MetadataEntry> iterator() {
        this.ensureDataRead();
        ArrayList<MetadataEntry> entries = new ArrayList<MetadataEntry>();
        for (String comment : this.comments) {
            entries.add(new MetadataEntry(comment, ""));
        }
        return Collections.unmodifiableCollection(entries).iterator();
    }

    @Override
    public void read() throws IOException {
        if (this.queue.size() > 0) {
            for (byte[] comment : this.queue) {
                try {
                    this.comments.add(new String(comment, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new UnsupportedEncodingException("UTF-8");
                }
            }
            this.queue.clear();
        }
    }
}

