/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.meta.image;

import guilibshadow.cafe4j.image.meta.Metadata;
import guilibshadow.cafe4j.image.meta.MetadataEntry;
import guilibshadow.cafe4j.image.meta.MetadataType;
import guilibshadow.cafe4j.image.meta.Thumbnail;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public class ImageMetadata
extends Metadata {
    private Map<String, Thumbnail> thumbnails;
    private Collection<MetadataEntry> entries = new ArrayList<MetadataEntry>();

    public ImageMetadata() {
        super(MetadataType.IMAGE);
    }

    public ImageMetadata(Map<String, Thumbnail> thumbnails) {
        super(MetadataType.IMAGE);
        this.thumbnails = thumbnails;
    }

    public void addMetadataEntry(MetadataEntry entry) {
        this.entries.add(entry);
    }

    public void addMetadataEntries(Collection<MetadataEntry> entries) {
        entries.addAll(entries);
    }

    public boolean containsThumbnail() {
        return this.thumbnails != null && this.thumbnails.size() > 0;
    }

    public Map<String, Thumbnail> getThumbnails() {
        return this.thumbnails;
    }

    @Override
    public void read() throws IOException {
        if (!this.isDataRead) {
            this.isDataRead = true;
        }
    }

    @Override
    public Iterator<MetadataEntry> iterator() {
        if (this.containsThumbnail()) {
            Iterator<Map.Entry<String, Thumbnail>> mapEntries = this.thumbnails.entrySet().iterator();
            this.entries.add(new MetadataEntry("Total number of thumbnails", "" + this.thumbnails.size()));
            int i = 0;
            while (mapEntries.hasNext()) {
                Map.Entry<String, Thumbnail> entry = mapEntries.next();
                MetadataEntry e = new MetadataEntry("Thumbnail " + i, entry.getKey(), true);
                Thumbnail thumbnail = entry.getValue();
                e.addEntry(new MetadataEntry("Thumbnail width", thumbnail.getWidth() < 0 ? " Unavailable" : "" + thumbnail.getWidth()));
                e.addEntry(new MetadataEntry("Thumbnail height", thumbnail.getHeight() < 0 ? " Unavailable" : "" + thumbnail.getHeight()));
                e.addEntry(new MetadataEntry("Thumbnail data type", thumbnail.getDataTypeAsString()));
                this.entries.add(e);
                ++i;
            }
        }
        return Collections.unmodifiableCollection(this.entries).iterator();
    }
}

