/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.meta.iptc;

import guilibshadow.cafe4j.image.meta.Metadata;
import guilibshadow.cafe4j.image.meta.MetadataEntry;
import guilibshadow.cafe4j.image.meta.MetadataType;
import guilibshadow.cafe4j.image.meta.iptc.IPTCDataSet;
import guilibshadow.cafe4j.image.meta.iptc.IPTCTag;
import guilibshadow.cafe4j.image.meta.iptc.IPTCTagComparator;
import guilibshadow.cafe4j.io.IOUtils;
import guilibshadow.org.slf4j.Logger;
import guilibshadow.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class IPTC
extends Metadata {
    private static final Logger LOGGER = LoggerFactory.getLogger(IPTC.class);
    private Map<IPTCTag, List<IPTCDataSet>> datasetMap;

    public static void showIPTC(byte[] data) {
        if (data != null && data.length > 0) {
            IPTC iptc = new IPTC(data);
            try {
                iptc.read();
                for (MetadataEntry item : iptc) {
                    LOGGER.info(item.getKey() + ": " + item.getValue());
                    if (!item.isMetadataEntryGroup()) continue;
                    String indent = "    ";
                    Collection<MetadataEntry> entries = item.getMetadataEntries();
                    for (MetadataEntry e : entries) {
                        LOGGER.info(indent + e.getKey() + ": " + e.getValue());
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void showIPTC(InputStream is) {
        try {
            IPTC.showIPTC(IOUtils.inputStreamToByteArray(is));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public IPTC() {
        super(MetadataType.IPTC);
        this.datasetMap = new TreeMap<IPTCTag, List<IPTCDataSet>>(new IPTCTagComparator());
        this.isDataRead = true;
    }

    public IPTC(byte[] data) {
        super(MetadataType.IPTC, data);
        this.ensureDataRead();
    }

    public void addDataSet(IPTCDataSet dataSet) {
        if (this.datasetMap != null) {
            IPTCTag tag = dataSet.getTagEnum();
            if (this.datasetMap.get(tag) == null) {
                ArrayList<IPTCDataSet> list = new ArrayList<IPTCDataSet>();
                list.add(dataSet);
                this.datasetMap.put(tag, list);
            } else if (dataSet.allowMultiple()) {
                this.datasetMap.get(tag).add(dataSet);
            }
        } else {
            throw new IllegalStateException("DataSet Map is empty");
        }
    }

    public void addDataSets(Collection<? extends IPTCDataSet> dataSets) {
        if (this.datasetMap != null) {
            for (IPTCDataSet iPTCDataSet : dataSets) {
                IPTCTag tag = iPTCDataSet.getTagEnum();
                if (this.datasetMap.get(tag) == null) {
                    ArrayList<IPTCDataSet> list = new ArrayList<IPTCDataSet>();
                    list.add(iPTCDataSet);
                    this.datasetMap.put(tag, list);
                    continue;
                }
                if (!iPTCDataSet.allowMultiple()) continue;
                this.datasetMap.get(tag).add(iPTCDataSet);
            }
        } else {
            throw new IllegalStateException("DataSet Map is empty");
        }
    }

    public String getAsString(IPTCTag key) {
        List<IPTCDataSet> list = this.getDataSet(key);
        String value = "";
        if (list != null) {
            if (list.size() == 1) {
                value = list.get(0).getDataAsString();
            } else {
                for (int i = 0; i < list.size() - 1; ++i) {
                    value = value + list.get(i).getDataAsString() + ";";
                }
                value = value + list.get(list.size() - 1).getDataAsString();
            }
        }
        return value;
    }

    public List<IPTCDataSet> getDataSet(IPTCTag key) {
        return this.getDataSets().get(key);
    }

    public Map<IPTCTag, List<IPTCDataSet>> getDataSets() {
        this.ensureDataRead();
        return this.datasetMap;
    }

    @Override
    public Iterator<MetadataEntry> iterator() {
        this.ensureDataRead();
        if (this.datasetMap != null) {
            Set<Map.Entry<IPTCTag, List<IPTCDataSet>>> entries = this.datasetMap.entrySet();
            final Iterator<Map.Entry<IPTCTag, List<IPTCDataSet>>> iter = entries.iterator();
            return new Iterator<MetadataEntry>(){

                @Override
                public MetadataEntry next() {
                    Map.Entry entry = (Map.Entry)iter.next();
                    String key = ((IPTCTag)entry.getKey()).getName();
                    String value = "";
                    for (IPTCDataSet item : (List)entry.getValue()) {
                        value = value + ";" + item.getDataAsString();
                    }
                    return new MetadataEntry(key, value.replaceFirst(";", ""));
                }

                @Override
                public boolean hasNext() {
                    return iter.hasNext();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Removing MetadataEntry is not supported by this Iterator");
                }
            };
        }
        return Collections.emptyIterator();
    }

    @Override
    public void read() throws IOException {
        if (!this.isDataRead) {
            int i = 0;
            byte tagMarker = this.data[i];
            this.datasetMap = new TreeMap<IPTCTag, List<IPTCDataSet>>(new IPTCTagComparator());
            while (tagMarker == 28) {
                int n = ++i;
                int recordNumber = this.data[n] & 0xFF;
                int n2 = ++i;
                int tag = this.data[n2] & 0xFF;
                int recordSize = IOUtils.readUnsignedShortMM(this.data, ++i);
                i += 2;
                if (recordSize > 0) {
                    IPTCDataSet dataSet = new IPTCDataSet(recordNumber, tag, recordSize, this.data, i);
                    IPTCTag tagEnum = dataSet.getTagEnum();
                    if (this.datasetMap.get(tagEnum) == null) {
                        ArrayList<IPTCDataSet> list = new ArrayList<IPTCDataSet>();
                        list.add(dataSet);
                        this.datasetMap.put(tagEnum, list);
                    } else {
                        this.datasetMap.get(tagEnum).add(dataSet);
                    }
                }
                if ((i += recordSize) >= this.data.length) break;
                tagMarker = this.data[i];
            }
            for (Map.Entry<IPTCTag, List<IPTCDataSet>> entry : this.datasetMap.entrySet()) {
                entry.setValue(new ArrayList(new LinkedHashSet(entry.getValue())));
            }
            this.isDataRead = true;
        }
    }

    @Override
    public void write(OutputStream os) throws IOException {
        for (List<IPTCDataSet> datasets : this.getDataSets().values()) {
            for (IPTCDataSet dataset : datasets) {
                dataset.write(os);
            }
        }
    }
}

