/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.meta.iptc;

import guilibshadow.cafe4j.image.meta.iptc.IPTCApplicationTag;
import guilibshadow.cafe4j.image.meta.iptc.IPTCEnvelopeTag;
import guilibshadow.cafe4j.image.meta.iptc.IPTCFotoStationTag;
import guilibshadow.cafe4j.image.meta.iptc.IPTCNewsPhotoTag;
import guilibshadow.cafe4j.image.meta.iptc.IPTCObjectDataTag;
import guilibshadow.cafe4j.image.meta.iptc.IPTCPostObjectDataTag;
import guilibshadow.cafe4j.image.meta.iptc.IPTCPreObjectDataTag;
import guilibshadow.cafe4j.image.meta.iptc.IPTCRecord;
import guilibshadow.cafe4j.image.meta.iptc.IPTCTag;
import guilibshadow.cafe4j.io.IOUtils;
import guilibshadow.cafe4j.util.ArrayUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class IPTCDataSet
implements Comparable<IPTCDataSet> {
    private int recordNumber;
    private int tag;
    private int size;
    private byte[] data;
    private int offset;
    private IPTCTag tagEnum;
    private String name;

    private static final byte[] getBytes(String str) {
        try {
            return str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported encoding UTF-8");
        }
    }

    public IPTCDataSet(int tag, byte[] data) {
        this(IPTCRecord.APPLICATION, tag, data);
    }

    public IPTCDataSet(int recordNumber, int tag, int size, byte[] data, int offset) {
        this.recordNumber = recordNumber;
        this.tag = tag;
        this.size = size;
        this.data = data;
        this.offset = offset;
        this.name = this.getTagName();
    }

    public IPTCDataSet(int tag, String value) {
        this(tag, IPTCDataSet.getBytes(value));
    }

    public IPTCDataSet(IPTCApplicationTag appTag, byte[] data) {
        this(appTag.getTag(), data);
    }

    public IPTCDataSet(IPTCApplicationTag appTag, String value) {
        this(appTag.getTag(), value);
    }

    public IPTCDataSet(IPTCRecord record, int tag, byte[] data) {
        this(record.getRecordNumber(), tag, data.length, data, 0);
    }

    public IPTCDataSet(IPTCRecord record, int tag, String value) {
        this(record, tag, IPTCDataSet.getBytes(value));
    }

    public boolean allowMultiple() {
        return this.tagEnum.allowMultiple();
    }

    @Override
    public int compareTo(IPTCDataSet other) {
        int BEFORE = -1;
        boolean EQUAL = false;
        boolean AFTER = true;
        if (this == other) {
            return 0;
        }
        if (this.getRecordNumber() < other.getRecordNumber()) {
            return -1;
        }
        if (this.getRecordNumber() > other.getRecordNumber()) {
            return 1;
        }
        if (this.getRecordNumber() == other.getRecordNumber()) {
            if (this.getTag() < other.getTag()) {
                return -1;
            }
            if (this.getTag() > other.getTag()) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        byte[] thatData;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IPTCDataSet other = (IPTCDataSet)obj;
        byte[] thisData = ArrayUtils.subArray(this.data, this.offset, this.size);
        if (!Arrays.equals(thisData, thatData = ArrayUtils.subArray(other.data, other.offset, other.size))) {
            return false;
        }
        if (this.recordNumber != other.recordNumber) {
            return false;
        }
        return this.tag == other.tag;
    }

    public byte[] getData() {
        return ArrayUtils.subArray(this.data, this.offset, this.size);
    }

    public String getDataAsString() {
        return this.tagEnum.getDataAsString(this.getData());
    }

    public String getName() {
        return this.name;
    }

    public String getRecordType() {
        switch (this.recordNumber) {
            case 1: {
                return "Envelope Record";
            }
            case 2: {
                return "Application Record";
            }
            case 3: {
                return "NewsPhoto Record";
            }
            case 7: {
                return "PreObjectData Record";
            }
            case 8: {
                return "ObjectData Record";
            }
            case 9: {
                return "PostObjectData Record";
            }
            case 240: {
                return "FotoStation Record";
            }
        }
        return "Unknown Record";
    }

    public int getRecordNumber() {
        return this.recordNumber;
    }

    public int getSize() {
        return this.size;
    }

    public int getTag() {
        return this.tag;
    }

    public IPTCTag getTagEnum() {
        return this.tagEnum;
    }

    private String getTagName() {
        block0 : switch (IPTCRecord.fromRecordNumber(this.recordNumber)) {
            case APPLICATION: {
                this.tagEnum = IPTCApplicationTag.fromTag(this.tag);
                break;
            }
            case ENVELOP: {
                this.tagEnum = IPTCEnvelopeTag.fromTag(this.tag);
                break;
            }
            case FOTOSTATION: {
                this.tagEnum = IPTCFotoStationTag.fromTag(this.tag);
                break;
            }
            case NEWSPHOTO: {
                this.tagEnum = IPTCNewsPhotoTag.fromTag(this.tag);
                break;
            }
            case OBJECTDATA: {
                this.tagEnum = IPTCObjectDataTag.fromTag(this.tag);
                break;
            }
            case POST_OBJECTDATA: {
                this.tagEnum = IPTCPostObjectDataTag.fromTag(this.tag);
                break;
            }
            case PRE_OBJECTDATA: {
                this.tagEnum = IPTCPreObjectDataTag.fromTag(this.tag);
                break;
            }
            case UNKNOWN: {
                switch (IPTCRecord.fromRecordNumber(this.recordNumber)) {
                    case APPLICATION: {
                        this.tagEnum = IPTCApplicationTag.UNKNOWN;
                        break block0;
                    }
                    case ENVELOP: {
                        this.tagEnum = IPTCEnvelopeTag.UNKNOWN;
                        break block0;
                    }
                    case NEWSPHOTO: {
                        this.tagEnum = IPTCNewsPhotoTag.UNKNOWN;
                        break block0;
                    }
                    case PRE_OBJECTDATA: {
                        this.tagEnum = IPTCPreObjectDataTag.UNKNOWN;
                        break block0;
                    }
                    case OBJECTDATA: {
                        this.tagEnum = IPTCObjectDataTag.UNKNOWN;
                        break block0;
                    }
                    case POST_OBJECTDATA: {
                        this.tagEnum = IPTCPostObjectDataTag.UNKNOWN;
                        break block0;
                    }
                    case FOTOSTATION: {
                        this.tagEnum = IPTCFotoStationTag.UNKNOWN;
                        break block0;
                    }
                    case UNKNOWN: {
                        throw new RuntimeException("Unknown IPTC record");
                    }
                }
            }
        }
        return this.tagEnum.getName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(ArrayUtils.subArray(this.data, this.offset, this.size));
        result = 31 * result + this.recordNumber;
        result = 31 * result + this.tag;
        return result;
    }

    public void write(OutputStream out) throws IOException {
        out.write(28);
        out.write(this.recordNumber);
        out.write(this.getTag());
        IOUtils.writeShortMM(out, this.size);
        out.write(this.data, this.offset, this.size);
    }
}

