/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.meta.iptc;

import guilibshadow.cafe4j.image.meta.iptc.IPTCRecord;
import guilibshadow.cafe4j.image.meta.iptc.IPTCTag;
import guilibshadow.cafe4j.string.StringUtils;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public enum IPTCEnvelopeTag implements IPTCTag
{
    RECORD_VERSION(0, "Envelope Record Version"),
    DESTINATION(5, "Destination"){

        @Override
        public boolean allowMultiple() {
            return true;
        }
    }
    ,
    FILE_FORMAT(20, "File Format"),
    FILE_VERSION(22, "File Version"),
    SERVICE_IDENTIFIER(30, "ServiceIdentifier"),
    ENVELOPE_NUMBER(40, "Envelope Number"),
    PRODUCT_ID(50, "Product ID"){

        @Override
        public boolean allowMultiple() {
            return true;
        }
    }
    ,
    ENVELOPE_PRIORITY(60, "Envelope Priority"),
    DATE_SENT(70, "Date Sent"),
    TIME_SENT(80, "Time Sent"),
    CODED_CHARACTER_SET(90, "Coded Character Set"),
    UNIQUE_OBJECT_NAME(100, "Unique Object Name"),
    ARM_IDENTIFIER(120, "ARM Identifier"),
    ARM_VERSION(122, "ARM Version"),
    UNKNOWN(999, "Unknown IPTCEnvelopeTag");

    private static final Map<Integer, IPTCEnvelopeTag> recordMap;
    private final int tag;
    private final String name;

    private IPTCEnvelopeTag(int tag, String name) {
        this.tag = tag;
        this.name = name;
    }

    @Override
    public boolean allowMultiple() {
        return false;
    }

    @Override
    public String getDataAsString(byte[] data) {
        try {
            String strVal = new String(data, "UTF-8").trim();
            if (strVal.length() > 0) {
                return strVal;
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return StringUtils.byteArrayToHexString(data, 0, 10);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getRecordNumber() {
        return IPTCRecord.ENVELOP.getRecordNumber();
    }

    @Override
    public int getTag() {
        return this.tag;
    }

    public static IPTCEnvelopeTag fromTag(int value) {
        IPTCEnvelopeTag record = recordMap.get(value);
        if (record == null) {
            return UNKNOWN;
        }
        return record;
    }

    public String toString() {
        return this.name;
    }

    static {
        recordMap = new HashMap<Integer, IPTCEnvelopeTag>();
        for (IPTCEnvelopeTag record : IPTCEnvelopeTag.values()) {
            recordMap.put(record.getTag(), record);
        }
    }
}

