/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.meta.iptc;

import guilibshadow.cafe4j.image.meta.iptc.IPTCRecord;
import guilibshadow.cafe4j.image.meta.iptc.IPTCTag;
import guilibshadow.cafe4j.string.StringUtils;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public enum IPTCPostObjectDataTag implements IPTCTag
{
    CONFIRMED_OBJECT_SIZE(10, "ConfirmedObjectSize"),
    UNKNOWN(999, "Unknown IPTCPostObjectDataTag");

    private static final Map<Integer, IPTCPostObjectDataTag> recordMap;
    private final int tag;
    private final String name;

    private IPTCPostObjectDataTag(int tag, String name) {
        this.tag = tag;
        this.name = name;
    }

    @Override
    public boolean allowMultiple() {
        return false;
    }

    @Override
    public String getDataAsString(byte[] data) {
        try {
            String strVal = new String(data, "UTF-8").trim();
            if (strVal.length() > 0) {
                return strVal;
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return StringUtils.byteArrayToHexString(data, 0, 10);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getRecordNumber() {
        return IPTCRecord.POST_OBJECTDATA.getRecordNumber();
    }

    @Override
    public int getTag() {
        return this.tag;
    }

    public static IPTCPostObjectDataTag fromTag(int value) {
        IPTCPostObjectDataTag record = recordMap.get(value);
        if (record == null) {
            return UNKNOWN;
        }
        return record;
    }

    public String toString() {
        return this.name;
    }

    static {
        recordMap = new HashMap<Integer, IPTCPostObjectDataTag>();
        for (IPTCPostObjectDataTag record : IPTCPostObjectDataTag.values()) {
            recordMap.put(record.getTag(), record);
        }
    }
}

