/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.meta.iptc;

import guilibshadow.cafe4j.image.meta.iptc.IPTCRecord;
import guilibshadow.cafe4j.image.meta.iptc.IPTCTag;
import guilibshadow.cafe4j.string.StringUtils;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public enum IPTCPreObjectDataTag implements IPTCTag
{
    SIZE_MODE(10, "Size Mode"),
    MAX_SUBFILE_SIZE(20, "Max Subfile Size"),
    OBJECT_SIZE_ANNOUNCED(90, "Object Size Announced"),
    MAXIMUM_OBJECT_SIZE(95, "Maximum Object Size"),
    UNKNOWN(999, "Unknown IPTCPreObjectDataTag");

    private static final Map<Integer, IPTCPreObjectDataTag> recordMap;
    private final int tag;
    private final String name;

    private IPTCPreObjectDataTag(int tag, String name) {
        this.tag = tag;
        this.name = name;
    }

    @Override
    public boolean allowMultiple() {
        return false;
    }

    @Override
    public String getDataAsString(byte[] data) {
        try {
            String strVal = new String(data, "UTF-8").trim();
            if (strVal.length() > 0) {
                return strVal;
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return StringUtils.byteArrayToHexString(data, 0, 10);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getRecordNumber() {
        return IPTCRecord.PRE_OBJECTDATA.getRecordNumber();
    }

    @Override
    public int getTag() {
        return this.tag;
    }

    public static IPTCPreObjectDataTag fromTag(int value) {
        IPTCPreObjectDataTag record = recordMap.get(value);
        if (record == null) {
            return UNKNOWN;
        }
        return record;
    }

    public String toString() {
        return this.name;
    }

    static {
        recordMap = new HashMap<Integer, IPTCPreObjectDataTag>();
        for (IPTCPreObjectDataTag record : IPTCPreObjectDataTag.values()) {
            recordMap.put(record.getTag(), record);
        }
    }
}

