/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.meta.iptc;

import java.util.HashMap;
import java.util.Map;

public enum IPTCRecord {
    ENVELOP(1, "Envelop"),
    APPLICATION(2, "Application"),
    NEWSPHOTO(3, "NewsPhoto"),
    PRE_OBJECTDATA(7, "PreObjectData"),
    OBJECTDATA(8, "ObjectData"),
    POST_OBJECTDATA(9, "PostObjectData"),
    FOTOSTATION(240, "FotoStation"),
    UNKNOWN(999, "Unknown IPTC Record");

    private static final Map<Integer, IPTCRecord> recordMap;
    private final int recordNumber;
    private final String name;

    private IPTCRecord(int recordNumber, String name) {
        this.recordNumber = recordNumber;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getRecordNumber() {
        return this.recordNumber;
    }

    public String toString() {
        return this.name;
    }

    public static IPTCRecord fromRecordNumber(int value) {
        IPTCRecord record = recordMap.get(value);
        if (record == null) {
            return UNKNOWN;
        }
        return record;
    }

    static {
        recordMap = new HashMap<Integer, IPTCRecord>();
        for (IPTCRecord record : IPTCRecord.values()) {
            recordMap.put(record.getRecordNumber(), record);
        }
    }
}

