/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.meta.jpeg;

import guilibshadow.cafe4j.image.meta.Metadata;
import guilibshadow.cafe4j.image.meta.MetadataEntry;
import guilibshadow.cafe4j.image.meta.MetadataType;
import guilibshadow.cafe4j.io.IOUtils;
import guilibshadow.cafe4j.string.StringUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class Adobe
extends Metadata {
    private int m_DCTEncodeVersion;
    private int m_APP14Flags0;
    private int m_APP14Flags1;
    private int m_ColorTransform;

    public Adobe(byte[] data) {
        super(MetadataType.JPG_ADOBE, data);
        this.ensureDataRead();
    }

    public Adobe(int dctEncodeVersion, int app14Flags0, int app14Flags1, int colorTransform) {
        super(MetadataType.JPG_ADOBE);
        this.m_DCTEncodeVersion = dctEncodeVersion;
        this.m_APP14Flags0 = app14Flags0;
        this.m_APP14Flags1 = app14Flags1;
        this.m_ColorTransform = colorTransform;
        this.isDataRead = true;
    }

    public int getAPP14Flags0() {
        return this.m_APP14Flags0;
    }

    public int getAPP14Flags1() {
        return this.m_APP14Flags1;
    }

    public int getColorTransform() {
        return this.m_ColorTransform;
    }

    public int getDCTEncodeVersion() {
        return this.m_DCTEncodeVersion;
    }

    @Override
    public Iterator<MetadataEntry> iterator() {
        this.ensureDataRead();
        ArrayList<MetadataEntry> entries = new ArrayList<MetadataEntry>();
        String[] colorTransform = new String[]{"Unknown (RGB or CMYK)", "YCbCr", "YCCK"};
        entries.add(new MetadataEntry("DCTEncodeVersion", this.m_DCTEncodeVersion + ""));
        entries.add(new MetadataEntry("APP14Flags0", StringUtils.shortToHexStringMM((short)this.m_APP14Flags0)));
        entries.add(new MetadataEntry("APP14Flags1", StringUtils.shortToHexStringMM((short)this.m_APP14Flags1)));
        entries.add(new MetadataEntry("ColorTransform", this.m_ColorTransform <= 2 ? colorTransform[this.m_ColorTransform] : this.m_ColorTransform + ""));
        return Collections.unmodifiableCollection(entries).iterator();
    }

    @Override
    public void read() throws IOException {
        if (!this.isDataRead) {
            int expectedLen = 7;
            int offset = 0;
            if (this.data.length >= expectedLen) {
                this.m_DCTEncodeVersion = IOUtils.readUnsignedShortMM(this.data, offset);
                this.m_APP14Flags0 = IOUtils.readUnsignedShortMM(this.data, offset += 2);
                this.m_APP14Flags1 = IOUtils.readUnsignedShortMM(this.data, offset += 2);
                this.m_ColorTransform = this.data[offset += 2] & 0xFF;
            }
            this.isDataRead = true;
        }
    }

    @Override
    public void write(OutputStream os) throws IOException {
        this.ensureDataRead();
        IOUtils.writeShortMM(os, this.getDCTEncodeVersion());
        IOUtils.writeShortMM(os, this.getAPP14Flags0());
        IOUtils.writeShortMM(os, this.getAPP14Flags1());
        IOUtils.write(os, this.getColorTransform());
    }
}

