/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.meta.jpeg;

import guilibshadow.cafe4j.image.meta.Metadata;
import guilibshadow.cafe4j.image.meta.MetadataEntry;
import guilibshadow.cafe4j.image.meta.MetadataType;
import guilibshadow.cafe4j.image.meta.jpeg.DuckyDataSet;
import guilibshadow.cafe4j.image.meta.jpeg.DuckyTag;
import guilibshadow.cafe4j.io.IOUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;

public class Ducky
extends Metadata {
    private Map<DuckyTag, DuckyDataSet> datasetMap;

    public Ducky() {
        super(MetadataType.JPG_DUCKY);
        this.datasetMap = new EnumMap<DuckyTag, DuckyDataSet>(DuckyTag.class);
        this.isDataRead = true;
    }

    public Ducky(byte[] data) {
        super(MetadataType.JPG_DUCKY, data);
        this.ensureDataRead();
    }

    public void addDataSet(DuckyDataSet dataSet) {
        if (this.datasetMap != null) {
            this.datasetMap.put(DuckyTag.fromTag(dataSet.getTag()), dataSet);
        }
    }

    public void addDataSets(Collection<? extends DuckyDataSet> dataSets) {
        if (this.datasetMap != null) {
            for (DuckyDataSet duckyDataSet : dataSets) {
                this.datasetMap.put(DuckyTag.fromTag(duckyDataSet.getTag()), duckyDataSet);
            }
        }
    }

    public Map<DuckyTag, DuckyDataSet> getDataSets() {
        this.ensureDataRead();
        return Collections.unmodifiableMap(this.datasetMap);
    }

    @Override
    public Iterator<MetadataEntry> iterator() {
        this.ensureDataRead();
        ArrayList<MetadataEntry> entries = new ArrayList<MetadataEntry>();
        for (DuckyDataSet dataset : this.datasetMap.values()) {
            entries.add(dataset.getMetadataEntry());
        }
        return Collections.unmodifiableCollection(entries).iterator();
    }

    @Override
    public void read() throws IOException {
        if (!this.isDataRead) {
            int i = 0;
            this.datasetMap = new EnumMap<DuckyTag, DuckyDataSet>(DuckyTag.class);
            while (i + 4 <= this.data.length) {
                int tag = IOUtils.readUnsignedShortMM(this.data, i);
                int size = IOUtils.readUnsignedShortMM(this.data, i += 2);
                DuckyTag etag = DuckyTag.fromTag(tag);
                this.datasetMap.put(etag, new DuckyDataSet(tag, size, this.data, i += 2));
                i += size;
            }
            this.isDataRead = true;
        }
    }

    @Override
    public void write(OutputStream os) throws IOException {
        this.ensureDataRead();
        for (DuckyDataSet dataset : this.getDataSets().values()) {
            dataset.write(os);
        }
    }
}

