/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.meta.jpeg;

import guilibshadow.cafe4j.image.meta.MetadataEntry;
import guilibshadow.cafe4j.image.meta.jpeg.DuckyTag;
import guilibshadow.cafe4j.io.IOUtils;
import guilibshadow.cafe4j.util.ArrayUtils;
import guilibshadow.org.slf4j.Logger;
import guilibshadow.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class DuckyDataSet {
    private int tag;
    private int size;
    private byte[] data;
    private int offset;
    private static final Logger LOGGER = LoggerFactory.getLogger(DuckyDataSet.class);

    public DuckyDataSet(int tag, byte[] data) {
        this(tag, data.length, data, 0);
    }

    public DuckyDataSet(int tag, int size, byte[] data, int offset) {
        this.tag = tag;
        this.size = size;
        this.data = data;
        this.offset = offset;
    }

    public byte[] getData() {
        return ArrayUtils.subArray(this.data, this.offset, this.size);
    }

    public int getSize() {
        return this.size;
    }

    public int getTag() {
        return this.tag;
    }

    public MetadataEntry getMetadataEntry() {
        MetadataEntry entry = null;
        if (this.size < 4) {
            LOGGER.warn("Data set size {} is too small, should >= 4", (Object)this.size);
            return new MetadataEntry("Bad Ducky DataSet", "Data set size " + this.size + " is two small, should >= 4");
        }
        DuckyTag etag = DuckyTag.fromTag(this.tag);
        if (etag == DuckyTag.UNKNOWN) {
            entry = new MetadataEntry("Unknown tag", this.tag + "");
        } else if (etag == DuckyTag.QUALITY) {
            entry = new MetadataEntry(etag.getName(), IOUtils.readUnsignedIntMM(this.data, this.offset) + "");
        } else {
            String value = "";
            try {
                value = new String(this.data, this.offset + 4, this.size - 4, "UTF-16BE");
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("UnsupportedEncoding \"UTF-16BE\"");
            }
            entry = new MetadataEntry(etag.getName(), value);
        }
        return entry;
    }

    public void print() {
        if (this.size < 4) {
            LOGGER.warn("Data set size {} is too small, should >= 4", (Object)this.size);
            return;
        }
        DuckyTag etag = DuckyTag.fromTag(this.tag);
        if (etag == DuckyTag.UNKNOWN) {
            LOGGER.info("Unknown tag: {}", (Object)this.tag);
        } else if (etag == DuckyTag.QUALITY) {
            LOGGER.info((Object)((Object)etag) + ": {}", (Object)IOUtils.readUnsignedIntMM(this.data, this.offset));
        } else {
            String value = "";
            try {
                value = new String(this.data, this.offset + 4, this.size - 4, "UTF-16BE");
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("UnsupportedEncoding \"UTF-16BE\"");
            }
            LOGGER.info((Object)((Object)etag) + ": {}", (Object)value);
        }
    }

    public void write(OutputStream out) throws IOException {
        IOUtils.writeShortMM(out, this.tag);
        IOUtils.writeShortMM(out, this.size);
        out.write(this.data, this.offset, this.size);
    }
}

