/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.meta.jpeg;

import guilibshadow.cafe4j.image.meta.Metadata;
import guilibshadow.cafe4j.image.meta.MetadataEntry;
import guilibshadow.cafe4j.image.meta.MetadataType;
import guilibshadow.cafe4j.image.meta.jpeg.JFIFThumbnail;
import guilibshadow.cafe4j.io.IOUtils;
import guilibshadow.cafe4j.util.ArrayUtils;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class JFIF
extends Metadata {
    private int majorVersion;
    private int minorVersion;
    private int densityUnit;
    private int xDensity;
    private int yDensity;
    private int thumbnailWidth;
    private int thumbnailHeight;
    private boolean containsThumbnail;
    private JFIFThumbnail thumbnail;

    private static void checkInput(int majorVersion, int minorVersion, int densityUnit, int xDensity, int yDensity) {
        if (majorVersion < 0 || majorVersion > 255) {
            throw new IllegalArgumentException("Invalid major version number: " + majorVersion);
        }
        if (minorVersion < 0 || minorVersion > 255) {
            throw new IllegalArgumentException("Invalid minor version number: " + minorVersion);
        }
        if (densityUnit < 0 || densityUnit > 2) {
            throw new IllegalArgumentException("Density unit value " + densityUnit + " out of range [0-2]");
        }
        if (xDensity < 0 || xDensity > 65535) {
            throw new IllegalArgumentException("xDensity value " + xDensity + " out of range (0-0xffff]");
        }
        if (yDensity < 0 || yDensity > 65535) {
            throw new IllegalArgumentException("yDensity value " + xDensity + " out of range (0-0xffff]");
        }
    }

    public JFIF(byte[] data) {
        super(MetadataType.JPG_JFIF, data);
        this.ensureDataRead();
    }

    public JFIF(int majorVersion, int minorVersion, int densityUnit, int xDensity, int yDensity) {
        this(majorVersion, minorVersion, densityUnit, xDensity, yDensity, null);
    }

    public JFIF(int majorVersion, int minorVersion, int densityUnit, int xDensity, int yDensity, JFIFThumbnail thumbnail) {
        super(MetadataType.JPG_JFIF);
        JFIF.checkInput(majorVersion, minorVersion, densityUnit, xDensity, yDensity);
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.densityUnit = densityUnit;
        this.xDensity = xDensity;
        this.yDensity = yDensity;
        if (thumbnail != null) {
            int thumbnailWidth = thumbnail.getWidth();
            int thumbnailHeight = thumbnail.getHeight();
            if (thumbnailWidth < 0 || thumbnailWidth > 255) {
                throw new IllegalArgumentException("Thumbnail width " + thumbnailWidth + " out of range (0-0xff]");
            }
            if (thumbnailHeight < 0 || thumbnailHeight > 255) {
                throw new IllegalArgumentException("Thumbnail height " + thumbnailHeight + " out of range (0-0xff]");
            }
            this.thumbnailWidth = thumbnailWidth;
            this.thumbnailHeight = thumbnailHeight;
            this.thumbnail = thumbnail;
            this.containsThumbnail = true;
        }
        this.isDataRead = true;
    }

    public boolean containsThumbnail() {
        return this.containsThumbnail;
    }

    public int getDensityUnit() {
        return this.densityUnit;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public JFIFThumbnail getThumbnail() {
        return new JFIFThumbnail(this.thumbnail);
    }

    public int getThumbnailHeight() {
        return this.thumbnailHeight;
    }

    public int getThumbnailWidth() {
        return this.thumbnailWidth;
    }

    public int getXDensity() {
        return this.xDensity;
    }

    public int getYDensity() {
        return this.yDensity;
    }

    @Override
    public Iterator<MetadataEntry> iterator() {
        this.ensureDataRead();
        ArrayList<MetadataEntry> entries = new ArrayList<MetadataEntry>();
        String[] densityUnits = new String[]{"No units, aspect ratio only specified", "Dots per inch", "Dots per centimeter"};
        entries.add(new MetadataEntry("Version", this.majorVersion + "." + this.minorVersion));
        entries.add(new MetadataEntry("Density unit", this.densityUnit <= 2 ? densityUnits[this.densityUnit] : this.densityUnit + ""));
        entries.add(new MetadataEntry("XDensity", this.xDensity + ""));
        entries.add(new MetadataEntry("YDensity", this.yDensity + ""));
        entries.add(new MetadataEntry("Thumbnail width", this.thumbnailWidth + ""));
        entries.add(new MetadataEntry("Thumbnail height", this.thumbnailHeight + ""));
        return Collections.unmodifiableCollection(entries).iterator();
    }

    @Override
    public void read() throws IOException {
        if (!this.isDataRead) {
            int expectedLen = 9;
            int offset = 0;
            if (this.data.length >= expectedLen) {
                this.majorVersion = this.data[offset++] & 0xFF;
                this.minorVersion = this.data[offset++] & 0xFF;
                this.densityUnit = this.data[offset++] & 0xFF;
                this.xDensity = IOUtils.readUnsignedShortMM(this.data, offset);
                this.yDensity = IOUtils.readUnsignedShortMM(this.data, offset += 2);
                offset += 2;
                this.thumbnailWidth = this.data[offset++] & 0xFF;
                this.thumbnailHeight = this.data[offset] & 0xFF;
                if (this.thumbnailWidth != 0 && this.thumbnailHeight != 0) {
                    this.containsThumbnail = true;
                    int size = 3 * this.thumbnailWidth * this.thumbnailHeight;
                    DataBufferByte db = new DataBufferByte(ArrayUtils.subArray(this.data, expectedLen, size), size);
                    int[] off = new int[]{0, 1, 2};
                    int numOfBands = 3;
                    WritableRaster raster = Raster.createInterleavedRaster(db, this.thumbnailWidth, this.thumbnailHeight, 3 * this.thumbnailWidth, numOfBands, off, null);
                    ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1000), false, false, 1, 0);
                    this.thumbnail = new JFIFThumbnail(new BufferedImage(cm, raster, false, null));
                }
            }
            this.isDataRead = true;
        }
    }

    @Override
    public void write(OutputStream os) throws IOException {
        this.ensureDataRead();
        IOUtils.write(os, this.majorVersion);
        IOUtils.write(os, this.minorVersion);
        IOUtils.write(os, this.densityUnit);
        IOUtils.writeShortMM(os, this.getXDensity());
        IOUtils.writeShortMM(os, this.getYDensity());
        IOUtils.write(os, this.thumbnailWidth);
        IOUtils.write(os, this.thumbnailHeight);
        if (this.containsThumbnail) {
            this.thumbnail.write(os);
        }
    }
}

