/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.meta.jpeg;

import guilibshadow.cafe4j.image.jpeg.Marker;
import guilibshadow.cafe4j.image.meta.exif.Exif;
import guilibshadow.cafe4j.image.tiff.ASCIIField;
import guilibshadow.cafe4j.image.tiff.IFD;
import guilibshadow.cafe4j.image.tiff.LongField;
import guilibshadow.cafe4j.image.tiff.TiffTag;
import guilibshadow.cafe4j.io.IOUtils;
import guilibshadow.cafe4j.io.MemoryCacheRandomAccessOutputStream;
import guilibshadow.cafe4j.io.RandomAccessOutputStream;
import guilibshadow.cafe4j.io.WriteStrategyMM;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class JpegExif
extends Exif {
    public JpegExif() {
    }

    public JpegExif(byte[] data) {
        super(data);
    }

    private void createImageIFD() {
        this.imageIFD = new IFD();
        ASCIIField tiffField = new ASCIIField(TiffTag.IMAGE_DESCRIPTION.getValue(), "Exif created by JPGTweaker");
        this.imageIFD.addField(tiffField);
        String softWare = "JPGTweaker 1.0";
        tiffField = new ASCIIField(TiffTag.SOFTWARE.getValue(), softWare);
        this.imageIFD.addField(tiffField);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
        tiffField = new ASCIIField(TiffTag.DATETIME.getValue(), formatter.format(new Date()));
        this.imageIFD.addField(tiffField);
    }

    @Override
    public void write(OutputStream os) throws IOException {
        this.ensureDataRead();
        MemoryCacheRandomAccessOutputStream randOS = new MemoryCacheRandomAccessOutputStream(os);
        IOUtils.writeShortMM(os, Marker.APP1.getValue());
        int endian = 19789;
        int tiffID = 42;
        randOS.setWriteStrategy(WriteStrategyMM.getInstance());
        randOS.writeShort(endian);
        randOS.writeShort(tiffID);
        ((RandomAccessOutputStream)randOS).seek(4L);
        randOS.writeInt(8);
        ((RandomAccessOutputStream)randOS).seek(8L);
        if (this.imageIFD == null) {
            this.createImageIFD();
        }
        if (this.exifSubIFD != null) {
            this.imageIFD.addField(new LongField(TiffTag.EXIF_SUB_IFD.getValue(), new int[]{0}));
            this.imageIFD.addChild(TiffTag.EXIF_SUB_IFD, this.exifSubIFD);
        }
        if (this.gpsSubIFD != null) {
            this.imageIFD.addField(new LongField(TiffTag.GPS_SUB_IFD.getValue(), new int[]{0}));
            this.imageIFD.addChild(TiffTag.GPS_SUB_IFD, this.gpsSubIFD);
        }
        int offset = this.imageIFD.write(randOS, 8);
        if (this.thumbnail != null && this.thumbnail.containsImage()) {
            this.imageIFD.setNextIFDOffset(randOS, offset);
            ((RandomAccessOutputStream)randOS).seek(offset);
            this.thumbnail.write(randOS);
        }
        int length = (int)((RandomAccessOutputStream)randOS).getLength();
        IOUtils.writeShortMM(os, length + 8);
        byte[] exif = new byte[]{69, 120, 105, 102, 0, 0};
        IOUtils.write(os, exif);
        ((RandomAccessOutputStream)randOS).seek(0L);
        ((RandomAccessOutputStream)randOS).writeToStream(length);
        ((RandomAccessOutputStream)randOS).shallowClose();
    }
}

