/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.meta.jpeg;

import guilibshadow.cafe4j.image.jpeg.Marker;
import guilibshadow.cafe4j.image.meta.xmp.XMP;
import guilibshadow.cafe4j.io.IOUtils;
import guilibshadow.cafe4j.string.StringUtils;
import guilibshadow.cafe4j.string.XMLUtils;
import guilibshadow.cafe4j.util.ArrayUtils;
import java.io.IOException;
import java.io.OutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JpegXMP
extends XMP {
    private static final int MAX_EXTENDED_XMP_CHUNK_SIZE = 65458;
    private static final int MAX_XMP_CHUNK_SIZE = 65504;
    private static final int GUID_LEN = 32;

    public JpegXMP(byte[] data) {
        super(data);
    }

    public JpegXMP(String xmp) {
        super(xmp);
    }

    public JpegXMP(String xmp, String extendedXmp) {
        super(xmp, extendedXmp);
    }

    @Override
    public void write(OutputStream os) throws IOException {
        int i;
        byte[] xmp;
        Document xmpDoc = this.getXmpDocument();
        NodeList list = xmpDoc.getChildNodes();
        boolean foundPI = false;
        for (int j = 0; j < list.getLength(); ++j) {
            Node currentNode = list.item(j);
            if (currentNode.getNodeType() != 7 || !currentNode.getNodeName().equalsIgnoreCase("xpacket")) continue;
            foundPI = true;
            break;
        }
        if (!foundPI) {
            XMLUtils.insertLeadingPI(xmpDoc, "xpacket", "begin='?' id='W5M0MpCehiHzreSzNTczkc9d'");
            XMLUtils.insertTrailingPI(xmpDoc, "xpacket", "end='r'");
        }
        if ((xmp = XMLUtils.serializeToByteArray(xmpDoc)).length > 65504) {
            Document extendedXMPDoc = XMLUtils.createDocumentNode();
            Node xmpRDF = xmpDoc.getElementsByTagName("rdf:RDF").item(0);
            NodeList nodes = xmpRDF.getChildNodes();
            Element extendedRDF = extendedXMPDoc.createElement("rdf:RDF");
            extendedRDF.setAttribute("xmlns:rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
            extendedXMPDoc.appendChild(extendedRDF);
            for (int i2 = 0; i2 < nodes.getLength(); ++i2) {
                Node curr = extendedXMPDoc.importNode(nodes.item(i2), true);
                extendedRDF.appendChild(curr);
            }
            int numOfItems = nodes.getLength();
            for (i = 1; i <= numOfItems; ++i) {
                xmpRDF.removeChild(nodes.item(numOfItems - i));
            }
            xmp = XMLUtils.serializeToByteArray(xmpDoc);
            this.setExtendedXMPData(XMLUtils.serializeToByteArray(extendedXMPDoc));
        }
        String guid = null;
        byte[] extendedXmp = this.getExtendedXmpData();
        if (extendedXmp != null) {
            if (XMLUtils.getAttribute(xmpDoc, "rdf:Description", "xmpNote:HasExtendedXMP").length() == 0) {
                guid = StringUtils.generateMD5(extendedXmp);
                Element node = XMLUtils.createElement(xmpDoc, "rdf:Description");
                node.setAttribute("xmlns:xmpNote", "http://ns.adobe.com/xmp/extension/");
                node.setAttribute("xmpNote:HasExtendedXMP", guid);
                xmpDoc.getElementsByTagName("rdf:RDF").item(0).appendChild(node);
                xmp = XMLUtils.serializeToByteArray(xmpDoc);
            } else {
                guid = XMLUtils.getAttribute(xmpDoc, "rdf:Description", "xmpNote:HasExtendedXMP");
            }
        }
        IOUtils.writeShortMM(os, Marker.APP1.getValue());
        IOUtils.writeShortMM(os, "http://ns.adobe.com/xap/1.0/\u0000".length() + 2 + xmp.length);
        os.write("http://ns.adobe.com/xap/1.0/\u0000".getBytes());
        os.write(xmp);
        if (extendedXmp != null) {
            int numOfChunks = extendedXmp.length / 65458;
            int extendedXmpLen = extendedXmp.length;
            int offset = 0;
            for (i = 0; i < numOfChunks; ++i) {
                IOUtils.writeShortMM(os, Marker.APP1.getValue());
                IOUtils.writeShortMM(os, 2 + "http://ns.adobe.com/xmp/extension/\u0000".length() + 32 + 4 + 4 + 65458);
                os.write("http://ns.adobe.com/xmp/extension/\u0000".getBytes());
                os.write(guid.getBytes());
                IOUtils.writeIntMM(os, extendedXmpLen);
                IOUtils.writeIntMM(os, offset);
                os.write(ArrayUtils.subArray(extendedXmp, offset, 65458));
                offset += 65458;
            }
            int leftOver = extendedXmp.length % 65458;
            if (leftOver != 0) {
                IOUtils.writeShortMM(os, Marker.APP1.getValue());
                IOUtils.writeShortMM(os, 2 + "http://ns.adobe.com/xmp/extension/\u0000".length() + 32 + 4 + 4 + leftOver);
                os.write("http://ns.adobe.com/xmp/extension/\u0000".getBytes());
                os.write(guid.getBytes());
                IOUtils.writeIntMM(os, extendedXmpLen);
                IOUtils.writeIntMM(os, offset);
                os.write(ArrayUtils.subArray(extendedXmp, offset, leftOver));
            }
        }
    }
}

