/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.meta.png;

import guilibshadow.cafe4j.image.meta.Metadata;
import guilibshadow.cafe4j.image.meta.MetadataEntry;
import guilibshadow.cafe4j.image.meta.MetadataType;
import guilibshadow.cafe4j.image.png.Chunk;
import guilibshadow.cafe4j.image.png.ChunkType;
import guilibshadow.cafe4j.image.png.TIMEBuilder;
import guilibshadow.cafe4j.image.png.TIMEReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class TIMEChunk
extends Metadata {
    private static final String[] MONTH = new String[]{"", "January", "Febrary", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private Chunk chunk;
    private int year;
    private int month;
    private int day;
    private int hour;
    private int minute;
    private int second;

    private static MetadataType validate(ChunkType chunkType) {
        if (chunkType == null) {
            throw new IllegalArgumentException("ChunkType is null");
        }
        if (chunkType == ChunkType.TIME) {
            return MetadataType.PNG_TIME;
        }
        throw new IllegalArgumentException("Input ChunkType is not tIME chunk!");
    }

    private static void checkDate(int year, int month, int day, int hour, int minute, int second) {
        if (year > Short.MAX_VALUE || year < Short.MIN_VALUE) {
            throw new IllegalArgumentException("Year out of range: -32768 - 32767");
        }
        if (month > 12 || month < 1) {
            throw new IllegalArgumentException("Month out of range: 1-12");
        }
        if (day > 31 || day < 1) {
            throw new IllegalArgumentException("Day out of range: 1-31");
        }
        if (hour > 23 || hour < 0) {
            throw new IllegalArgumentException("Hour out of range: 0-23");
        }
        if (minute > 59 || minute < 0) {
            throw new IllegalArgumentException("Minute out of range: 0-59");
        }
        if (second > 60 || second < 0) {
            throw new IllegalArgumentException("Second out of range: 0-60");
        }
    }

    public TIMEChunk(Chunk chunk) {
        super(TIMEChunk.validate(chunk.getChunkType()), chunk.getData());
        this.chunk = chunk;
        this.ensureDataRead();
    }

    public TIMEChunk(ChunkType chunkType, int year, int month, int day, int hour, int minute, int second) {
        super(TIMEChunk.validate(chunkType));
        TIMEChunk.checkDate(year, month, day, hour, minute, second);
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.isDataRead = true;
    }

    public Chunk getChunk() {
        if (this.chunk == null) {
            this.chunk = new TIMEBuilder().year(this.year).month(this.month).day(this.day).hour(this.hour).minute(this.minute).second(this.second).build();
        }
        return this.chunk;
    }

    @Override
    public byte[] getData() {
        return this.getChunk().getData();
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getMonth() {
        return this.month;
    }

    public int getSecond() {
        return this.second;
    }

    public int getYear() {
        return this.year;
    }

    @Override
    public Iterator<MetadataEntry> iterator() {
        this.ensureDataRead();
        ArrayList<MetadataEntry> entries = new ArrayList<MetadataEntry>();
        entries.add(new MetadataEntry("UTC (Time of last modification)", this.day + " " + (this.month > 0 && this.month <= 12 ? MONTH[this.month] : "()") + " " + this.year + ", " + this.hour + ":" + this.minute + ":" + this.second));
        return Collections.unmodifiableCollection(entries).iterator();
    }

    @Override
    public void read() throws IOException {
        if (!this.isDataRead) {
            TIMEReader reader = new TIMEReader(this.chunk);
            this.year = reader.getYear();
            this.month = reader.getMonth();
            this.day = reader.getDay();
            this.hour = reader.getHour();
            this.minute = reader.getMinute();
            this.second = reader.getSecond();
            this.isDataRead = true;
        }
    }

    @Override
    public void write(OutputStream os) throws IOException {
        this.getChunk().write(os);
    }
}

